/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.encog.EncogError;

public final class ResourceLoader {
    public static InputStream createInputStream(String resource) {
        ClassLoader loader = ResourceLoader.class.getClassLoader();
        InputStream is = loader.getResourceAsStream(resource);
        if (is == null) {
            String str = "Can't read resource: " + resource;
            throw new EncogError(str);
        }
        return is;
    }

    public static String loadString(String resource) {
        InputStream is = null;
        try {
            String line;
            is = ResourceLoader.createInputStream(resource);
            StringBuilder result = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                result.append(line);
                result.append("\r\n");
            }
            String string = result.toString();
            return string;
        }
        catch (IOException e) {
            throw new EncogError(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new EncogError(e);
            }
        }
    }

    private ResourceLoader() {
    }
}

