# Pulp Release History

## 9.0.1

* Improved error messages in the case where submitting a package to Pursuit as
  part of `pulp publish` fails.
* Update README to use `bower uninstall` instead of the undocumented and
  presumably deprecated `bower rm` (@menelaos, #215).

## 9.0.0

* Compatibility with version 0.9 of the PureScript compiler. Pulp no longer
  works with earlier versions of the PureScript compiler; to use earlier
  versions, you will need to downgrade to a previous version of Pulp.
* Fix a bug where the version of psc being used was not being printed properly
  (#210).

## 8.2.1

* Remove unused npm dependencies (`xhr2`, `ansi`, and `supports-color`).
* Fix Pulp's description in package.json; Pulp is not a package manager.

## 8.2.0

* Update the dependency on `watchpack` to fix deprecation warnings (#196).
* Add a `--no-push` flag to `pulp publish`, allowing you to skip pushing
  tags to a Git remote as part of publishing (#201).
* Add a `--push-to` option to `pulp publish`, allowing you to push to a
  specific Git remote (#201).

## 8.2.0-rc.3

* Actually fix `pulp login` (which was *still* broken).
* Include the response body for any errors from the GitHub API in `pulp login`.

## 8.2.0-rc.2

* Remove the `moduleType` field from the bower.json file generated by `pulp
  init`.
* Fix `pulp login` using the wrong environment variable for the home directory
  on Windows (#197).
* Fix `pulp login` failing to check the auth token with GitHub (#199).
* Don't require being inside a project to run `pulp init` (#200).

## 8.2.0-rc.1

* Added `pulp version` for bumping versions and creating git tags for releases
  of PureScript packages, as well as `pulp publish` for sending those releases
  out into the world. See `pulp version --help` and `pulp publish --help` for
  more info.

## 8.1.1

* Revert to an open Prelude import in the default code generated by `pulp
  init`.

## 8.1.0

* Fix `pulp browserify` hanging on Windows.
* Fix `--dependency-path` and `--monochrome` options not being honoured
  when using psa.
* Add `pulp login`, which will be useful later along with the upcoming
  `pulp release`.
* Fix compiler warnings in PureScript source files generated by `pulp init`.

## 8.0.0

* Pulp's rebuild logic has been removed, as it was causing more
  trouble than it was worth. This means the `--force` flag is now once
  again only available on `pulp browserify`, to force a
  non-incremental build.
* Pulp will now use the
  [`psa`](https://github.com/natefaubion/purescript-psa) tool instead
  of `psc` if available on your path. You can disable this behaviour
  by passing the `--no-psa` flag.

Bugs fixed: #140.

## 7.0.0

* Remove the `--engine` option, since the `--runtime` option fulfils the same
  need.
* Fix the `--runtime` option, which was previously broken. (#143)
* Fix a bug where Pulp was sometimes using terminal ANSI codes for colours
  when it shouldn't have been, and not using them when it should. (#147)
* Relay interrupts (Ctrl+C) to `psci` when running `pulp psci`, so that
  long-running commands can be interrupted, and to stop the "hGetChar:
  hardware fault (Input/output error)" message from being shown. (#88)

## 6.2.1

* Fix the `--watch` option, which was broken in 6.2.0.
* Remove the `--optimise` option for `pulp test` and `pulp server`, since it
  doesn't really make sense with these commands.

## 6.2.0

* `pulp dep` is now deprecated. It continues to work as before, but
  you will have to install Bower yourself in order to use it. It’s
  recommended that you use Bower directly instead.
* New global options `--before` and `--else` to complement `--then`.
* `--skip-entry-point` now works when using `pulp build --to`.

## 6.1.0

* You can now use `pulp browserify --standalone <module-name>` to
  produce a browserified bundle wrapped in a UMD header, which can be
  `require()`d, and which re-exports the main module of your
  PureScript project. It works by invoking `browserify --standalone`;
  see
  [the Browserify documentation](https://github.com/substack/node-browserify#usage).

## 6.0.1

* Remove unnecessary `postinstall` script.

## 6.0.0

* Pulp has been ported to PureScript :)

* The `--with-deps` flag for `pulp docs` has been renamed to
  `--with-dependencies`.

Bugs fixed: #123, #122, #121, #111, #108, #92.

## 5.0.2

Bugs fixed: #109.

## 5.0.1

Bugs fixed: #105, #106, #107, #113.

## 5.0.0

* Pulp will now skip the build step if your project hasn't changed
  since your last rebuild.

* The `--force` flag is now avaliable on all commands that trigger a
  build, and will force a rebuild regardless of whether your project
  has changed. It still also forces a non-incremental build when
  used with `pulp browserify`.

* You can now use the flags `--src-path`, `--test-path` and
  `--dependency-path` to override the normal locations for these
  directories.

* The format for passing multiple directories to `--include` has
  changed: you now separate directories using the standard system path
  delimiter, as opposed to spaces.
