/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolymorphicMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CastExpression
extends Expression {
    public Expression expression;
    public TypeReference type;
    public TypeBinding expectedType;

    public CastExpression(Expression expression, TypeReference typeReference) {
        this.expression = expression;
        this.type = typeReference;
        typeReference.bits |= 0x40000000;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        UnconditionalFlowInfo unconditionalFlowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
        this.expression.checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
        flowContext.recordAbruptExit();
        return unconditionalFlowInfo;
    }

    public static void checkNeedForAssignedCast(BlockScope blockScope, TypeBinding typeBinding, CastExpression castExpression) {
        CompilerOptions compilerOptions = blockScope.compilerOptions();
        if (compilerOptions.getSeverity(0x4000000) == 256) {
            return;
        }
        TypeBinding typeBinding2 = castExpression.expression.resolvedType;
        if (typeBinding2 == null || castExpression.resolvedType.isBaseType()) {
            return;
        }
        if (typeBinding2.isCompatibleWith(typeBinding, blockScope)) {
            if (blockScope.environment().usesNullTypeAnnotations() && NullAnnotationMatching.analyse(typeBinding, typeBinding2, -1).isAnyMismatch()) {
                return;
            }
            blockScope.problemReporter().unnecessaryCast(castExpression);
        }
    }

    public static void checkNeedForCastCast(BlockScope blockScope, CastExpression castExpression) {
        if (blockScope.compilerOptions().getSeverity(0x4000000) == 256) {
            return;
        }
        CastExpression castExpression2 = (CastExpression)castExpression.expression;
        if ((castExpression2.bits & 0x4000) == 0) {
            return;
        }
        CastExpression castExpression3 = new CastExpression(null, castExpression.type);
        castExpression3.resolvedType = castExpression.resolvedType;
        if (!castExpression3.checkCastTypesCompatibility(blockScope, castExpression.resolvedType, castExpression2.expression.resolvedType, null)) {
            return;
        }
        blockScope.problemReporter().unnecessaryCast(castExpression2);
    }

    public static void checkNeedForEnclosingInstanceCast(BlockScope blockScope, Expression expression, TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (blockScope.compilerOptions().getSeverity(0x4000000) == 256) {
            return;
        }
        TypeBinding typeBinding3 = ((CastExpression)expression).expression.resolvedType;
        if (typeBinding3 == null) {
            return;
        }
        if (TypeBinding.equalsEquals(typeBinding3, typeBinding)) {
            blockScope.problemReporter().unnecessaryCast((CastExpression)expression);
        } else {
            if (typeBinding3 == TypeBinding.NULL) {
                return;
            }
            TypeBinding typeBinding4 = typeBinding3;
            if (typeBinding3.isBaseType() || typeBinding3.isArrayType()) {
                return;
            }
            if (TypeBinding.equalsEquals(typeBinding2, blockScope.getMemberType(typeBinding2.sourceName(), (ReferenceBinding)typeBinding4))) {
                blockScope.problemReporter().unnecessaryCast((CastExpression)expression);
            }
        }
    }

    public static void checkNeedForArgumentCast(BlockScope blockScope, int n, int n2, Expression expression, int n3) {
        if (blockScope.compilerOptions().getSeverity(0x4000000) == 256) {
            return;
        }
        if ((expression.bits & 0x4000) == 0 && expression.resolvedType.isBaseType()) {
            return;
        }
        TypeBinding typeBinding = ((CastExpression)expression).expression.resolvedType;
        if (typeBinding == null) {
            return;
        }
        if (typeBinding.id == n3) {
            blockScope.problemReporter().unnecessaryCast((CastExpression)expression);
            return;
        }
    }

    public static void checkNeedForArgumentCasts(BlockScope blockScope, Expression expression, TypeBinding typeBinding, MethodBinding methodBinding, Expression[] expressionArray, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        if (blockScope.compilerOptions().getSeverity(0x4000000) == 256) {
            return;
        }
        int n = typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = typeBindingArray;
        for (int i = 0; i < n; ++i) {
            Expression expression2 = expressionArray[i];
            if (!(expression2 instanceof CastExpression) || (expression2.bits & 0x4000) == 0 && expression2.resolvedType.isBaseType()) continue;
            TypeBinding typeBinding2 = ((CastExpression)expression2).expression.resolvedType;
            if (typeBinding2 == null) {
                return;
            }
            if (TypeBinding.equalsEquals(typeBinding2, typeBindingArray[i])) {
                blockScope.problemReporter().unnecessaryCast((CastExpression)expression2);
                continue;
            }
            if (typeBinding2 == TypeBinding.NULL || (expression2.implicitConversion & 0x200) != 0) continue;
            if (typeBindingArray2 == typeBindingArray) {
                TypeBinding[] typeBindingArray3 = typeBindingArray2;
                typeBindingArray2 = new TypeBinding[n];
                System.arraycopy(typeBindingArray3, 0, typeBindingArray2, 0, n);
            }
            typeBindingArray2[i] = typeBinding2;
        }
        if (typeBindingArray2 != typeBindingArray) {
            CastExpression.checkAlternateBinding(blockScope, expression, typeBinding, methodBinding, expressionArray, typeBindingArray, typeBindingArray2, invocationSite);
        }
    }

    public static void checkNeedForArgumentCasts(BlockScope blockScope, int n, int n2, Expression expression, int n3, boolean bl, Expression expression2, int n4, boolean bl2) {
        if (blockScope.compilerOptions().getSeverity(0x4000000) == 256) {
            return;
        }
        int n5 = n3;
        if (bl) {
            if ((expression.bits & 0x4000) == 0 && expression.resolvedType.isBaseType()) {
                bl = false;
            } else {
                TypeBinding typeBinding = ((CastExpression)expression).expression.resolvedType;
                if (typeBinding == null) {
                    return;
                }
                n5 = typeBinding.id;
                if (n5 == n3 || blockScope.environment().computeBoxingType((TypeBinding)typeBinding).id == n3) {
                    blockScope.problemReporter().unnecessaryCast((CastExpression)expression);
                    bl = false;
                } else if (n5 == 12) {
                    n5 = n3;
                    bl = false;
                }
            }
        }
        int n6 = n4;
        if (bl2) {
            if ((expression2.bits & 0x4000) == 0 && expression2.resolvedType.isBaseType()) {
                bl2 = false;
            } else {
                TypeBinding typeBinding = ((CastExpression)expression2).expression.resolvedType;
                if (typeBinding == null) {
                    return;
                }
                n6 = typeBinding.id;
                if (n6 == n4 || blockScope.environment().computeBoxingType((TypeBinding)typeBinding).id == n4) {
                    blockScope.problemReporter().unnecessaryCast((CastExpression)expression2);
                    bl2 = false;
                } else if (n6 == 12) {
                    n6 = n4;
                    bl2 = false;
                }
            }
        }
        if (bl || bl2) {
            int n7;
            if (n5 > 15 || n6 > 15) {
                if (n5 == 11) {
                    n6 = 1;
                } else if (n6 == 11) {
                    n5 = 1;
                } else {
                    return;
                }
            }
            if ((n2 & 0xF0F0F) == ((n7 = OperatorExpression.OperatorSignatures[n][(n5 << 4) + n6]) & 0xF0F0F)) {
                if (bl) {
                    blockScope.problemReporter().unnecessaryCast((CastExpression)expression);
                }
                if (bl2) {
                    blockScope.problemReporter().unnecessaryCast((CastExpression)expression2);
                }
            }
        }
    }

    @Override
    public boolean checkNPE(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, int n) {
        this.checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
        return this.expression.checkNPE(blockScope, flowContext, flowInfo, n);
    }

    private static void checkAlternateBinding(BlockScope blockScope, Expression expression, TypeBinding typeBinding, MethodBinding methodBinding, Expression[] expressionArray, TypeBinding[] typeBindingArray, TypeBinding[] typeBindingArray2, final InvocationSite invocationSite) {
        MethodBinding methodBinding2;
        InvocationSite invocationSite2 = new InvocationSite(){

            @Override
            public TypeBinding[] genericTypeArguments() {
                return null;
            }

            @Override
            public boolean isSuperAccess() {
                return invocationSite.isSuperAccess();
            }

            @Override
            public boolean isTypeAccess() {
                return invocationSite.isTypeAccess();
            }

            @Override
            public void setActualReceiverType(ReferenceBinding referenceBinding) {
            }

            @Override
            public void setDepth(int n) {
            }

            @Override
            public void setFieldIndex(int n) {
            }

            @Override
            public int sourceStart() {
                return 0;
            }

            @Override
            public int sourceEnd() {
                return 0;
            }

            @Override
            public TypeBinding invocationTargetType() {
                return invocationSite.invocationTargetType();
            }

            @Override
            public boolean receiverIsImplicitThis() {
                return invocationSite.receiverIsImplicitThis();
            }

            @Override
            public InferenceContext18 freshInferenceContext(Scope scope) {
                return invocationSite.freshInferenceContext(scope);
            }

            @Override
            public ExpressionContext getExpressionContext() {
                return invocationSite.getExpressionContext();
            }

            @Override
            public boolean isQualifiedSuper() {
                return invocationSite.isQualifiedSuper();
            }

            @Override
            public boolean checkingPotentialCompatibility() {
                return false;
            }

            @Override
            public void acceptPotentiallyCompatibleMethods(MethodBinding[] methodBindingArray) {
            }
        };
        if (methodBinding.isConstructor()) {
            methodBinding2 = blockScope.getConstructor((ReferenceBinding)typeBinding, typeBindingArray2, invocationSite2);
        } else {
            MethodBinding methodBinding3 = methodBinding2 = expression.isImplicitThis() ? blockScope.getImplicitMethod(methodBinding.selector, typeBindingArray2, invocationSite2) : blockScope.getMethod(typeBinding, methodBinding.selector, typeBindingArray2, invocationSite2);
        }
        if (methodBinding2 == methodBinding) {
            int n;
            int n2 = typeBindingArray.length;
            if (methodBinding.isVarargs() && (n = methodBinding.parameters.length) == n2) {
                int n3 = n - 1;
                ArrayBinding arrayBinding = (ArrayBinding)methodBinding.parameters[n3];
                TypeBinding typeBinding2 = typeBindingArray2[n3];
                if (arrayBinding.dimensions != typeBinding2.dimensions()) {
                    return;
                }
                if (typeBinding2.isCompatibleWith(arrayBinding.elementsType()) && typeBinding2.isCompatibleWith(arrayBinding)) {
                    return;
                }
            }
            for (n = 0; n < n2; ++n) {
                if (!TypeBinding.notEquals(typeBindingArray[n], typeBindingArray2[n])) continue;
                blockScope.problemReporter().unnecessaryCast((CastExpression)expressionArray[n]);
            }
        }
    }

    @Override
    public boolean checkUnsafeCast(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3, boolean bl) {
        if (TypeBinding.equalsEquals(typeBinding3, typeBinding)) {
            if (!(bl || !TypeBinding.equalsEquals(typeBinding3, this.resolvedType.leafComponentType()) || typeBinding2.isParameterizedType() && typeBinding2.isProvablyDistinct(typeBinding))) {
                this.tagAsUnnecessaryCast(scope, typeBinding);
            }
            return true;
        }
        if (typeBinding3 != null && (bl ? typeBinding3.isProvablyDistinct(typeBinding2) : typeBinding.isProvablyDistinct(typeBinding3))) {
            return false;
        }
        block0 : switch (typeBinding.kind()) {
            case 260: {
                if (typeBinding.isReifiable()) break;
                if (typeBinding3 == null) {
                    this.bits |= 0x80;
                    return true;
                }
                switch (typeBinding3.kind()) {
                    case 260: {
                        if (bl) {
                            int n;
                            if (typeBinding2.isRawType() || !typeBinding2.isEquivalentTo(typeBinding3)) {
                                this.bits |= 0x80;
                                return true;
                            }
                            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
                            ParameterizedTypeBinding parameterizedTypeBinding2 = (ParameterizedTypeBinding)typeBinding3;
                            TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
                            int n2 = n = typeBindingArray == null ? 0 : typeBindingArray.length;
                            if (parameterizedTypeBinding2.arguments == null || n > parameterizedTypeBinding2.arguments.length) {
                                this.bits |= 0x80;
                            } else if ((parameterizedTypeBinding.tagBits & 0x60000000L) != 0L) {
                                block12: for (int i = 0; i < n; ++i) {
                                    switch (typeBindingArray[i].kind()) {
                                        case 516: 
                                        case 4100: {
                                            break;
                                        }
                                        default: {
                                            continue block12;
                                        }
                                    }
                                    TypeBinding[] typeBindingArray2 = new TypeBinding[n];
                                    System.arraycopy(parameterizedTypeBinding.arguments, 0, typeBindingArray2, 0, n);
                                    typeBindingArray2[i] = scope.getJavaLangObject();
                                    LookupEnvironment lookupEnvironment = scope.environment();
                                    ParameterizedTypeBinding parameterizedTypeBinding3 = lookupEnvironment.createParameterizedType((ReferenceBinding)typeBinding.erasure(), typeBindingArray2, typeBinding.enclosingType());
                                    if (!TypeBinding.equalsEquals(parameterizedTypeBinding3.findSuperTypeOriginatingFrom(typeBinding2), typeBinding3)) continue;
                                    this.bits |= 0x80;
                                    break;
                                }
                            }
                            return true;
                        }
                        if (typeBinding3.isEquivalentTo(typeBinding)) break block0;
                        this.bits |= 0x80;
                        return true;
                    }
                    case 1028: {
                        this.bits |= 0x80;
                        return true;
                    }
                }
                if (!bl) break;
                this.bits |= 0x80;
                return true;
            }
            case 68: {
                TypeBinding typeBinding4 = typeBinding.leafComponentType();
                if (!bl || typeBinding4.isReifiable() && !typeBinding4.isTypeVariable()) break;
                this.bits |= 0x80;
                return true;
            }
            case 4100: {
                this.bits |= 0x80;
                return true;
            }
        }
        if (!bl && TypeBinding.equalsEquals(typeBinding3, this.resolvedType.leafComponentType())) {
            this.tagAsUnnecessaryCast(scope, typeBinding);
        }
        return true;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        boolean bl2;
        int n = codeStream.position;
        boolean bl3 = (this.type.bits & 0x100000) != 0;
        boolean bl4 = bl2 = (this.bits & 0x40) != 0;
        if (this.constant != Constant.NotAConstant) {
            if (bl || bl2 || bl3) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
                if (bl2 || bl3) {
                    codeStream.checkcast(this.type, this.resolvedType, n);
                }
                if (!bl) {
                    codeStream.pop();
                }
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        this.expression.generateCode(blockScope, codeStream, bl3 || bl || bl2);
        if (bl3 || bl2 && TypeBinding.notEquals(this.expression.postConversionType(blockScope), this.resolvedType.erasure())) {
            codeStream.checkcast(this.type, this.resolvedType, n);
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else if (bl3 || bl2) {
            switch (this.resolvedType.id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public Expression innermostCastedExpression() {
        Expression expression = this.expression;
        while (expression instanceof CastExpression) {
            expression = ((CastExpression)expression).expression;
        }
        return expression;
    }

    @Override
    public LocalVariableBinding localVariableBinding() {
        return this.expression.localVariableBinding();
    }

    @Override
    public int nullStatus(FlowInfo flowInfo, FlowContext flowContext) {
        if ((this.implicitConversion & 0x200) != 0) {
            return 4;
        }
        return this.expression.nullStatus(flowInfo, flowContext);
    }

    @Override
    public Constant optimizedBooleanConstant() {
        switch (this.resolvedType.id) {
            case 5: 
            case 33: {
                return this.expression.optimizedBooleanConstant();
            }
        }
        return Constant.NotAConstant;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2 = (this.bits & 0x1FE00000) >> 21;
        String string = "";
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append('(');
            string = string + ')';
        }
        stringBuffer.append('(');
        this.type.print(0, stringBuffer).append(") ");
        return this.expression.printExpression(0, stringBuffer).append(string);
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        this.constant = Constant.NotAConstant;
        this.implicitConversion = 0;
        boolean bl = false;
        TypeBinding typeBinding = this.resolvedType = this.type.resolveType(blockScope);
        if (blockScope.compilerOptions().sourceLevel >= 0x340000L) {
            this.expression.setExpressionContext(ExpressionContext.CASTING_CONTEXT);
            if (this.expression instanceof FunctionalExpression) {
                this.expression.setExpectedType(this.resolvedType);
                this.bits |= 0x20;
            }
        }
        if (this.expression instanceof CastExpression) {
            this.expression.bits |= 0x20;
            bl = true;
        }
        TypeBinding typeBinding2 = this.expression.resolveType(blockScope);
        if (this.expression instanceof MessageSend) {
            MessageSend messageSend = (MessageSend)this.expression;
            MethodBinding methodBinding = messageSend.binding;
            if (methodBinding != null && methodBinding.isPolymorphic()) {
                messageSend.binding = blockScope.environment().updatePolymorphicMethodReturnType((PolymorphicMethodBinding)methodBinding, typeBinding);
                if (TypeBinding.notEquals(typeBinding2, typeBinding)) {
                    typeBinding2 = typeBinding;
                    this.bits |= 0x20;
                }
            }
        }
        if (typeBinding != null) {
            if (typeBinding2 != null) {
                boolean bl2 = blockScope.compilerOptions().isAnnotationBasedNullAnalysisEnabled && NullAnnotationMatching.analyse(typeBinding, typeBinding2, -1).isAnyMismatch();
                boolean bl3 = this.checkCastTypesCompatibility(blockScope, typeBinding, typeBinding2, this.expression);
                if (bl3) {
                    this.expression.computeConversion(blockScope, typeBinding, typeBinding2);
                    if ((this.bits & 0x80) != 0) {
                        if (blockScope.compilerOptions().reportUnavoidableGenericTypeProblems || !typeBinding2.isRawType() || !this.expression.forcedToBeRaw(blockScope.referenceContext())) {
                            blockScope.problemReporter().unsafeCast(this, blockScope);
                        }
                    } else if (bl2) {
                        blockScope.problemReporter().unsafeNullnessCast(this, blockScope);
                    } else {
                        if (typeBinding.isRawType() && blockScope.compilerOptions().getSeverity(0x20010000) != 256) {
                            blockScope.problemReporter().rawTypeReference(this.type, typeBinding);
                        }
                        if ((this.bits & 0x4020) == 16384 && !this.isIndirectlyUsed()) {
                            blockScope.problemReporter().unnecessaryCast(this);
                        }
                    }
                } else {
                    if ((typeBinding.tagBits & 0x80L) == 0L) {
                        blockScope.problemReporter().typeCastError(this, typeBinding, typeBinding2);
                    }
                    this.bits |= 0x20;
                }
            }
            this.resolvedType = typeBinding.capture(blockScope, this.type.sourceStart, this.type.sourceEnd);
            if (bl) {
                CastExpression.checkNeedForCastCast(blockScope, this);
            }
        }
        return this.resolvedType;
    }

    @Override
    public void setExpectedType(TypeBinding typeBinding) {
        this.expectedType = typeBinding;
    }

    private boolean isIndirectlyUsed() {
        MethodBinding methodBinding;
        if (this.expression instanceof MessageSend && (methodBinding = ((MessageSend)this.expression).binding) instanceof ParameterizedGenericMethodBinding && ((ParameterizedGenericMethodBinding)methodBinding).inferredReturnType) {
            if (this.expectedType == null) {
                return true;
            }
            if (TypeBinding.notEquals(this.resolvedType, this.expectedType)) {
                return true;
            }
        }
        return this.expectedType != null && this.resolvedType.isBaseType() && !this.resolvedType.isCompatibleWith(this.expectedType);
    }

    @Override
    public void tagAsNeedCheckCast() {
        this.bits |= 0x40;
    }

    @Override
    public void tagAsUnnecessaryCast(Scope scope, TypeBinding typeBinding) {
        this.bits |= 0x4000;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.type.traverse(aSTVisitor, blockScope);
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

