/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.tasks.list;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.list.TaskInfo;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamInputReader;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class ListTasksResponse
extends BaseTasksResponse
implements ToXContent {
    private List<TaskInfo> tasks;
    private Map<DiscoveryNode, List<TaskInfo>> nodes;

    public ListTasksResponse() {
    }

    public ListTasksResponse(List<TaskInfo> tasks, List<TaskOperationFailure> taskFailures, List<? extends FailedNodeException> nodeFailures) {
        super(taskFailures, nodeFailures);
        this.tasks = tasks == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<TaskInfo>(tasks));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.tasks = Collections.unmodifiableList(in.readList(new StreamInputReader<TaskInfo>(){

            @Override
            public TaskInfo read(StreamInput t) throws IOException {
                return new TaskInfo(t);
            }
        }));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.tasks);
    }

    public Map<DiscoveryNode, List<TaskInfo>> getPerNodeTasks() {
        if (this.nodes != null) {
            return this.nodes;
        }
        HashMap<DiscoveryNode, List<TaskInfo>> nodeTasks = new HashMap<DiscoveryNode, List<TaskInfo>>();
        HashSet<DiscoveryNode> nodes = new HashSet<DiscoveryNode>();
        for (TaskInfo shard : this.tasks) {
            nodes.add(shard.getNode());
        }
        for (DiscoveryNode node : nodes) {
            ArrayList<TaskInfo> tasks = new ArrayList<TaskInfo>();
            for (TaskInfo taskInfo : this.tasks) {
                if (!taskInfo.getNode().equals(node)) continue;
                tasks.add(taskInfo);
            }
            nodeTasks.put(node, tasks);
        }
        this.nodes = nodeTasks;
        return nodeTasks;
    }

    public List<TaskInfo> getTasks() {
        return this.tasks;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.getTaskFailures() != null && this.getTaskFailures().size() > 0) {
            builder.startArray("task_failures");
            for (TaskOperationFailure taskOperationFailure : this.getTaskFailures()) {
                builder.startObject();
                builder.value(taskOperationFailure);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.getNodeFailures() != null && this.getNodeFailures().size() > 0) {
            builder.startArray("node_failures");
            for (FailedNodeException failedNodeException : this.getNodeFailures()) {
                builder.startObject();
                failedNodeException.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
        builder.startObject("nodes");
        for (Map.Entry entry : this.getPerNodeTasks().entrySet()) {
            DiscoveryNode node = (DiscoveryNode)entry.getKey();
            builder.startObject(node.getId(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("name", node.name());
            builder.field("transport_address", node.address().toString());
            builder.field("host", node.getHostName());
            builder.field("ip", (Object)node.getAddress());
            if (!node.attributes().isEmpty()) {
                builder.startObject("attributes");
                for (Map.Entry attr : node.attributes().entrySet()) {
                    builder.field((String)attr.getKey(), (String)attr.getValue(), XContentBuilder.FieldCaseConversion.NONE);
                }
                builder.endObject();
            }
            builder.startObject("tasks");
            for (TaskInfo task : (List)entry.getValue()) {
                builder.startObject(task.getTaskId().toString(), XContentBuilder.FieldCaseConversion.NONE);
                task.toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }
}

