/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.NotCompressedException;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.compress.deflate.DeflateCompressor;
import org.elasticsearch.common.compress.lzf.LZFCompressor;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.jboss.netty.buffer.ChannelBuffer;

public class CompressorFactory {
    private static final Compressor[] compressors = new Compressor[]{new LZFCompressor(), new DeflateCompressor()};
    private static volatile Compressor defaultCompressor = new DeflateCompressor();

    public static void setDefaultCompressor(Compressor defaultCompressor) {
        CompressorFactory.defaultCompressor = defaultCompressor;
    }

    public static Compressor defaultCompressor() {
        return defaultCompressor;
    }

    public static boolean isCompressed(BytesReference bytes) {
        return CompressorFactory.compressor(bytes) != null;
    }

    @Deprecated
    public static boolean isCompressed(IndexInput in) throws IOException {
        return CompressorFactory.compressor(in) != null;
    }

    @Nullable
    public static Compressor compressor(BytesReference bytes) {
        for (Compressor compressor : compressors) {
            if (!compressor.isCompressed(bytes)) continue;
            assert (XContentFactory.xContentType(bytes) == null);
            return compressor;
        }
        XContentType contentType = XContentFactory.xContentType(bytes);
        if (contentType == null) {
            throw new NotXContentException("Compressor detection can only be called on some xcontent bytes or compressed xcontent bytes");
        }
        return null;
    }

    public static Compressor compressor(ChannelBuffer buffer) {
        for (Compressor compressor : compressors) {
            if (!compressor.isCompressed(buffer)) continue;
            return compressor;
        }
        throw new NotCompressedException();
    }

    @Deprecated
    @Nullable
    public static Compressor compressor(IndexInput in) throws IOException {
        for (Compressor compressor : compressors) {
            if (!compressor.isCompressed(in)) continue;
            return compressor;
        }
        return null;
    }

    public static BytesReference uncompressIfNeeded(BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(bytes);
        BytesReference uncompressed = compressor != null ? CompressorFactory.uncompress(bytes, compressor) : bytes;
        return uncompressed;
    }

    public static BytesReference uncompress(BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor == null) {
            throw new NotCompressedException();
        }
        return CompressorFactory.uncompress(bytes, compressor);
    }

    private static BytesReference uncompress(BytesReference bytes, Compressor compressor) throws IOException {
        StreamInput compressed = compressor.streamInput(bytes.streamInput());
        BytesStreamOutput bStream = new BytesStreamOutput();
        Streams.copy(compressed, (OutputStream)bStream);
        compressed.close();
        return bStream.bytes();
    }
}

