If you set up Vim plugin for fzf, `:FZF` command will become available. The following variables are used to configure its behavior.

- `g:fzf_action`
    - Customizable extra key bindings for opening selected files in different ways
- ~~`g:fzf_height`~~ (deprecated, use `g:fzf_layout` instead)
- `g:fzf_layout`
    - Determines the size and position of fzf window (tmux pane or Neovim split)
- `g:fzf_launcher`
    - (Only in GVim) Terminal emulator to open fzf with
    - `g:Fzf_launcher` for function reference

### Examples

```vim
" This is the default extra key bindings
let g:fzf_action = {
  \ 'ctrl-t': 'tab split',
  \ 'ctrl-x': 'split',
  \ 'ctrl-v': 'vsplit' }

" Default fzf layout
" - down / up / left / right
let g:fzf_layout = { 'down': '~40%' }

" In Neovim, you can set up fzf window using a Vim command
let g:fzf_layout = { 'window': 'enew' }
let g:fzf_layout = { 'window': '-tabnew' }
```

### GVim

In GVim, you need an external terminal emulator to start fzf with. `xterm`
command is used by default, but you can customize it with `g:fzf_launcher`.

```vim
" This is the default. %s is replaced with fzf command
let g:fzf_launcher = 'xterm -e bash -ic %s'

" Use urxvt instead
let g:fzf_launcher = 'urxvt -geometry 120x30 -e sh -c %s'
```

If you're running MacVim on OSX, I recommend you to use iTerm2 as the
launcher. Refer to the [this wiki page][macvim-iterm2] to see how to set up.

[macvim-iterm2]: https://github.com/junegunn/fzf/wiki/On-MacVim-with-iTerm2