/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.debug;

import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.object.TypedLocation;
import com.oracle.truffle.api.utilities.JSONHelper;
import com.oracle.truffle.object.DebugShapeVisitor;
import com.oracle.truffle.object.Locations;
import com.oracle.truffle.object.Transition;
import java.util.Map;

public class JSONShapeVisitor
extends DebugShapeVisitor<JSONHelper.JSONObjectBuilder> {
    @Override
    public JSONHelper.JSONObjectBuilder visitShape(Shape shape, Map<? extends Transition, ? extends Shape> transitions) {
        JSONHelper.JSONObjectBuilder sb = JSONHelper.object();
        JSONHelper.JSONArrayBuilder transitionarray = JSONHelper.array();
        for (Map.Entry<? extends Transition, ? extends Shape> entry : transitions.entrySet()) {
            transitionarray.add(JSONHelper.object().add("transition", this.dumpTransition(entry.getKey())).add("successor", JSONShapeVisitor.getId(entry.getValue())));
        }
        JSONHelper.JSONArrayBuilder propertiesarray = JSONHelper.array();
        for (Property p : shape.getPropertyList()) {
            propertiesarray.add(this.dumpProperty(p));
        }
        sb.add("id", JSONShapeVisitor.getId(shape));
        sb.add("properties", propertiesarray);
        sb.add("transitions", transitionarray);
        sb.add("predecessor", shape.getParent() != null ? JSONShapeVisitor.getId(shape.getParent()) : null);
        sb.add("valid", shape.isValid());
        return sb;
    }

    public JSONHelper.JSONObjectBuilder dumpProperty(Property property) {
        return JSONHelper.object().add("id", property.getKey().toString()).add("location", this.dumpLocation(property.getLocation())).add("flags", property.getFlags());
    }

    public JSONHelper.JSONObjectBuilder dumpTransition(Transition transition) {
        JSONHelper.JSONObjectBuilder sb = JSONHelper.object().add("type", transition.toString());
        if (transition instanceof Transition.PropertyTransition) {
            sb.add("property", this.dumpProperty(((Transition.PropertyTransition)transition).getProperty()));
        }
        return sb;
    }

    public JSONHelper.JSONObjectBuilder dumpLocation(Location location) {
        JSONHelper.JSONObjectBuilder obj = JSONHelper.object();
        obj.add("type", (location instanceof TypedLocation ? ((TypedLocation)((Object)location)).getType() : Object.class).getName());
        if (location instanceof Locations.ValueLocation) {
            obj.add("value", String.valueOf(((Locations.ValueLocation)location).get(null, false)));
        }
        return obj;
    }
}

