/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.locals.LocalVariableType;
import org.jruby.truffle.language.locals.ReadFrameSlotNode;
import org.jruby.truffle.language.locals.ReadFrameSlotNodeGen;
import org.jruby.truffle.language.locals.WriteDeclarationVariableNode;
import org.jruby.truffle.language.parser.jruby.ReadLocalNode;

public class ReadDeclarationVariableNode
extends ReadLocalNode {
    private final LocalVariableType type;
    private final int frameDepth;
    private final FrameSlot frameSlot;
    @Node.Child
    private ReadFrameSlotNode readFrameSlotNode;

    public ReadDeclarationVariableNode(RubyContext context, SourceSection sourceSection, LocalVariableType type, int frameDepth, FrameSlot frameSlot) {
        super(context, sourceSection);
        this.type = type;
        this.frameDepth = frameDepth;
        this.frameSlot = frameSlot;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.readFrameSlot(frame);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        switch (this.type) {
            case FRAME_LOCAL: {
                return this.coreStrings().LOCAL_VARIABLE.createInstance();
            }
            case FRAME_LOCAL_GLOBAL: {
                if (this.readFrameSlot(frame) != this.nil()) {
                    return this.coreStrings().GLOBAL_VARIABLE.createInstance();
                }
                return this.nil();
            }
            case ALWAYS_DEFINED_GLOBAL: {
                return this.coreStrings().GLOBAL_VARIABLE.createInstance();
            }
        }
        throw new UnsupportedOperationException("didn't expect local type " + (Object)((Object)this.type));
    }

    private Object readFrameSlot(VirtualFrame frame) {
        if (this.readFrameSlotNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.readFrameSlotNode = this.insert(ReadFrameSlotNodeGen.create(this.frameSlot));
        }
        MaterializedFrame declarationFrame = RubyArguments.getDeclarationFrame(frame, this.frameDepth);
        return this.readFrameSlotNode.executeRead(declarationFrame);
    }

    @Override
    public RubyNode makeWriteNode(RubyNode rhs) {
        return new WriteDeclarationVariableNode(this.getContext(), this.getSourceSection(), this.frameSlot, this.frameDepth, rhs);
    }
}

