/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.arguments.RubyArguments;

public class EnumeratorSizeNode
extends RubyNode {
    @Node.Child
    private RubyNode method;
    @Node.Child
    private SnippetNode snippetNode;
    private final ConditionProfile noBlockProfile = ConditionProfile.createBinaryProfile();
    private final String snippet;

    public EnumeratorSizeNode(String enumeratorSize, String methodName, RubyNode method) {
        super(method.getContext(), method.getEncapsulatingSourceSection());
        this.method = method;
        this.snippet = "to_enum(:" + methodName + ") { " + enumeratorSize + " }";
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject block = RubyArguments.getBlock(frame);
        if (this.noBlockProfile.profile(block == null)) {
            if (this.snippetNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.snippetNode = this.insert(new SnippetNode());
            }
            return this.snippetNode.execute(frame, this.snippet, new Object[0]);
        }
        return this.method.execute(frame);
    }
}

