/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.util;

import java.io.File;
import org.encog.EncogError;
import org.encog.app.analyst.AnalystFileFormat;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.analyze.PerformAnalysis;
import org.encog.app.analyst.csv.TimeSeriesUtil;
import org.encog.app.analyst.csv.normalize.AnalystNormalizeCSV;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.analyst.util.CSVHeaders;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.util.arrayutil.NormalizationAction;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.encog.util.logging.EncogLogging;

public class AnalystUtility {
    private final EncogAnalyst analyst;

    public AnalystUtility(EncogAnalyst theAnalyst) {
        this.analyst = theAnalyst;
    }

    public void encode(boolean includeInput, boolean includeOutput, double[] rawData, MLData encodedData) {
        int rawIndex = 0;
        int outputIndex = 0;
        for (AnalystField stat : this.analyst.getScript().getNormalize().getNormalizedFields()) {
            double[] d;
            if (stat.isIgnored() || stat.isOutput() && !includeOutput || stat.isInput() && !includeInput) continue;
            if (stat.getAction() == NormalizationAction.Normalize) {
                encodedData.setData(outputIndex++, stat.normalize(rawData[rawIndex++]));
                continue;
            }
            if (stat.getAction() == NormalizationAction.PassThrough) {
                encodedData.setData(outputIndex++, rawData[rawIndex++]);
                continue;
            }
            for (double element : d = stat.encode(rawData[rawIndex++])) {
                encodedData.setData(outputIndex++, element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MLDataSet loadCSV(File file) {
        if (this.analyst == null) {
            throw new EncogError("Can't normalize yet, file has not been analyzed.");
        }
        BasicMLDataSet result = new BasicMLDataSet();
        int inputCount = this.analyst.determineInputCount();
        int outputCount = this.analyst.determineOutputCount();
        int totalCount = inputCount + outputCount;
        boolean headers = this.analyst.getScript().getProperties().getPropertyBoolean("SETUP:CONFIG_inputHeaders");
        CSVFormat format = this.analyst.getScript().determineFormat();
        CSVHeaders analystHeaders = new CSVHeaders(file, headers, format);
        ReadCSV csv = new ReadCSV(file.toString(), headers, format);
        for (AnalystField field : this.analyst.getScript().getNormalize().getNormalizedFields()) {
            field.init();
        }
        TimeSeriesUtil series = new TimeSeriesUtil(this.analyst, true, analystHeaders.getHeaders());
        try {
            while (csv.next()) {
                int i;
                double[] output = AnalystNormalizeCSV.extractFields(this.analyst, analystHeaders, csv, totalCount, false);
                if (series.getTotalDepth() > 1) {
                    output = series.process(output);
                }
                MLDataPair pair = BasicMLDataPair.createPair(inputCount, outputCount);
                for (i = 0; i < inputCount; ++i) {
                    pair.getInput().setData(i, output[i]);
                }
                for (i = 0; i < outputCount; ++i) {
                    pair.getIdeal().setData(i, output[i + inputCount]);
                }
                result.add(pair);
            }
            BasicMLDataSet basicMLDataSet = result;
            return basicMLDataSet;
        }
        finally {
            if (csv != null) {
                try {
                    csv.close();
                }
                catch (Exception ex) {
                    EncogLogging.log(ex);
                }
            }
        }
    }

    public MLDataSet loadCSV(String filename) {
        return this.loadCSV(new File(filename));
    }

    public void decode(boolean includeInput, boolean includeOutput, double[] rawData, MLData encodedData) {
        int rawIndex = 0;
        int outputIndex = 0;
        for (AnalystField stat : this.analyst.getScript().getNormalize().getNormalizedFields()) {
            if (stat.isIgnored() || stat.isOutput() && !includeOutput || stat.isInput() && !includeInput) continue;
            if (stat.getAction() == NormalizationAction.Normalize) {
                rawData[rawIndex++] = stat.deNormalize(encodedData.getData(outputIndex++));
                continue;
            }
            if (stat.getAction() == NormalizationAction.PassThrough) {
                rawData[rawIndex++] = encodedData.getData(outputIndex++);
                continue;
            }
            rawData[rawIndex++] = stat.determineClass(outputIndex, encodedData.getData()).getIndex();
            outputIndex += stat.getColumnsNeeded();
        }
    }

    public void analyze(File theFilename) {
        boolean headers = this.analyst.getScript().getProperties().getPropertyBoolean("SETUP:CONFIG_inputHeaders");
        AnalystFileFormat fmt = this.analyst.getScript().getProperties().getPropertyFormat("SETUP:CONFIG_csvFormat");
        PerformAnalysis analyze = new PerformAnalysis(this.analyst.getScript(), theFilename.toString(), headers, fmt);
        analyze.process(this.analyst);
    }
}

