/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import org.encog.mathutil.randomize.BasicRandomizer;

public class GaussianRandomizer
extends BasicRandomizer {
    private double y2;
    private boolean useLast = false;
    private final double mean;
    private final double standardDeviation;

    public GaussianRandomizer(double mean, double standardDeviation) {
        this.mean = mean;
        this.standardDeviation = standardDeviation;
    }

    public double boxMuller(double m, double s) {
        double y1;
        if (this.useLast) {
            y1 = this.y2;
            this.useLast = false;
        } else {
            double x2;
            double x1;
            double w;
            while ((w = (x1 = 2.0 * this.nextDouble() - 1.0) * x1 + (x2 = 2.0 * this.nextDouble() - 1.0) * x2) >= 1.0) {
            }
            w = Math.sqrt(-2.0 * Math.log(w) / w);
            y1 = x1 * w;
            this.y2 = x2 * w;
            this.useLast = true;
        }
        return m + y1 * s;
    }

    @Override
    public double randomize(double d) {
        return this.boxMuller(this.mean, this.standardDeviation);
    }
}

