/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import org.encog.EncogError;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.randomize.BasicRandomizer;
import org.encog.ml.MLMethod;
import org.encog.neural.networks.BasicNetwork;

public class NguyenWidrowRandomizer
extends BasicRandomizer {
    public static String MSG = "This type of randomization is not supported by Nguyen-Widrow";

    @Override
    public void randomize(MLMethod method) {
        if (!(method instanceof BasicNetwork)) {
            throw new EncogError("Nguyen-Widrow only supports BasicNetwork.");
        }
        BasicNetwork network = (BasicNetwork)method;
        for (int fromLayer = 0; fromLayer < network.getLayerCount() - 1; ++fromLayer) {
            this.randomizeSynapse(network, fromLayer);
        }
    }

    private double calculateRange(ActivationFunction af, double r) {
        double[] d = new double[]{r};
        af.activationFunction(d, 0, 1);
        return d[0];
    }

    private void randomizeSynapse(BasicNetwork network, int fromLayer) {
        int toLayer = fromLayer + 1;
        int toCount = network.getLayerNeuronCount(toLayer);
        int fromCount = network.getLayerNeuronCount(fromLayer);
        int fromCountTotalCount = network.getLayerTotalNeuronCount(fromLayer);
        ActivationFunction af = network.getActivation(toLayer);
        double low = this.calculateRange(af, Double.MIN_VALUE);
        double high = this.calculateRange(af, Double.MAX_VALUE);
        double b = 0.7 * Math.pow(toCount, 1.0 / (double)fromCount) / (high - low);
        for (int toNeuron = 0; toNeuron < toCount; ++toNeuron) {
            if (fromCount != fromCountTotalCount) {
                double w = this.nextDouble(-b, b);
                network.setWeight(fromLayer, fromCount, toNeuron, w);
            }
            for (int fromNeuron = 0; fromNeuron < fromCount; ++fromNeuron) {
                double w = this.nextDouble(0.0, b);
                network.setWeight(fromLayer, fromNeuron, toNeuron, w);
            }
        }
    }

    @Override
    public double randomize(double d) {
        throw new EncogError(MSG);
    }

    @Override
    public void randomize(double[] d) {
        throw new EncogError(MSG);
    }

    @Override
    public void randomize(double[][] d) {
        throw new EncogError(MSG);
    }

    @Override
    public void randomize(Matrix m) {
        throw new EncogError(MSG);
    }

    @Override
    public void randomize(double[] d, int begin, int size) {
        throw new EncogError(MSG);
    }
}

