/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.bayesian.training.estimator;

import org.encog.ml.bayesian.BayesianEvent;
import org.encog.ml.bayesian.BayesianNetwork;
import org.encog.ml.bayesian.table.TableLine;
import org.encog.ml.bayesian.training.TrainBayesian;
import org.encog.ml.bayesian.training.estimator.BayesEstimator;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;

public class SimpleEstimator
implements BayesEstimator {
    private MLDataSet data;
    private BayesianNetwork network;
    private TrainBayesian trainer;
    private int index;

    @Override
    public void init(TrainBayesian theTrainer, BayesianNetwork theNetwork, MLDataSet theData) {
        this.network = theNetwork;
        this.data = theData;
        this.trainer = theTrainer;
        this.index = 0;
    }

    public double calculateProbability(BayesianEvent event, int result, int[] args) {
        int eventIndex = this.network.getEvents().indexOf(event);
        int x = 0;
        int y = 0;
        for (MLDataPair pair : this.data) {
            int[] d = this.network.determineClasses(pair.getInput());
            if (args.length == 0) {
                ++x;
                if (d[eventIndex] != result) continue;
                ++y;
                continue;
            }
            if (d[eventIndex] != result) continue;
            ++x;
            int i = 0;
            boolean givenMatch = true;
            for (BayesianEvent givenEvent : event.getParents()) {
                int givenIndex = this.network.getEventIndex(givenEvent);
                if (args[i] != d[givenIndex]) {
                    givenMatch = false;
                    break;
                }
                ++i;
            }
            if (!givenMatch) continue;
            ++y;
        }
        double num = y + 1;
        double den = x + event.getChoices().size();
        return num / den;
    }

    @Override
    public boolean iteration() {
        BayesianEvent event = this.network.getEvents().get(this.index);
        for (TableLine line : event.getTable().getLines()) {
            line.setProbability(this.calculateProbability(event, line.getResult(), line.getArguments()));
        }
        ++this.index;
        return this.index < this.network.getEvents().size();
    }
}

