/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.market.loader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.encog.ml.data.market.MarketDataType;
import org.encog.ml.data.market.TickerSymbol;
import org.encog.ml.data.market.loader.LoadedMarketData;
import org.encog.ml.data.market.loader.LoaderError;
import org.encog.ml.data.market.loader.MarketLoader;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.encog.util.http.FormUtility;

public class YahooFinanceLoader
implements MarketLoader {
    private URL buildURL(TickerSymbol ticker, Date from, Date to) throws IOException {
        Calendar calendarFrom = Calendar.getInstance();
        calendarFrom.setTime(from);
        Calendar calendarTo = Calendar.getInstance();
        calendarTo.setTime(to);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        FormUtility form = new FormUtility(os, null);
        form.add("s", ticker.getSymbol().toUpperCase());
        form.add("a", "" + calendarFrom.get(2));
        form.add("b", "" + calendarFrom.get(5));
        form.add("c", "" + calendarFrom.get(1));
        form.add("d", "" + calendarTo.get(2));
        form.add("e", "" + calendarTo.get(5));
        form.add("f", "" + calendarTo.get(1));
        form.add("g", "d");
        form.add("ignore", ".csv");
        ((OutputStream)os).close();
        String str = "http://ichart.finance.yahoo.com/table.csv?" + ((Object)os).toString();
        return new URL(str);
    }

    @Override
    public Collection<LoadedMarketData> load(TickerSymbol ticker, Set<MarketDataType> dataNeeded, Date from, Date to) {
        try {
            ArrayList<LoadedMarketData> result = new ArrayList<LoadedMarketData>();
            URL url = this.buildURL(ticker, from, to);
            InputStream is = url.openStream();
            ReadCSV csv = new ReadCSV(is, true, CSVFormat.ENGLISH);
            while (csv.next()) {
                Date date = csv.getDate("date");
                double adjClose = csv.getDouble("adj close");
                double open = csv.getDouble("open");
                double close = csv.getDouble("close");
                double high = csv.getDouble("high");
                double low = csv.getDouble("low");
                double volume = csv.getDouble("volume");
                LoadedMarketData data = new LoadedMarketData(date, ticker);
                data.setData(MarketDataType.ADJUSTED_CLOSE, adjClose);
                data.setData(MarketDataType.OPEN, open);
                data.setData(MarketDataType.CLOSE, close);
                data.setData(MarketDataType.HIGH, high);
                data.setData(MarketDataType.LOW, low);
                data.setData(MarketDataType.OPEN, open);
                data.setData(MarketDataType.VOLUME, volume);
                result.add(data);
            }
            csv.close();
            is.close();
            return result;
        }
        catch (IOException e) {
            throw new LoaderError(e);
        }
    }
}

