/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.factory.train;

import java.util.Map;
import org.encog.EncogError;
import org.encog.mathutil.rbf.RBFEnum;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.factory.parse.ArchitectureParse;
import org.encog.ml.train.MLTrain;
import org.encog.neural.som.SOM;
import org.encog.neural.som.training.basic.BasicTrainSOM;
import org.encog.neural.som.training.basic.neighborhood.NeighborhoodBubble;
import org.encog.neural.som.training.basic.neighborhood.NeighborhoodFunction;
import org.encog.neural.som.training.basic.neighborhood.NeighborhoodRBF;
import org.encog.neural.som.training.basic.neighborhood.NeighborhoodRBF1D;
import org.encog.neural.som.training.basic.neighborhood.NeighborhoodSingle;
import org.encog.util.ParamsHolder;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;

public class NeighborhoodSOMFactory {
    public MLTrain create(MLMethod method, MLDataSet training, String argsStr) {
        if (!(method instanceof SOM)) {
            throw new EncogError("Neighborhood training cannot be used on a method of type: " + method.getClass().getName());
        }
        Map<String, String> args = ArchitectureParse.parseParams(argsStr);
        ParamsHolder holder = new ParamsHolder(args);
        double learningRate = holder.getDouble("LR", false, 0.7);
        String neighborhoodStr = holder.getString("NEIGHBORHOOD", false, "rbf");
        String rbfTypeStr = holder.getString("RBF_TYPE", false, "gaussian");
        RBFEnum t = rbfTypeStr.equalsIgnoreCase("Gaussian") ? RBFEnum.Gaussian : (rbfTypeStr.equalsIgnoreCase("Multiquadric") ? RBFEnum.Multiquadric : (rbfTypeStr.equalsIgnoreCase("InverseMultiquadric") ? RBFEnum.InverseMultiquadric : (rbfTypeStr.equalsIgnoreCase("MexicanHat") ? RBFEnum.MexicanHat : RBFEnum.Gaussian)));
        NeighborhoodFunction nf = null;
        if (neighborhoodStr.equalsIgnoreCase("bubble")) {
            nf = new NeighborhoodBubble(1);
        } else if (neighborhoodStr.equalsIgnoreCase("rbf")) {
            String str = holder.getString("DIM", true, null);
            int[] size = NumberList.fromListInt(CSVFormat.EG_FORMAT, str);
            nf = new NeighborhoodRBF(size, t);
        } else if (neighborhoodStr.equalsIgnoreCase("rbf1d")) {
            nf = new NeighborhoodRBF1D(t);
        }
        if (neighborhoodStr.equalsIgnoreCase("single")) {
            nf = new NeighborhoodSingle();
        }
        BasicTrainSOM result = new BasicTrainSOM((SOM)method, learningRate, training, nf);
        if (args.containsKey("ITERATIONS")) {
            int plannedIterations = holder.getInt("ITERATIONS", false, 1000);
            double startRate = holder.getDouble("START_LR", false, 0.05);
            double endRate = holder.getDouble("END_LR", false, 0.05);
            double startRadius = holder.getDouble("START_RADIUS", false, 10.0);
            double endRadius = holder.getDouble("END_RADIUS", false, 1.0);
            result.setAutoDecay(plannedIterations, startRate, endRate, startRadius, endRadius);
        }
        return result;
    }
}

