/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.encog.EncogError;
import org.encog.ml.ea.exception.EACompileError;
import org.encog.ml.prg.EncogProgramContext;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.expvalue.ValueType;
import org.encog.ml.prg.extension.NodeType;
import org.encog.ml.prg.extension.ParamTemplate;
import org.encog.ml.prg.extension.ProgramExtensionTemplate;
import org.encog.util.SimpleParser;

public abstract class BasicTemplate
implements ProgramExtensionTemplate {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final boolean varValue;
    private final int dataSize;
    private final NodeType nodeType;
    private final int precedence;
    private final String signature;
    private final List<ParamTemplate> params = new ArrayList<ParamTemplate>();
    private final ParamTemplate returnValue;

    public BasicTemplate(int thePrecedence, String theSignature, NodeType theType, boolean isVariable, int theDataSize) {
        this.precedence = thePrecedence;
        this.signature = theSignature;
        this.varValue = isVariable;
        this.dataSize = theDataSize;
        this.nodeType = theType;
        if (theSignature.trim().equals("(")) {
            this.name = theSignature;
            this.returnValue = null;
        } else {
            SimpleParser parser = new SimpleParser(theSignature);
            boolean pass = false;
            parser.eatWhiteSpace();
            this.name = parser.readToChars("(").trim();
            parser.advance();
            boolean done = false;
            while (!done) {
                if (parser.peek() == ')') {
                    parser.advance();
                    done = true;
                    continue;
                }
                if (parser.peek() == ':') {
                    parser.advance();
                    pass = true;
                    continue;
                }
                if (parser.peek() == '{') {
                    ParamTemplate temp = this.readParam(parser);
                    temp.setPassThrough(pass);
                    pass = false;
                    this.params.add(temp);
                    continue;
                }
                parser.advance();
                if (!parser.eol()) continue;
                throw new EncogError("Invalid opcode template.");
            }
            parser.eatWhiteSpace();
            if (!parser.lookAhead(":")) {
                throw new EACompileError("Return type not specified.");
            }
            parser.advance();
            parser.eatWhiteSpace();
            this.returnValue = this.readParam(parser);
        }
    }

    public BasicTemplate(String theSignature) {
        this(0, theSignature, NodeType.Function, false, 0);
    }

    @Override
    public int getChildNodeCount() {
        return this.params.size();
    }

    @Override
    public int getDataSize() {
        return this.dataSize;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    public List<ParamTemplate> getParams() {
        return this.params;
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    @Override
    public ParamTemplate getReturnValue() {
        return this.returnValue;
    }

    public String getSignature() {
        return this.signature;
    }

    @Override
    public boolean isPossibleReturnType(EncogProgramContext context, ValueType rtn) {
        return this.returnValue.getPossibleTypes().contains((Object)rtn);
    }

    @Override
    public boolean isVariable() {
        return this.varValue;
    }

    @Override
    public void randomize(Random rnd, List<ValueType> desiredTypes, ProgramNode actual, double minValue, double maxValue) {
    }

    private ParamTemplate readParam(SimpleParser parser) {
        ParamTemplate result = new ParamTemplate();
        if (!parser.lookAhead("{")) {
            throw new EACompileError("Expected {");
        }
        parser.advance();
        boolean done = false;
        StringBuilder buffer = new StringBuilder();
        while (!done) {
            if (parser.peek() == '}') {
                done = true;
                parser.advance();
                continue;
            }
            if (parser.peek() == '{') {
                throw new EACompileError("Unexpected {");
            }
            if (parser.peek() == '{') {
                done = true;
                parser.advance();
                continue;
            }
            if (parser.peek() == ',') {
                result.addType(buffer.toString().trim().toLowerCase());
                parser.advance();
                buffer.setLength(0);
                continue;
            }
            buffer.append(parser.readChar());
        }
        String s = buffer.toString().trim();
        if (s.length() > 0) {
            result.addType(s);
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[BasicTemplate:");
        result.append(this.signature);
        result.append(",type=");
        result.append(this.nodeType.toString());
        result.append(",argCount=");
        result.append(this.getChildNodeCount());
        result.append("]");
        return result.toString();
    }
}

