/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.extension;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.ml.ea.exception.EACompileError;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.EncogProgramContext;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.expvalue.ValueType;
import org.encog.ml.prg.extension.EncogOpcodeRegistry;
import org.encog.ml.prg.extension.NodeType;
import org.encog.ml.prg.extension.ProgramExtensionTemplate;

public class FunctionFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, ProgramExtensionTemplate> templateMap = new HashMap<String, ProgramExtensionTemplate>();
    private final List<ProgramExtensionTemplate> opcodes = new ArrayList<ProgramExtensionTemplate>();

    public void addExtension(ProgramExtensionTemplate ext) {
        this.addExtension(ext.getName(), ext.getChildNodeCount());
    }

    public void addExtension(String name, int args) {
        String key = EncogOpcodeRegistry.createKey(name, args);
        if (!this.templateMap.containsKey(key)) {
            ProgramExtensionTemplate temp = EncogOpcodeRegistry.INSTANCE.findOpcode(name, args);
            if (temp == null) {
                throw new EACompileError("Unknown extension " + name + " with " + args + " arguments.");
            }
            this.opcodes.add(temp);
            this.templateMap.put(key, temp);
        }
    }

    public ProgramNode factorProgramNode(ProgramExtensionTemplate temp, EncogProgram program, ProgramNode[] args) {
        return new ProgramNode(program, temp, args);
    }

    public ProgramNode factorProgramNode(String name, EncogProgram program, ProgramNode[] args) {
        String key = EncogOpcodeRegistry.createKey(name, args.length);
        if (!this.templateMap.containsKey(key)) {
            throw new EACompileError("Undefined function/operator: " + name + " with " + args.length + " args.");
        }
        ProgramExtensionTemplate temp = this.templateMap.get(key);
        return new ProgramNode(program, temp, args);
    }

    public ProgramExtensionTemplate findFunction(String name) {
        for (ProgramExtensionTemplate opcode : this.opcodes) {
            if (opcode.getNodeType() != NodeType.Function || !opcode.getName().equals(name)) continue;
            return opcode;
        }
        return null;
    }

    public List<ProgramExtensionTemplate> findOpcodes(List<ValueType> types, EncogProgramContext context, boolean includeTerminal, boolean includeFunction) {
        ArrayList<ProgramExtensionTemplate> result = new ArrayList<ProgramExtensionTemplate>();
        for (ProgramExtensionTemplate temp : this.opcodes) {
            for (ValueType rtn : types) {
                if (!temp.isPossibleReturnType(context, rtn)) continue;
                if (temp.getChildNodeCount() == 0 && includeTerminal) {
                    result.add(temp);
                    continue;
                }
                if (!includeFunction) continue;
                result.add(temp);
            }
        }
        return result;
    }

    public ProgramExtensionTemplate findOperator(char ch1, char ch2) {
        ProgramExtensionTemplate result = null;
        if (ch2 == '\u0000') {
            return this.findOperatorExact("" + ch1);
        }
        result = this.findOperatorExact("" + ch1 + ch2);
        if (result == null) {
            result = this.findOperatorExact("" + ch1);
        }
        return result;
    }

    private ProgramExtensionTemplate findOperatorExact(String str) {
        for (ProgramExtensionTemplate opcode : this.opcodes) {
            if (opcode.getNodeType() != NodeType.OperatorLeft && opcode.getNodeType() != NodeType.OperatorRight || !opcode.getName().equals(str)) continue;
            return opcode;
        }
        return null;
    }

    public ProgramExtensionTemplate getOpCode(int theOpCode) {
        return this.opcodes.get(theOpCode);
    }

    public List<ProgramExtensionTemplate> getOpCodes() {
        return this.opcodes;
    }

    public Map<String, ProgramExtensionTemplate> getTemplateMap() {
        return this.templateMap;
    }

    public boolean isDefined(String name, int l) {
        String key = EncogOpcodeRegistry.createKey(name, l);
        return this.templateMap.containsKey(key);
    }

    public int size() {
        return this.opcodes.size();
    }
}

