/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.train;

import java.util.ArrayList;
import java.util.List;
import org.encog.ml.TrainingImplementationType;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.Strategy;
import org.encog.ml.train.strategy.end.EndTrainingStrategy;

public abstract class BasicTraining
implements MLTrain {
    private final List<Strategy> strategies = new ArrayList<Strategy>();
    private MLDataSet training;
    private double error;
    private int iteration;
    private TrainingImplementationType implementationType;

    public BasicTraining() {
    }

    public BasicTraining(TrainingImplementationType implementationType) {
        this.implementationType = implementationType;
    }

    @Override
    public void addStrategy(Strategy strategy) {
        strategy.init(this);
        this.strategies.add(strategy);
    }

    @Override
    public void finishTraining() {
    }

    @Override
    public double getError() {
        return this.error;
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public List<Strategy> getStrategies() {
        return this.strategies;
    }

    @Override
    public MLDataSet getTraining() {
        return this.training;
    }

    @Override
    public boolean isTrainingDone() {
        for (Strategy strategy : this.strategies) {
            EndTrainingStrategy end;
            if (!(strategy instanceof EndTrainingStrategy) || !(end = (EndTrainingStrategy)strategy).shouldStop()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void iteration(int count) {
        for (int i = 0; i < count; ++i) {
            this.iteration();
        }
    }

    public void postIteration() {
        for (Strategy strategy : this.strategies) {
            strategy.postIteration();
        }
    }

    public void preIteration() {
        ++this.iteration;
        for (Strategy strategy : this.strategies) {
            strategy.preIteration();
        }
    }

    @Override
    public void setError(double error) {
        this.error = error;
    }

    @Override
    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public void setTraining(MLDataSet training) {
        this.training = training;
    }

    @Override
    public TrainingImplementationType getImplementationType() {
        return this.implementationType;
    }
}

