/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.file;

import java.io.IOException;
import java.io.InputStream;
import org.encog.EncogError;
import org.encog.util.file.FileUtil;

public class ResourceInputStream {
    public static InputStream openResourceInputStream(String resource) {
        ClassLoader loader = ResourceInputStream.class.getClassLoader();
        InputStream result = loader.getResourceAsStream(resource);
        if (result == null) {
            throw new EncogError("Can't open resource: " + resource);
        }
        return result;
    }

    public static String readResourceAsString(String resource) {
        try {
            InputStream is = ResourceInputStream.openResourceInputStream(resource);
            String result = FileUtil.readStreamAsString(is);
            is.close();
            return result;
        }
        catch (IOException ex) {
            throw new EncogError(ex);
        }
    }
}

