/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.obj;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.encog.EncogError;
import org.encog.util.file.ResourceInputStream;

public final class ReflectionUtil {
    private static Map<String, Class<?>> classMap = new HashMap();

    public static Field findField(Class<?> c, String name) {
        Collection<Field> list = ReflectionUtil.getAllFields(c);
        for (Field field : list) {
            if (!field.getName().equals(name)) continue;
            field.setAccessible(true);
            return field;
        }
        if (c.getSuperclass() != null) {
            return ReflectionUtil.findField(c.getSuperclass(), name);
        }
        return null;
    }

    public static Collection<Field> getAllFields(Class<?> c) {
        ArrayList<Field> result = new ArrayList<Field>();
        ReflectionUtil.getAllFields(c, result);
        return result;
    }

    public static void getAllFields(Class<?> c, Collection<Field> fields) {
        for (Field field : c.getDeclaredFields()) {
            fields.add(field);
        }
        Class<?> s = c.getSuperclass();
        if (s != null) {
            ReflectionUtil.getAllFields(s, fields);
        }
    }

    public static boolean isInstanceOf(Class<?> class1, Class<?> class2) {
        if (class1.equals(class2)) {
            return true;
        }
        for (Class<?> clazz : class1.getInterfaces()) {
            if (!clazz.equals(class1)) continue;
            return true;
        }
        if (class1.getSuperclass() == null) {
            return false;
        }
        return ReflectionUtil.isInstanceOf(class1.getSuperclass(), class2);
    }

    public static boolean isPrimitive(Object obj) {
        return obj instanceof Character || obj instanceof Integer || obj instanceof Short || obj instanceof Float || obj instanceof Double || obj instanceof Boolean || obj instanceof Long;
    }

    public static boolean isSimple(Object obj) {
        return obj instanceof File || obj instanceof String;
    }

    public static void loadStandardClassmap() {
        String currentClass = null;
        try {
            String line;
            InputStream is = ResourceInputStream.openResourceInputStream("org/encog/data/classes.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                currentClass = line;
                Class<?> c = Class.forName(line);
                classMap.put(c.getSimpleName(), c);
            }
            is.close();
        }
        catch (IOException e) {
            throw new EncogError(e);
        }
        catch (ClassNotFoundException e) {
            throw new EncogError("Unknown class: " + currentClass);
        }
    }

    public static void loadClassmap() {
        String currentClass = null;
        try {
            String line;
            InputStream is = ResourceInputStream.openResourceInputStream("org/encog/data/classes.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                currentClass = line;
                Class<?> c = Class.forName(line);
                classMap.put(c.getSimpleName(), c);
            }
            is.close();
        }
        catch (IOException e) {
            throw new EncogError(e);
        }
        catch (ClassNotFoundException e) {
            throw new EncogError("Unknown class: " + currentClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> resolveEncogClass(String name) {
        Map<String, Class<?>> map = classMap;
        synchronized (map) {
            if (classMap.size() == 0) {
                ReflectionUtil.loadClassmap();
            }
        }
        return classMap.get(name);
    }

    private ReflectionUtil() {
    }

    public static Object resolveEnum(Field field, String value) {
        ?[] objs;
        Class<?> type = field.getType();
        for (Object obj : objs = type.getEnumConstants()) {
            if (!obj.toString().equals(value)) continue;
            return obj;
        }
        return null;
    }

    public static <T> int safeHashCode(T o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }
}

