/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TextChecker;

class ApiV2 {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String ENCODING = "UTF-8";
    private final TextChecker textChecker;
    private final String allowOriginUrl;
    private final JsonFactory factory = new JsonFactory();

    ApiV2(TextChecker textChecker, String allowOriginUrl) {
        this.textChecker = textChecker;
        this.allowOriginUrl = allowOriginUrl;
    }

    void handleRequest(String path, HttpExchange httpExchange, Map<String, String> parameters) throws Exception {
        if (path.equals("languages")) {
            String response = this.getLanguages();
            ServerTools.setCommonHeaders(httpExchange, JSON_CONTENT_TYPE, this.allowOriginUrl);
            httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
            httpExchange.getResponseBody().write(response.getBytes(ENCODING));
        } else if (path.equals("check")) {
            this.textChecker.checkText(parameters.get("text"), httpExchange, parameters, -1);
        } else {
            throw new RuntimeException("Unsupported action: '" + path + "'");
        }
    }

    String getLanguages() throws IOException {
        StringWriter sw = new StringWriter();
        try (JsonGenerator g = this.factory.createGenerator(sw);){
            g.writeStartArray();
            ArrayList<Language> languages = new ArrayList<Language>(Languages.get());
            Collections.sort(languages, (o1, o2) -> o1.getName().compareTo(o2.getName()));
            for (Language lang : languages) {
                g.writeStartObject();
                g.writeStringField("name", lang.getName());
                g.writeStringField("code", lang.getShortName());
                g.writeStringField("longCode", lang.getShortNameWithCountryAndVariant());
                g.writeEndObject();
            }
            g.writeEndArray();
        }
        return sw.toString();
    }
}

