/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.collections;

import edu.berkeley.nlp.lm.util.Pair;
import java.util.Iterator;

public class Iterators {
    public static <T> Iterable<T> able(final Iterator<T> it) {
        return new Iterable<T>(){
            boolean used = false;

            @Override
            public Iterator<T> iterator() {
                if (this.used) {
                    throw new RuntimeException("One use iterable");
                }
                this.used = true;
                return it;
            }
        };
    }

    public static <T> Iterable<T> flatten(Iterator<Iterator<T>> iters) {
        return Iterators.able(new IteratorIterator<T>(iters));
    }

    public static <S, T> Iterator<Pair<S, T>> zip(final Iterator<S> s, final Iterator<T> t) {
        return new Iterator<Pair<S, T>>(){

            @Override
            public boolean hasNext() {
                return s.hasNext() && t.hasNext();
            }

            @Override
            public Pair<S, T> next() {
                return Pair.newPair(s.next(), t.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static abstract class Transform<S, T>
    implements Iterator<T> {
        private final Iterator<S> base;

        public Transform(Iterator<S> base) {
            this.base = base;
        }

        @Override
        public boolean hasNext() {
            return this.base.hasNext();
        }

        @Override
        public T next() {
            return this.transform(this.base.next());
        }

        protected abstract T transform(S var1);

        @Override
        public void remove() {
            this.base.remove();
        }
    }

    public static class IteratorIterator<T>
    implements Iterator<T> {
        Iterator<T> current = null;
        private final Iterator<Iterator<T>> iters;

        public IteratorIterator(Iterator<Iterator<T>> iters) {
            this.iters = iters;
            this.current = this.getNextIterator();
        }

        private Iterator<T> getNextIterator() {
            Iterator<T> next = null;
            while (next == null && this.iters.hasNext()) {
                next = this.iters.next();
                if (next.hasNext()) continue;
                next = null;
            }
            return next;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public T next() {
            T next = this.current.next();
            if (!this.current.hasNext()) {
                this.current = this.getNextIterator();
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

