/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.data.Config;
import esmska.data.CountryPrefix;
import esmska.data.event.AbstractDocumentListener;
import esmska.utils.L10N;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.StringUtils;
import org.openide.awt.Mnemonics;

public class CountryPrefixPanel
extends JPanel {
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final Config config = Config.getInstance();
    private boolean fullyInicialized;
    private JComboBox countryCodeComboBox;
    private JLabel countryCodeLabel;
    private JTextField countryPrefixTextField;
    private JLabel jLabel2;
    private JLabel jLabel4;

    public CountryPrefixPanel() {
        this.initComponents();
        this.fullyInicialized = true;
        this.setCountryPrefix(config.getCountryPrefix());
    }

    public void setCountryPrefix(String prefix) {
        this.countryPrefixTextField.setText(prefix);
    }

    public String getCountryPrefix() {
        String prefix = this.countryPrefixTextField.getText();
        if (CountryPrefix.isValidCountryPrefix(prefix)) {
            return prefix;
        }
        if (StringUtils.isEmpty(prefix)) {
            return "";
        }
        return null;
    }

    private void updateCountryCode() {
        String countryPrefix = this.countryPrefixTextField.getText();
        String countryCode = CountryPrefix.getCountryCode(countryPrefix);
        boolean temp = this.fullyInicialized;
        this.fullyInicialized = false;
        if (StringUtils.isEmpty(countryCode)) {
            this.countryCodeComboBox.setSelectedIndex(0);
        } else {
            this.countryCodeComboBox.setSelectedItem(countryCode);
        }
        this.fullyInicialized = temp;
    }

    private void initComponents() {
        this.countryCodeComboBox = new JComboBox();
        this.countryPrefixTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.countryCodeLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.countryCodeComboBox.setToolTipText(l10n.getString("CountryPrefixPanel.countryCodeComboBox.toolTipText"));
        ArrayList<String> codes = CountryPrefix.getCountryCodes();
        codes.add(0, l10n.getString("CountryPrefixPanel.unknown_state"));
        this.countryCodeComboBox.setModel(new DefaultComboBoxModel<Object>(codes.toArray()));
        this.countryCodeComboBox.setSelectedIndex(0);
        this.countryCodeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CountryPrefixPanel.this.countryCodeComboBoxItemStateChanged(evt);
            }
        });
        this.countryPrefixTextField.setColumns(5);
        this.countryPrefixTextField.setToolTipText(l10n.getString("CountryPrefixPanel.countryPrefixTextField.toolTipText"));
        this.countryPrefixTextField.getDocument().addDocumentListener(new AbstractDocumentListener(){

            @Override
            public void onUpdate(DocumentEvent e) {
                if (!CountryPrefixPanel.this.fullyInicialized) {
                    return;
                }
                CountryPrefixPanel.this.updateCountryCode();
            }
        });
        Mnemonics.setLocalizedText(this.jLabel4, ")");
        this.countryCodeLabel.setLabelFor(this.countryCodeComboBox);
        Mnemonics.setLocalizedText(this.countryCodeLabel, l10n.getString("CountryPrefixPanel.countryCodeLabel.text"));
        this.countryCodeLabel.setToolTipText(this.countryCodeComboBox.getToolTipText());
        Mnemonics.setLocalizedText(this.jLabel2, l10n.getString("CountryPrefixPanel.jLabel2.text"));
        this.jLabel2.setToolTipText(this.countryPrefixTextField.getToolTipText());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.countryPrefixTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.countryCodeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.countryCodeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.countryPrefixTextField, -2, -1, -2).addComponent(this.countryCodeLabel).addComponent(this.countryCodeComboBox, -2, -1, -2).addComponent(this.jLabel4)));
    }

    private void countryCodeComboBoxItemStateChanged(ItemEvent evt) {
        if (!this.fullyInicialized || evt.getStateChange() != 1) {
            return;
        }
        String code = (String)this.countryCodeComboBox.getSelectedItem();
        String prefix = CountryPrefix.getCountryPrefix(code);
        boolean temp = this.fullyInicialized;
        this.fullyInicialized = false;
        this.countryPrefixTextField.setText(prefix);
        this.fullyInicialized = temp;
    }
}

