/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.GpxExportAction;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.actions.SaveAsAction;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.LayerPositionStrategy;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public abstract class Layer
extends AbstractMapViewPaintable
implements Destroyable,
ProjectionChangeListener {
    public static final String VISIBLE_PROP = Layer.class.getName() + ".visible";
    public static final String OPACITY_PROP = Layer.class.getName() + ".opacity";
    public static final String NAME_PROP = Layer.class.getName() + ".name";
    public static final String FILTER_STATE_PROP = Layer.class.getName() + ".filterstate";
    protected PropertyChangeSupport propertyChangeSupport;
    private boolean visible = true;
    private double opacity = 1.0;
    private boolean background;
    private String name;
    private boolean renamed;
    private File associatedFile;
    private final AbstractProperty.ValueChangeListener<Object> invalidateListener = valueChangeEvent -> this.invalidate();

    public Layer(String string) {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.setName(string);
    }

    public void hookUpMapView() {
    }

    public abstract Icon getIcon();

    @Deprecated
    public Color getColor(boolean bl) {
        return null;
    }

    public AbstractProperty<Color> getColorProperty() {
        ColorProperty colorProperty = this.getBaseColorProperty();
        if (colorProperty != null) {
            return colorProperty.getChildColor("layer " + this.getName());
        }
        return null;
    }

    protected ColorProperty getBaseColorProperty() {
        return null;
    }

    private void addColorPropertyListener() {
        AbstractProperty<Color> abstractProperty = this.getColorProperty();
        if (abstractProperty != null) {
            abstractProperty.addListener(this.invalidateListener);
        }
    }

    private void removeColorPropertyListener() {
        AbstractProperty<Color> abstractProperty = this.getColorProperty();
        if (abstractProperty != null) {
            abstractProperty.removeListener(this.invalidateListener);
        }
    }

    public abstract String getToolTipText();

    public abstract void mergeFrom(Layer var1);

    public abstract boolean isMergable(Layer var1);

    public abstract void visitBoundingBox(BoundingXYVisitor var1);

    public abstract Object getInfoComponent();

    public boolean isInfoResizable() {
        return false;
    }

    public abstract Action[] getMenuEntries();

    @Override
    public void destroy() {
        this.removeColorPropertyListener();
    }

    public File getAssociatedFile() {
        return this.associatedFile;
    }

    public void setAssociatedFile(File file) {
        this.associatedFile = file;
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String string) {
        if (this.name != null) {
            this.removeColorPropertyListener();
        }
        if (string == null) {
            string = "";
        }
        String string2 = this.name;
        this.name = string;
        if (!this.name.equals(string2)) {
            this.propertyChangeSupport.firePropertyChange(NAME_PROP, string2, this.name);
        }
        this.addColorPropertyListener();
        this.invalidate();
    }

    public final void rename(String string) {
        this.renamed = true;
        this.setName(string);
    }

    public boolean isRenamed() {
        return this.renamed;
    }

    public boolean isBackgroundLayer() {
        return this.background;
    }

    public void setBackgroundLayer(boolean bl) {
        this.background = bl;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        this.visible = bl;
        if (bl && this.opacity == 0.0) {
            this.setOpacity(1.0);
        } else if (bl2 != this.isVisible()) {
            this.fireVisibleChanged(bl2, this.isVisible());
        }
    }

    public boolean isVisible() {
        return this.visible && this.opacity != 0.0;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        if (!(d >= 0.0) || !(d <= 1.0)) {
            throw new IllegalArgumentException("Opacity value must be between 0 and 1");
        }
        double d2 = this.getOpacity();
        boolean bl = this.isVisible();
        this.opacity = d;
        if (!Utils.equalsEpsilon(d2, this.getOpacity())) {
            this.fireOpacityChanged(d2, this.getOpacity());
        }
        if (bl != this.isVisible()) {
            this.fireVisibleChanged(bl, this.isVisible());
        }
    }

    public void setFilterStateChanged() {
        this.fireFilterStateChanged();
    }

    public void toggleVisible() {
        this.setVisible(!this.isVisible());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void fireVisibleChanged(boolean bl, boolean bl2) {
        this.propertyChangeSupport.firePropertyChange(VISIBLE_PROP, bl, bl2);
    }

    protected void fireOpacityChanged(double d, double d2) {
        this.propertyChangeSupport.firePropertyChange(OPACITY_PROP, d, d2);
    }

    protected void fireFilterStateChanged() {
        this.propertyChangeSupport.firePropertyChange(FILTER_STATE_PROP, null, null);
    }

    @Deprecated
    public boolean isChanged() {
        return true;
    }

    public boolean isProjectionSupported(Projection projection) {
        return projection != null;
    }

    public String nameSupportedProjections() {
        return I18n.tr("All projections are supported", new Object[0]);
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
        if (!this.isProjectionSupported(projection2)) {
            String string = "<html><body><p>" + I18n.tr("The layer {0} does not support the new projection {1}.", this.getName(), projection2.toCode()) + "</p>" + "<p style='width: 450px;'>" + I18n.tr("Supported projections are: {0}", this.nameSupportedProjections()) + "</p>" + I18n.tr("Change the projection again or remove the layer.", new Object[0]);
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Warning", new Object[0]), 2));
        }
    }

    public void onPostLoadFromFile() {
    }

    public boolean isSavable() {
        return false;
    }

    public boolean checkSaveConditions() {
        return true;
    }

    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save Layer", new Object[0]), "lay");
    }

    @Deprecated
    protected long estimateMemoryUsage() {
        return 0L;
    }

    public LayerPositionStrategy getDefaultLayerPosition() {
        if (this.isBackgroundLayer()) {
            return LayerPositionStrategy.BEFORE_FIRST_BACKGROUND_LAYER;
        }
        return LayerPositionStrategy.AFTER_LAST_VALIDATION_LAYER;
    }

    public ProjectionBounds getViewProjectionBounds() {
        BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
        this.visitBoundingBox(boundingXYVisitor);
        return boundingXYVisitor.getBounds();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + ", associatedFile=" + this.associatedFile + ']';
    }

    public static class LayerGpxExportAction
    extends AbstractAction {
        private final transient Layer layer;

        public LayerGpxExportAction(Layer layer) {
            this.putValue("SmallIcon", ImageProvider.get("exportgpx"));
            this.putValue("ShortDescription", I18n.tr("Export the data to GPX file.", new Object[0]));
            this.putValue("Name", I18n.tr("Export to GPX...", new Object[0]));
            this.setEnabled(true);
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new GpxExportAction().export(this.layer);
        }
    }

    public static class LayerSaveAsAction
    extends AbstractAction {
        private final transient Layer layer;

        public LayerSaveAsAction(Layer layer) {
            this.putValue("SmallIcon", ImageProvider.get("save_as"));
            this.putValue("ShortDescription", I18n.tr("Save the current data to a new file.", new Object[0]));
            this.putValue("Name", I18n.tr("Save As...", new Object[0]));
            this.setEnabled(true);
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SaveAsAction.getInstance().doSave(this.layer);
        }
    }

    public static class LayerSaveAction
    extends AbstractAction {
        private final transient Layer layer;

        public LayerSaveAction(Layer layer) {
            this.putValue("SmallIcon", ImageProvider.get("save"));
            this.putValue("ShortDescription", I18n.tr("Save the current data.", new Object[0]));
            this.putValue("Name", I18n.tr("Save", new Object[0]));
            this.setEnabled(true);
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SaveAction.getInstance().doSave(this.layer);
        }
    }

    public static class SeparatorLayerAction
    extends AbstractAction
    implements LayerAction {
        public static final SeparatorLayerAction INSTANCE = new SeparatorLayerAction();

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Component createMenuComponent() {
            return new JSeparator();
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return false;
        }
    }

    @FunctionalInterface
    public static interface MultiLayerAction {
        public Action getMultiLayerAction(List<Layer> var1);
    }

    public static interface LayerAction {
        public boolean supportLayers(List<Layer> var1);

        public Component createMenuComponent();
    }
}

