/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse.tags.read;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.encog.parse.ParseError;
import org.encog.parse.tags.Tag;
import org.encog.parse.tags.read.ReadTags;

public class ReadXML
extends ReadTags {
    public ReadXML(InputStream is) {
        super(is);
    }

    public boolean findTag(String name, boolean beginTag) {
        while (this.readToTag()) {
            if (!(beginTag ? this.getTag().getName().equals(name) && this.getTag().getType() == Tag.Type.BEGIN : this.getTag().getName().equals(name) && this.getTag().getType() == Tag.Type.END)) continue;
            return true;
        }
        return false;
    }

    public int readIntToTag() {
        try {
            String str = this.readTextToTag();
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new ParseError(e);
        }
    }

    public Map<String, String> readPropertyBlock() {
        HashMap<String, String> result = new HashMap<String, String>();
        String endingBlock = this.getTag().getName();
        while (this.readToTag() && (!this.getTag().getName().equals(endingBlock) || this.getTag().getType() != Tag.Type.END)) {
            String name = this.getTag().getName();
            String value = this.readTextToTag().trim();
            result.put(name, value);
        }
        return result;
    }

    public String readTextToTag() {
        StringBuilder result = new StringBuilder();
        boolean done = false;
        while (!done) {
            int ch = this.read();
            if (ch == -1 || ch == 0) {
                done = true;
                continue;
            }
            result.append((char)ch);
        }
        return result.toString();
    }
}

