/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.connection;

import org.gradle.api.Nullable;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.connection.FailedModelResult;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.ProjectIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFailedModelResult<T>
implements FailedModelResult<T> {
    private final GradleConnectionException failure;
    private final BuildIdentifier buildIdentifier;
    private final ProjectIdentifier projectIdentifier;

    public DefaultFailedModelResult(BuildIdentifier buildIdentifier, GradleConnectionException failure) {
        this.failure = failure;
        this.buildIdentifier = buildIdentifier;
        this.projectIdentifier = null;
    }

    public DefaultFailedModelResult(ProjectIdentifier projectIdentifier, GradleConnectionException failure) {
        this.failure = failure;
        this.buildIdentifier = projectIdentifier.getBuildIdentifier();
        this.projectIdentifier = projectIdentifier;
    }

    @Override
    public T getModel() {
        throw this.failure;
    }

    @Override
    public GradleConnectionException getFailure() {
        return this.failure;
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    @Override
    @Nullable
    public ProjectIdentifier getProjectIdentifier() {
        return this.projectIdentifier;
    }

    public String toString() {
        return String.format("result={ failure=%s }", this.failure.getMessage());
    }
}

