/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.gradle.api.Buildable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.CompositeBuildContext;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.CompositeProjectComponentArtifactMetaData;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.DefaultCompositeBuildContext;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectComponentRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.initialization.ReportedException;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetaData;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.component.local.model.LocalComponentArtifactIdentifier;
import org.gradle.internal.component.local.model.LocalComponentMetaData;
import org.gradle.internal.component.local.model.LocalConfigurationMetaData;
import org.gradle.internal.component.model.ComponentArtifactMetaData;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeContextBuilder
implements BuildActionRunner {
    private final DefaultCompositeBuildContext context = new DefaultCompositeBuildContext();
    private final boolean propagateFailures;

    public CompositeContextBuilder(boolean propagateFailures) {
        this.propagateFailures = propagateFailures;
    }

    public void run(BuildAction action, BuildController buildController) {
        block3: {
            try {
                GradleInternal gradle = buildController.configure();
                ProjectInternal rootProject = gradle.getRootProject();
                String participantName = rootProject.getName();
                for (Project project : rootProject.getAllprojects()) {
                    this.registerProject(participantName, (ProjectInternal)project);
                }
            }
            catch (ReportedException e) {
                if (!this.propagateFailures) break block3;
                throw e;
            }
        }
    }

    private void registerProject(String buildName, ProjectInternal project) {
        ProjectComponentRegistry projectComponentRegistry = (ProjectComponentRegistry)project.getServices().get(ProjectComponentRegistry.class);
        ProjectComponentIdentifier originalIdentifier = DefaultProjectComponentIdentifier.newId(project.getPath());
        DefaultLocalComponentMetaData originalComponent = (DefaultLocalComponentMetaData)projectComponentRegistry.getProject(originalIdentifier);
        DefaultProjectComponentIdentifier componentIdentifier = new DefaultProjectComponentIdentifier(this.createExternalProjectPath(buildName, project.getPath()));
        LocalComponentMetaData compositeComponent = this.createCompositeCopy(buildName, componentIdentifier, originalComponent, project.getRootDir());
        this.context.register(compositeComponent.getId().getModule(), componentIdentifier, compositeComponent, project.getProjectDir());
    }

    private LocalComponentMetaData createCompositeCopy(String buildName, ProjectComponentIdentifier componentIdentifier, DefaultLocalComponentMetaData originalComponentMetadata, File buildDir) {
        DefaultLocalComponentMetaData compositeComponentMetadata = new DefaultLocalComponentMetaData(originalComponentMetadata.getId(), (ComponentIdentifier)componentIdentifier, originalComponentMetadata.getStatus());
        for (String configurationName : originalComponentMetadata.getConfigurationNames()) {
            DefaultLocalComponentMetaData.DefaultLocalConfigurationMetaData originalConfiguration = originalComponentMetadata.getConfiguration(configurationName);
            compositeComponentMetadata.addConfiguration(configurationName, originalConfiguration.getDescription(), originalConfiguration.getExtendsFrom(), originalConfiguration.getHierarchy(), originalConfiguration.isVisible(), originalConfiguration.isTransitive(), (TaskDependency)new DefaultTaskDependency());
            Set<String> targetTasks = this.determineTargetTasks(originalConfiguration);
            Set<ComponentArtifactMetaData> artifacts = originalConfiguration.getArtifacts();
            for (ComponentArtifactMetaData originalArtifact : artifacts) {
                File artifactFile = ((LocalComponentArtifactIdentifier)((Object)originalArtifact)).getFile();
                CompositeProjectComponentArtifactMetaData artifact = new CompositeProjectComponentArtifactMetaData(componentIdentifier, originalArtifact.getName(), artifactFile, buildDir, targetTasks);
                compositeComponentMetadata.addArtifact(configurationName, artifact);
            }
        }
        for (DependencyMetaData dependency : originalComponentMetadata.getDependencies()) {
            if (dependency.getSelector() instanceof ProjectComponentSelector) {
                ProjectComponentSelector requested = (ProjectComponentSelector)dependency.getSelector();
                String externalPath = this.createExternalProjectPath(buildName, requested.getProjectPath());
                ProjectComponentSelector externalizedSelector = DefaultProjectComponentSelector.newSelector(externalPath);
                dependency = dependency.withTarget((ComponentSelector)externalizedSelector);
            }
            compositeComponentMetadata.addDependency(dependency);
        }
        for (ExcludeRule excludeRule : originalComponentMetadata.getExcludeRules()) {
            compositeComponentMetadata.addExcludeRule(excludeRule);
        }
        return compositeComponentMetadata;
    }

    private String createExternalProjectPath(String buildName, String projectPath) {
        return buildName + ":" + projectPath;
    }

    public CompositeBuildContext build() {
        return this.context;
    }

    private Set<String> determineTargetTasks(LocalConfigurationMetaData configuration) {
        LinkedHashSet taskNames = Sets.newLinkedHashSet();
        for (ComponentArtifactMetaData artifactMetaData : configuration.getArtifacts()) {
            if (!(artifactMetaData instanceof Buildable)) continue;
            Buildable publishArtifact = (Buildable)artifactMetaData;
            Set dependencies = publishArtifact.getBuildDependencies().getDependencies(null);
            for (Task dependency : dependencies) {
                taskNames.add(dependency.getPath());
            }
        }
        return taskNames;
    }
}

