/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericImageDialog;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.api.Interface;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolDialogInterface;
import org.jmol.api.JmolStatusListener;
import org.jmol.c.CBK;
import org.jmol.java.BS;
import org.jmol.script.SV;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class StatusManager {
    protected Viewer vwr;
    JmolStatusListener jsl;
    JmolCallbackListener cbl;
    public String statusList = "";
    public boolean allowStatusReporting;
    public Map<String, Lst<Lst<Object>>> messageQueue = new Hashtable<String, Lst<Lst<Object>>>();
    private int statusPtr = 0;
    private static int MAXIMUM_QUEUE_LENGTH = 16;
    private Map<CBK, String> jmolScriptCallbacks = new Hashtable<CBK, String>();
    private Map<String, GenericImageDialog> imageMap;
    private int minSyncRepeatMs = 100;
    public boolean syncingScripts = false;
    boolean syncingMouse = false;
    boolean drivingSync = false;
    boolean isSynced = false;
    boolean syncDisabled = false;
    boolean stereoSync = false;
    public static final int SYNC_OFF = 0;
    public static final int SYNC_DRIVER = 1;
    public static final int SYNC_SLAVE = 2;
    public static final int SYNC_DISABLE = 3;
    public static final int SYNC_ENABLE = 4;
    public static final int SYNC_STEREO = 5;
    private int qualityJPG = -1;
    private int qualityPNG = -1;
    private String imageType;

    StatusManager(Viewer vwr) {
        this.vwr = vwr;
    }

    private boolean recordStatus(String statusName) {
        return this.allowStatusReporting && this.statusList.length() > 0 && (this.statusList.equals("all") || this.statusList.indexOf(statusName) >= 0);
    }

    private synchronized void setStatusChanged(String statusName, int intInfo, Object statusInfo, boolean isReplace) {
        Lst<Lst<Object>> statusRecordSet;
        if (!this.recordStatus(statusName)) {
            return;
        }
        Lst<Object> msgRecord = new Lst<Object>();
        msgRecord.addLast(Integer.valueOf(++this.statusPtr));
        msgRecord.addLast(statusName);
        msgRecord.addLast(Integer.valueOf(intInfo));
        msgRecord.addLast(statusInfo);
        Lst<Lst<Object>> lst = statusRecordSet = isReplace ? null : this.messageQueue.get(statusName);
        if (statusRecordSet == null) {
            statusRecordSet = new Lst();
            this.messageQueue.put(statusName, statusRecordSet);
        } else if (statusRecordSet.size() == MAXIMUM_QUEUE_LENGTH) {
            statusRecordSet.removeItemAt(0);
        }
        statusRecordSet.addLast(msgRecord);
    }

    synchronized Lst<Lst<Lst<Object>>> getStatusChanged(String newStatusList) {
        boolean isRemove = newStatusList.length() > 0 && newStatusList.charAt(0) == '-';
        boolean isAdd = newStatusList.length() > 0 && newStatusList.charAt(0) == '+';
        boolean getList = false;
        if (isRemove) {
            this.statusList = PT.rep(this.statusList, newStatusList.substring(1, newStatusList.length()), "");
        } else if (this.statusList.equals(newStatusList = PT.rep(newStatusList, "+", "")) || isAdd && this.statusList.indexOf(newStatusList) >= 0) {
            getList = true;
        } else {
            if (!isAdd) {
                this.statusList = "";
            }
            this.statusList = this.statusList + newStatusList;
            if (Logger.debugging) {
                Logger.debug("StatusManager messageQueue = " + this.statusList);
            }
        }
        Lst<Lst<Lst<Object>>> list = new Lst<Lst<Lst<Object>>>();
        if (getList) {
            for (Map.Entry<String, Lst<Lst<Object>>> e : this.messageQueue.entrySet()) {
                list.addLast(e.getValue());
            }
        }
        this.messageQueue.clear();
        this.statusPtr = 0;
        return list;
    }

    private String jmolScriptCallback(CBK callback) {
        String s = this.jmolScriptCallbacks.get((Object)callback);
        if (s != null) {
            this.vwr.evalStringQuietSync(s, true, false);
        }
        return s;
    }

    synchronized void setCallbackFunction(String callbackType, String callbackFunction) {
        CBK callback = CBK.getCallback(callbackType);
        System.out.println("callback set for " + callbackType + " " + callbackFunction + " " + (Object)((Object)callback));
        if (callback != null) {
            int pt;
            int n = callbackFunction == null ? 0 : (callbackFunction.length() > 7 && callbackFunction.toLowerCase().indexOf("script:") == 0 ? 7 : (pt = callbackFunction.length() > 11 && callbackFunction.toLowerCase().indexOf("jmolscript:") == 0 ? 11 : 0));
            if (pt == 0) {
                this.jmolScriptCallbacks.remove((Object)callback);
            } else {
                this.jmolScriptCallbacks.put(callback, callbackFunction.substring(pt).trim());
            }
        }
        if (this.cbl != null) {
            this.cbl.setCallbackFunction(callbackType, callbackFunction);
        }
    }

    boolean notifyEnabled(CBK type) {
        return this.cbl != null && this.cbl.notifyEnabled(type);
    }

    synchronized void setStatusAppletReady(String htmlName, boolean isReady) {
        String sJmol;
        String string = sJmol = isReady ? this.jmolScriptCallback(CBK.APPLETREADY) : null;
        if (this.notifyEnabled(CBK.APPLETREADY)) {
            this.cbl.notifyCallback(CBK.APPLETREADY, new Object[]{sJmol, htmlName, isReady, null});
        }
    }

    synchronized void setStatusAtomMoved(BS bsMoved) {
        String sJmol = this.jmolScriptCallback(CBK.ATOMMOVED);
        this.setStatusChanged("atomMoved", -1, bsMoved, false);
        if (this.notifyEnabled(CBK.ATOMMOVED)) {
            this.cbl.notifyCallback(CBK.ATOMMOVED, new Object[]{sJmol, bsMoved});
        }
    }

    synchronized void setStatusAtomPicked(int atomIndex, String strInfo, Map<String, Object> map) {
        String sJmol = this.jmolScriptCallback(CBK.PICK);
        Logger.info("setStatusAtomPicked(" + atomIndex + "," + strInfo + ")");
        this.setStatusChanged("atomPicked", atomIndex, strInfo, false);
        if (this.notifyEnabled(CBK.PICK)) {
            this.cbl.notifyCallback(CBK.PICK, new Object[]{sJmol, strInfo, atomIndex, map});
        }
    }

    synchronized int setStatusClicked(int x, int y, int action, int clickCount, int mode) {
        String sJmol = this.jmolScriptCallback(CBK.CLICK);
        if (!this.notifyEnabled(CBK.CLICK)) {
            return action;
        }
        int[] m = new int[]{action, mode};
        this.cbl.notifyCallback(CBK.CLICK, new Object[]{sJmol, x, y, action, clickCount, m});
        return m[0];
    }

    synchronized void setStatusResized(int width, int height) {
        String sJmol = this.jmolScriptCallback(CBK.RESIZE);
        if (this.notifyEnabled(CBK.RESIZE)) {
            this.cbl.notifyCallback(CBK.RESIZE, new Object[]{sJmol, width, height});
        }
    }

    boolean haveHoverCallback() {
        return this.jmolScriptCallbacks.containsKey((Object)CBK.HOVER) || this.notifyEnabled(CBK.HOVER);
    }

    synchronized void setStatusAtomHovered(int iatom, String strInfo) {
        String sJmol = this.jmolScriptCallback(CBK.HOVER);
        if (this.notifyEnabled(CBK.HOVER)) {
            this.cbl.notifyCallback(CBK.HOVER, new Object[]{sJmol, strInfo, iatom});
        }
    }

    synchronized void setStatusObjectHovered(String id, String strInfo, T3 pt) {
        String sJmol = this.jmolScriptCallback(CBK.HOVER);
        if (this.notifyEnabled(CBK.HOVER)) {
            this.cbl.notifyCallback(CBK.HOVER, new Object[]{sJmol, strInfo, -1, id, Float.valueOf(pt.x), Float.valueOf(pt.y), Float.valueOf(pt.z)});
        }
    }

    synchronized void showImage(String title, Object image) {
        String[] a = PT.split(title, "\u0001");
        title = a.length < 3 || a[2].equals("null") ? a[1].substring(a[1].lastIndexOf("/") + 1) : a[2];
        String sJmol = this.jmolScriptCallback(CBK.IMAGE);
        if (this.notifyEnabled(CBK.IMAGE)) {
            this.cbl.notifyCallback(CBK.IMAGE, new Object[]{sJmol, title, image});
        }
        if (Boolean.TRUE.equals(image)) {
            if (this.imageMap == null) {
                return;
            }
            Lst<String> lst = new Lst<String>();
            for (String key : this.imageMap.keySet()) {
                lst.addLast(key);
            }
            int i = lst.size();
            while (--i >= 0) {
                this.imageMap.get(lst.get(i)).closeMe();
            }
            return;
        }
        if (this.imageMap == null) {
            this.imageMap = new Hashtable<String, GenericImageDialog>();
        }
        GenericImageDialog d = this.imageMap.get(title);
        if (Boolean.FALSE.equals(image)) {
            if (d != null) {
                d.closeMe();
            }
            return;
        }
        if (d == null && image != null) {
            d = this.vwr.apiPlatform.getImageDialog(title, this.imageMap);
        }
        if (d == null) {
            return;
        }
        if (image == null) {
            d.closeMe();
        } else {
            d.setImage(image);
        }
    }

    synchronized void setFileLoadStatus(String fullPathName, String fileName, String modelName, String errorMsg, int ptLoad, boolean doCallback, Boolean isAsync) {
        if (fullPathName == null && "resetUndo".equals(fileName)) {
            JmolAppConsoleInterface appConsole = (JmolAppConsoleInterface)this.vwr.getProperty("DATA_API", "getAppConsole", null);
            if (appConsole != null) {
                appConsole.zap();
            }
            fileName = this.vwr.getZapName();
        }
        this.setStatusChanged("fileLoaded", ptLoad, fullPathName, false);
        if (errorMsg != null) {
            this.setStatusChanged("fileLoadError", ptLoad, errorMsg, false);
        }
        String sJmol = this.jmolScriptCallback(CBK.LOADSTRUCT);
        if (doCallback && this.notifyEnabled(CBK.LOADSTRUCT)) {
            String name = (String)this.vwr.getP("_smilesString");
            if (name.length() != 0) {
                fileName = name;
            }
            this.cbl.notifyCallback(CBK.LOADSTRUCT, new Object[]{sJmol, fullPathName, fileName, modelName, errorMsg, ptLoad, this.vwr.getP("_modelNumber"), this.vwr.getModelNumberDotted(this.vwr.ms.mc - 1), isAsync});
        }
    }

    synchronized void setStatusFrameChanged(int fileNo, int modelNo, int firstNo, int lastNo, int currentFrame, float currentMorphModel, String entryName) {
        if (this.vwr.ms == null) {
            return;
        }
        boolean animating = this.vwr.am.animationOn;
        int frameNo = animating ? -2 - currentFrame : currentFrame;
        this.setStatusChanged("frameChanged", frameNo, currentFrame >= 0 ? this.vwr.getModelNumberDotted(currentFrame) : "", false);
        String sJmol = this.jmolScriptCallback(CBK.ANIMFRAME);
        if (this.notifyEnabled(CBK.ANIMFRAME)) {
            this.cbl.notifyCallback(CBK.ANIMFRAME, new Object[]{sJmol, new int[]{frameNo, fileNo, modelNo, firstNo, lastNo, currentFrame}, entryName, Float.valueOf(currentMorphModel)});
        }
        if (!animating) {
            this.vwr.checkMenuUpdate();
        }
    }

    synchronized boolean setStatusDragDropped(int mode, int x, int y, String fileName) {
        this.setStatusChanged("dragDrop", 0, "", false);
        String sJmol = this.jmolScriptCallback(CBK.DRAGDROP);
        if (!this.notifyEnabled(CBK.DRAGDROP)) {
            return false;
        }
        this.cbl.notifyCallback(CBK.DRAGDROP, new Object[]{sJmol, mode, x, y, fileName});
        return true;
    }

    synchronized void setScriptEcho(String strEcho, boolean isScriptQueued) {
        if (strEcho == null) {
            return;
        }
        this.setStatusChanged("scriptEcho", 0, strEcho, false);
        String sJmol = this.jmolScriptCallback(CBK.ECHO);
        if (this.notifyEnabled(CBK.ECHO)) {
            this.cbl.notifyCallback(CBK.ECHO, new Object[]{sJmol, strEcho, isScriptQueued ? 1 : 0});
        }
    }

    synchronized void setStatusMeasuring(String status, int intInfo, String strMeasure, float value) {
        this.setStatusChanged(status, intInfo, strMeasure, false);
        String sJmol = null;
        if (status.equals("measureCompleted")) {
            Logger.info("measurement[" + intInfo + "] = " + strMeasure);
            sJmol = this.jmolScriptCallback(CBK.MEASURE);
        } else if (status.equals("measurePicked")) {
            this.setStatusChanged("measurePicked", intInfo, strMeasure, false);
            Logger.info("measurePicked " + intInfo + " " + strMeasure);
        }
        if (this.notifyEnabled(CBK.MEASURE)) {
            this.cbl.notifyCallback(CBK.MEASURE, new Object[]{sJmol, strMeasure, intInfo, status, Float.valueOf(value)});
        }
    }

    synchronized void notifyError(String errType, String errMsg, String errMsgUntranslated) {
        String sJmol = this.jmolScriptCallback(CBK.ERROR);
        if (this.notifyEnabled(CBK.ERROR)) {
            this.cbl.notifyCallback(CBK.ERROR, new Object[]{sJmol, errType, errMsg, this.vwr.getShapeErrorState(), errMsgUntranslated});
        }
    }

    synchronized void notifyMinimizationStatus(String minStatus, Integer minSteps, Float minEnergy, Float minEnergyDiff, String ff) {
        String sJmol = this.jmolScriptCallback(CBK.MINIMIZATION);
        if (this.notifyEnabled(CBK.MINIMIZATION)) {
            this.cbl.notifyCallback(CBK.MINIMIZATION, new Object[]{sJmol, minStatus, minSteps, minEnergy, minEnergyDiff, ff});
        }
    }

    synchronized void setScriptStatus(String strStatus, String statusMessage, int msWalltime, String strErrorMessageUntranslated) {
        boolean isScriptCompletion;
        if (msWalltime < -1) {
            int iscript = -2 - msWalltime;
            this.setStatusChanged("scriptStarted", iscript, statusMessage, false);
            strStatus = "script " + iscript + " started";
        } else if (strStatus == null) {
            return;
        }
        String sJmol = msWalltime == 0 ? this.jmolScriptCallback(CBK.SCRIPT) : null;
        boolean bl = isScriptCompletion = strStatus == "Script completed";
        if (this.recordStatus("script")) {
            boolean isError = strErrorMessageUntranslated != null;
            this.setStatusChanged(isError ? "scriptError" : "scriptStatus", 0, strStatus, false);
            if (isError || isScriptCompletion) {
                this.setStatusChanged("scriptTerminated", 1, "Jmol script terminated" + (isError ? " unsuccessfully: " + strStatus : " successfully"), false);
            }
        }
        if (isScriptCompletion && this.vwr.getBoolean(603979880) && this.vwr.getBoolean(603979825)) {
            strStatus = this.vwr.getChimeMessenger().scriptCompleted(this, statusMessage, strErrorMessageUntranslated);
        }
        Object[] data = new Object[]{sJmol, strStatus, statusMessage, isScriptCompletion ? -1 : msWalltime, strErrorMessageUntranslated};
        if (this.notifyEnabled(CBK.SCRIPT)) {
            this.cbl.notifyCallback(CBK.SCRIPT, data);
        }
        this.processScript(data);
    }

    void processScript(Object[] data) {
        int msWalltime = (Integer)data[3];
        if (this.vwr.scriptEditor != null) {
            if (msWalltime > 0) {
                this.vwr.scriptEditor.notifyScriptTermination();
            } else if (msWalltime < 0) {
                if (msWalltime == -2) {
                    this.vwr.scriptEditor.notifyScriptStart();
                }
            } else if (this.vwr.scriptEditor.isVisible() && ((String)data[2]).length() > 0) {
                this.vwr.scriptEditor.notifyContext(this.vwr.getScriptContext("SE notify"), data);
            }
        }
        if (this.vwr.appConsole != null && msWalltime == 0) {
            String strInfo = data[1] == null ? null : data[1].toString();
            this.vwr.appConsole.sendConsoleMessage(strInfo);
        }
    }

    boolean doSync() {
        return this.isSynced && this.drivingSync && !this.syncDisabled;
    }

    synchronized void setSync(String mouseCommand) {
        if (this.syncingMouse) {
            if (mouseCommand != null) {
                this.syncSend(mouseCommand, "*", 0);
            }
        } else if (!this.syncingScripts) {
            this.syncSend("!" + this.vwr.tm.getMoveToText((float)this.minSyncRepeatMs / 1000.0f, false), "*", 0);
        }
    }

    void setSyncDriver(int syncMode) {
        if (this.stereoSync && syncMode != 4) {
            this.syncSend("SET_GRAPHICS_OFF", "*", 0);
            this.stereoSync = false;
        }
        switch (syncMode) {
            case 4: {
                if (!this.syncDisabled) {
                    return;
                }
                this.syncDisabled = false;
                break;
            }
            case 3: {
                this.syncDisabled = true;
                break;
            }
            case 5: {
                this.drivingSync = true;
                this.isSynced = true;
                this.stereoSync = true;
                break;
            }
            case 1: {
                this.drivingSync = true;
                this.isSynced = true;
                break;
            }
            case 2: {
                this.drivingSync = false;
                this.isSynced = true;
                break;
            }
            default: {
                this.drivingSync = false;
                this.isSynced = false;
            }
        }
        if (Logger.debugging) {
            Logger.debug(this.vwr.appletName + " sync mode=" + syncMode + "; synced? " + this.isSynced + "; driving? " + this.drivingSync + "; disabled? " + this.syncDisabled);
        }
    }

    public void playAudio(String fileNameOrDataURI) {
        this.syncSend(fileNameOrDataURI, "audio:", -1);
    }

    public Object syncSend(String script, Object appletNameOrProp, int port) {
        if (port != 0 || this.notifyEnabled(CBK.SYNC)) {
            Object[] o = new Object[]{null, script, appletNameOrProp, port};
            if (this.cbl != null) {
                this.cbl.notifyCallback(CBK.SYNC, o);
            }
            return o[0];
        }
        return null;
    }

    public void modifySend(int atomIndex, int modelIndex, int mode, String msg) {
        String sJmol = this.jmolScriptCallback(CBK.STRUCTUREMODIFIED);
        if (this.notifyEnabled(CBK.STRUCTUREMODIFIED)) {
            this.cbl.notifyCallback(CBK.STRUCTUREMODIFIED, new Object[]{sJmol, mode, atomIndex, modelIndex, msg});
        }
    }

    public Object processService(Map<String, Object> info) {
        Object s = info.get("service");
        if (s == null) {
            return null;
        }
        if (s instanceof SV) {
            Hashtable<String, Object> m = new Hashtable<String, Object>();
            for (Map.Entry<String, Object> e : info.entrySet()) {
                m.put(e.getKey(), SV.oValue(e.getValue()));
            }
            info = m;
        }
        if (this.notifyEnabled(CBK.SERVICE)) {
            this.cbl.notifyCallback(CBK.SERVICE, new Object[]{null, info});
        }
        return info;
    }

    public int getSyncMode() {
        return !this.isSynced ? 0 : (this.drivingSync ? 1 : 2);
    }

    synchronized void showUrl(String urlString) {
        if (this.jsl != null) {
            this.jsl.showUrl(urlString);
        }
    }

    public synchronized void clearConsole() {
        if (this.vwr.appConsole != null) {
            this.vwr.appConsole.sendConsoleMessage(null);
        }
        if (this.jsl != null) {
            this.cbl.notifyCallback(CBK.MESSAGE, null);
        }
    }

    float[][] functionXY(String functionName, int nX, int nY) {
        return this.jsl == null ? new float[Math.abs(nX)][Math.abs(nY)] : this.jsl.functionXY(functionName, nX, nY);
    }

    float[][][] functionXYZ(String functionName, int nX, int nY, int nZ) {
        return this.jsl == null ? new float[Math.abs(nX)][Math.abs(nY)][Math.abs(nY)] : this.jsl.functionXYZ(functionName, nX, nY, nZ);
    }

    String jsEval(String strEval) {
        return this.jsl == null ? "" : this.jsl.eval(strEval);
    }

    String createImage(String fileNameOrError, String type, String text, byte[] bytes, int quality) {
        return this.jsl == null ? null : this.jsl.createImage(fileNameOrError, type, text == null ? bytes : (byte[])text, quality);
    }

    Map<String, Object> getRegistryInfo() {
        return this.jsl == null ? null : this.jsl.getRegistryInfo();
    }

    String dialogAsk(String type, String fileName, Map<String, Object> params) {
        boolean isImage = type.equals("Save Image");
        JmolDialogInterface sd = (JmolDialogInterface)Interface.getOption("dialog.Dialog", this.vwr, "status");
        if (sd == null) {
            return null;
        }
        sd.setupUI(false);
        if (isImage) {
            sd.setImageInfo(this.qualityJPG, this.qualityPNG, this.imageType);
        }
        String outputFileName = sd.getFileNameFromDialog(this.vwr, type, fileName);
        if (isImage && outputFileName != null) {
            this.qualityJPG = sd.getQuality("JPG");
            this.qualityPNG = sd.getQuality("PNG");
            String sType = sd.getType();
            if (params != null) {
                params.put("qualityJPG", this.qualityJPG);
                params.put("qualityPNG", this.qualityPNG);
                if (sType != null) {
                    params.put("dialogImageType", sType);
                }
            }
            if (sType != null) {
                this.imageType = sType;
            }
        }
        return outputFileName;
    }

    Map<String, Object> getJspecViewProperties(String myParam) {
        return this.jsl == null ? null : this.jsl.getJSpecViewProperty(myParam == null || myParam.length() == 0 ? "" : ":" + myParam);
    }

    public int[] resizeInnerPanel(int width, int height) {
        int[] nArray;
        if (this.jsl == null || width == this.vwr.getScreenWidth() && height == this.vwr.getScreenHeight()) {
            int[] nArray2 = new int[2];
            nArray2[0] = width;
            nArray = nArray2;
            nArray2[1] = height;
        } else {
            nArray = this.jsl.resizeInnerPanel("preferredWidthHeight " + width + " " + height + ";");
        }
        return nArray;
    }
}

