/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.Property;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import jnr.constants.platform.Errno;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Main;
import org.jruby.ext.ffi.Platform;
import org.jruby.runtime.Constants;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreMethodNodeManager;
import org.jruby.truffle.builtins.PrimitiveManager;
import org.jruby.truffle.core.MainNodesFactory;
import org.jruby.truffle.core.MathNodesFactory;
import org.jruby.truffle.core.ObjectNodesFactory;
import org.jruby.truffle.core.ProcessNodesFactory;
import org.jruby.truffle.core.TruffleGCNodesFactory;
import org.jruby.truffle.core.TruffleProcessNodesFactory;
import org.jruby.truffle.core.TruffleSystemNodesFactory;
import org.jruby.truffle.core.VMPrimitiveNodesFactory;
import org.jruby.truffle.core.array.ArrayNodes;
import org.jruby.truffle.core.array.ArrayNodesFactory;
import org.jruby.truffle.core.array.TruffleArrayNodesFactory;
import org.jruby.truffle.core.basicobject.BasicObjectNodesFactory;
import org.jruby.truffle.core.binding.BindingNodesFactory;
import org.jruby.truffle.core.binding.TruffleBindingNodesFactory;
import org.jruby.truffle.core.bool.FalseClassNodesFactory;
import org.jruby.truffle.core.bool.TrueClassNodesFactory;
import org.jruby.truffle.core.dir.DirNodesFactory;
import org.jruby.truffle.core.encoding.EncodingConverterNodesFactory;
import org.jruby.truffle.core.encoding.EncodingNodesFactory;
import org.jruby.truffle.core.exception.ExceptionNodesFactory;
import org.jruby.truffle.core.exception.NameErrorNodesFactory;
import org.jruby.truffle.core.exception.NoMethodErrorNodesFactory;
import org.jruby.truffle.core.exception.SystemCallErrorNodesFactory;
import org.jruby.truffle.core.fiber.FiberNodesFactory;
import org.jruby.truffle.core.hash.HashNodesFactory;
import org.jruby.truffle.core.kernel.KernelNodesFactory;
import org.jruby.truffle.core.kernel.TruffleKernelNodesFactory;
import org.jruby.truffle.core.klass.ClassNodes;
import org.jruby.truffle.core.klass.ClassNodesFactory;
import org.jruby.truffle.core.method.MethodNodesFactory;
import org.jruby.truffle.core.method.UnboundMethodNodesFactory;
import org.jruby.truffle.core.module.ModuleNodes;
import org.jruby.truffle.core.module.ModuleNodesFactory;
import org.jruby.truffle.core.mutex.ConditionVariableNodesFactory;
import org.jruby.truffle.core.mutex.MutexNodesFactory;
import org.jruby.truffle.core.numeric.BignumNodesFactory;
import org.jruby.truffle.core.numeric.FixnumNodesFactory;
import org.jruby.truffle.core.numeric.FloatNodesFactory;
import org.jruby.truffle.core.numeric.IntegerNodesFactory;
import org.jruby.truffle.core.numeric.TruffleFixnumNodesFactory;
import org.jruby.truffle.core.objectspace.ObjectSpaceNodesFactory;
import org.jruby.truffle.core.proc.ProcNodesFactory;
import org.jruby.truffle.core.queue.QueueNodesFactory;
import org.jruby.truffle.core.queue.SizedQueueNodesFactory;
import org.jruby.truffle.core.range.RangeNodesFactory;
import org.jruby.truffle.core.regexp.MatchDataNodesFactory;
import org.jruby.truffle.core.regexp.RegexpNodesFactory;
import org.jruby.truffle.core.rope.TruffleRopesNodesFactory;
import org.jruby.truffle.core.rubinius.AtomicReferenceNodesFactory;
import org.jruby.truffle.core.rubinius.ByteArrayNodesFactory;
import org.jruby.truffle.core.rubinius.IOBufferPrimitiveNodesFactory;
import org.jruby.truffle.core.rubinius.IOPrimitiveNodesFactory;
import org.jruby.truffle.core.rubinius.NativeFunctionPrimitiveNodesFactory;
import org.jruby.truffle.core.rubinius.RandomizerPrimitiveNodesFactory;
import org.jruby.truffle.core.rubinius.RegexpPrimitiveNodesFactory;
import org.jruby.truffle.core.rubinius.RubiniusTypeNodesFactory;
import org.jruby.truffle.core.rubinius.StatPrimitiveNodesFactory;
import org.jruby.truffle.core.rubinius.UndefinedPrimitiveNodesFactory;
import org.jruby.truffle.core.rubinius.WeakRefPrimitiveNodesFactory;
import org.jruby.truffle.core.string.StringNodesFactory;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.string.TruffleStringNodesFactory;
import org.jruby.truffle.core.symbol.SymbolNodesFactory;
import org.jruby.truffle.core.thread.ThreadBacktraceLocationLayoutImpl;
import org.jruby.truffle.core.thread.ThreadBacktraceLocationNodesFactory;
import org.jruby.truffle.core.thread.ThreadNodesFactory;
import org.jruby.truffle.core.time.TimeNodesFactory;
import org.jruby.truffle.core.tracepoint.TracePointNodesFactory;
import org.jruby.truffle.debug.TruffleDebugNodesFactory;
import org.jruby.truffle.extra.AttachmentsInternalNodesFactory;
import org.jruby.truffle.extra.TruffleGraalNodesFactory;
import org.jruby.truffle.extra.TrufflePosixNodesFactory;
import org.jruby.truffle.extra.ffi.PointerPrimitiveNodesFactory;
import org.jruby.truffle.gem.bcrypt.BCryptNodesFactory;
import org.jruby.truffle.interop.InteropNodesFactory;
import org.jruby.truffle.interop.cext.CExtNodesFactory;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.TruffleBootNodesFactory;
import org.jruby.truffle.language.TruffleSafeNodesFactory;
import org.jruby.truffle.language.backtrace.BacktraceFormatter;
import org.jruby.truffle.language.control.JavaException;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.control.TruffleFatalException;
import org.jruby.truffle.language.globals.GlobalVariableStorage;
import org.jruby.truffle.language.globals.GlobalVariables;
import org.jruby.truffle.language.loader.CodeLoader;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.objects.FreezeNode;
import org.jruby.truffle.language.objects.FreezeNodeGen;
import org.jruby.truffle.language.objects.SingletonClassNode;
import org.jruby.truffle.language.objects.SingletonClassNodeGen;
import org.jruby.truffle.language.parser.ParserContext;
import org.jruby.truffle.platform.signal.SignalManager;
import org.jruby.truffle.stdlib.CoverageNodesFactory;
import org.jruby.truffle.stdlib.EtcNodesFactory;
import org.jruby.truffle.stdlib.ObjSpaceNodesFactory;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalNodesFactory;
import org.jruby.truffle.stdlib.digest.DigestNodesFactory;
import org.jruby.truffle.stdlib.psych.PsychEmitterNodesFactory;
import org.jruby.truffle.stdlib.psych.PsychParserNodesFactory;
import org.jruby.truffle.stdlib.psych.YAMLEncoding;
import org.jruby.truffle.util.StringUtils;
import org.jruby.util.cli.Options;
import org.jruby.util.cli.OutputStrings;

public class CoreLibrary {
    private static final String CLI_RECORD_SEPARATOR = (String)Options.CLI_RECORD_SEPARATOR.load();
    private static final Property ALWAYS_FROZEN_PROPERTY = Property.create(Layouts.FROZEN_IDENTIFIER, Layout.createLayout().createAllocator().constantLocation(true), 0);
    private final RubyContext context;
    private final DynamicObject argumentErrorClass;
    private final DynamicObject arrayClass;
    private final DynamicObjectFactory arrayFactory;
    private final DynamicObject basicObjectClass;
    private final DynamicObject bignumClass;
    private final DynamicObjectFactory bignumFactory;
    private final DynamicObject bindingClass;
    private final DynamicObjectFactory bindingFactory;
    private final DynamicObject classClass;
    private final DynamicObject complexClass;
    private final DynamicObject dirClass;
    private final DynamicObject encodingClass;
    private final DynamicObjectFactory encodingFactory;
    private final DynamicObject encodingConverterClass;
    private final DynamicObject encodingErrorClass;
    private final DynamicObject exceptionClass;
    private final DynamicObject falseClass;
    private final DynamicObject fiberClass;
    private final DynamicObjectFactory fiberFactory;
    private final DynamicObject fixnumClass;
    private final DynamicObject floatClass;
    private final DynamicObject floatDomainErrorClass;
    private final DynamicObject hashClass;
    private final DynamicObjectFactory hashFactory;
    private final DynamicObject integerClass;
    private final DynamicObject indexErrorClass;
    private final DynamicObject ioErrorClass;
    private final DynamicObject loadErrorClass;
    private final DynamicObject localJumpErrorClass;
    private final DynamicObject lookupTableClass;
    private final DynamicObject matchDataClass;
    private final DynamicObjectFactory matchDataFactory;
    private final DynamicObject moduleClass;
    private final DynamicObject nameErrorClass;
    private final DynamicObjectFactory nameErrorFactory;
    private final DynamicObject nilClass;
    private final DynamicObject noMethodErrorClass;
    private final DynamicObjectFactory noMethodErrorFactory;
    private final DynamicObject notImplementedErrorClass;
    private final DynamicObject numericClass;
    private final DynamicObject objectClass;
    private final DynamicObjectFactory objectFactory;
    private final DynamicObject procClass;
    private final DynamicObjectFactory procFactory;
    private final DynamicObject processModule;
    private final DynamicObject rangeClass;
    private final DynamicObjectFactory intRangeFactory;
    private final DynamicObjectFactory longRangeFactory;
    private final DynamicObject rangeErrorClass;
    private final DynamicObject rationalClass;
    private final DynamicObject regexpClass;
    private final DynamicObjectFactory regexpFactory;
    private final DynamicObject regexpErrorClass;
    private final DynamicObject rubyTruffleErrorClass;
    private final DynamicObject runtimeErrorClass;
    private final DynamicObject systemStackErrorClass;
    private final DynamicObject securityErrorClass;
    private final DynamicObject standardErrorClass;
    private final DynamicObject stringClass;
    private final DynamicObjectFactory stringFactory;
    private final DynamicObject symbolClass;
    private final DynamicObjectFactory symbolFactory;
    private final DynamicObject syntaxErrorClass;
    private final DynamicObject systemCallErrorClass;
    private final DynamicObject systemExitClass;
    private final DynamicObject threadClass;
    private final DynamicObjectFactory threadFactory;
    private final DynamicObject threadBacktraceClass;
    private final DynamicObject threadBacktraceLocationClass;
    private final DynamicObjectFactory threadBacktraceLocationFactory;
    private final DynamicObject timeClass;
    private final DynamicObjectFactory timeFactory;
    private final DynamicObject transcodingClass;
    private final DynamicObject trueClass;
    private final DynamicObject typeErrorClass;
    private final DynamicObject zeroDivisionErrorClass;
    private final DynamicObject enumerableModule;
    private final DynamicObject errnoModule;
    private final DynamicObject kernelModule;
    private final DynamicObject rubiniusModule;
    private final DynamicObject rubiniusFFIModule;
    private final DynamicObject rubiniusFFIPointerClass;
    private final DynamicObject signalModule;
    private final DynamicObject truffleModule;
    private final DynamicObject bigDecimalClass;
    private final DynamicObject encodingCompatibilityErrorClass;
    private final DynamicObject methodClass;
    private final DynamicObjectFactory methodFactory;
    private final DynamicObject unboundMethodClass;
    private final DynamicObjectFactory unboundMethodFactory;
    private final DynamicObject byteArrayClass;
    private final DynamicObjectFactory byteArrayFactory;
    private final DynamicObjectFactory statFactory;
    private final DynamicObject fiberErrorClass;
    private final DynamicObject threadErrorClass;
    private final DynamicObject internalBufferClass;
    private final DynamicObject weakRefClass;
    private final DynamicObjectFactory weakRefFactory;
    private final DynamicObject objectSpaceModule;
    private final DynamicObject psychModule;
    private final DynamicObject psychParserClass;
    private final DynamicObject randomizerClass;
    private final DynamicObjectFactory randomizerFactory;
    private final DynamicObject atomicReferenceClass;
    private final DynamicObject handleClass;
    private final DynamicObjectFactory handleFactory;
    private final DynamicObject ioClass;
    private final DynamicObject argv;
    private final GlobalVariables globalVariables;
    private final DynamicObject mainObject;
    private final DynamicObject nilObject;
    private final DynamicObject rubiniusUndefined;
    private final DynamicObject digestClass;
    private final DynamicObjectFactory digestFactory;
    @CompilerDirectives.CompilationFinal
    private DynamicObject eagainWaitReadable;
    @CompilerDirectives.CompilationFinal
    private DynamicObject eagainWaitWritable;
    @CompilerDirectives.CompilationFinal
    private ArrayNodes.MinBlock arrayMinBlock;
    @CompilerDirectives.CompilationFinal
    private ArrayNodes.MaxBlock arrayMaxBlock;
    private final Map<Errno, DynamicObject> errnoClasses = new HashMap<Errno, DynamicObject>();
    @CompilerDirectives.CompilationFinal
    private InternalMethod basicObjectSendMethod;
    @CompilerDirectives.CompilationFinal
    private GlobalVariableStorage loadPathStorage;
    @CompilerDirectives.CompilationFinal
    private GlobalVariableStorage loadedFeaturesStorage;
    private static final Object systemObject = TruffleOptions.AOT ? null : JavaInterop.asTruffleObject(System.class);
    private final String coreLoadPath;
    private State state = State.INITIALIZING;
    private final CoreLibraryNode node;
    private static final String[] coreFiles = new String[]{"/core/pre.rb", "/core/lookuptable.rb", "/core/basic_object.rb", "/core/mirror.rb", "/core/bignum.rb", "/core/channel.rb", "/core/character.rb", "/core/configuration.rb", "/core/false.rb", "/core/gc.rb", "/core/nil.rb", "/core/rubinius.rb", "/core/stat.rb", "/core/string.rb", "/core/thread.rb", "/core/true.rb", "/core/type.rb", "/core/weakref.rb", "/core/library.rb", "/core/truffle/ffi/ffi.rb", "/core/truffle/ffi/pointer.rb", "/core/truffle/ffi/ffi_file.rb", "/core/truffle/ffi/ffi_struct.rb", "/core/truffle/support.rb", "/core/io.rb", "/core/immediate.rb", "/core/string_mirror.rb", "/core/module.rb", "/core/proc.rb", "/core/enumerable_helper.rb", "/core/enumerable.rb", "/core/enumerator.rb", "/core/argf.rb", "/core/exception.rb", "/core/undefined.rb", "/core/hash.rb", "/core/array.rb", "/core/kernel.rb", "/core/identity_map.rb", "/core/comparable.rb", "/core/numeric_mirror.rb", "/core/numeric.rb", "/core/truffle/ctype.rb", "/core/integer.rb", "/core/fixnum.rb", "/core/regexp.rb", "/core/encoding.rb", "/core/env.rb", "/core/errno.rb", "/core/file.rb", "/core/dir.rb", "/core/dir_glob.rb", "/core/file_test.rb", "/core/float.rb", "/core/marshal.rb", "/core/object_space.rb", "/core/range_mirror.rb", "/core/range.rb", "/core/struct.rb", "/core/tms.rb", "/core/process.rb", "/core/process_mirror.rb", "/core/random.rb", "/core/signal.rb", "/core/splitter.rb", "/core/symbol.rb", "/core/mutex.rb", "/core/throw_catch.rb", "/core/time.rb", "/core/rational.rb", "/core/rationalizer.rb", "/core/complex.rb", "/core/complexifier.rb", "/core/class.rb", "/core/binding.rb", "/core/math.rb", "/core/method.rb", "/core/unbound_method.rb", "/core/truffle/attachments.rb", "/core/truffle/debug.rb", "/core/truffle/cext.rb", "/core/truffle/interop.rb", "/core/rbconfig.rb", "/core/main.rb", "/core/post.rb"};

    private String buildCoreLoadPath() {
        String path = this.context.getOptions().CORE_LOAD_PATH;
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.startsWith("truffle:")) {
            return path;
        }
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            throw new JavaException(e);
        }
    }

    public CoreLibrary(RubyContext context) {
        this.context = context;
        this.coreLoadPath = this.buildCoreLoadPath();
        this.node = new CoreLibraryNode(context);
        this.classClass = ClassNodes.createClassClass(context);
        this.basicObjectClass = ClassNodes.createBootClass(context, this.classClass, null, "BasicObject");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.basicObjectClass, Layouts.BASIC_OBJECT.createBasicObjectShape(this.basicObjectClass, this.basicObjectClass));
        this.objectClass = ClassNodes.createBootClass(context, this.classClass, this.basicObjectClass, "Object");
        this.objectFactory = Layouts.BASIC_OBJECT.createBasicObjectShape(this.objectClass, this.objectClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.objectClass, this.objectFactory);
        this.moduleClass = ClassNodes.createBootClass(context, this.classClass, this.objectClass, "Module");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.moduleClass, Layouts.MODULE.createModuleShape(this.moduleClass, this.moduleClass));
        Layouts.MODULE.getFields((DynamicObject)this.classClass).parentModule = Layouts.MODULE.getFields((DynamicObject)this.moduleClass).start;
        Layouts.MODULE.getFields(this.moduleClass).addDependent(this.classClass);
        Layouts.CLASS.setSuperclass(this.classClass, this.moduleClass);
        Layouts.MODULE.getFields(this.classClass).newVersion();
        Layouts.MODULE.getFields(this.classClass).getAdoptedByLexicalParent(context, this.objectClass, "Class", this.node);
        Layouts.MODULE.getFields(this.basicObjectClass).getAdoptedByLexicalParent(context, this.objectClass, "BasicObject", this.node);
        Layouts.MODULE.getFields(this.objectClass).getAdoptedByLexicalParent(context, this.objectClass, "Object", this.node);
        Layouts.MODULE.getFields(this.moduleClass).getAdoptedByLexicalParent(context, this.objectClass, "Module", this.node);
        this.exceptionClass = this.defineClass("Exception");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.exceptionClass, Layouts.EXCEPTION.createExceptionShape(this.exceptionClass, this.exceptionClass));
        this.defineClass(this.exceptionClass, "NoMemoryError");
        this.rubyTruffleErrorClass = this.defineClass(this.exceptionClass, "RubyTruffleError");
        this.standardErrorClass = this.defineClass(this.exceptionClass, "StandardError");
        this.argumentErrorClass = this.defineClass(this.standardErrorClass, "ArgumentError");
        this.encodingErrorClass = this.defineClass(this.standardErrorClass, "EncodingError");
        this.fiberErrorClass = this.defineClass(this.standardErrorClass, "FiberError");
        this.ioErrorClass = this.defineClass(this.standardErrorClass, "IOError");
        this.localJumpErrorClass = this.defineClass(this.standardErrorClass, "LocalJumpError");
        this.regexpErrorClass = this.defineClass(this.standardErrorClass, "RegexpError");
        this.runtimeErrorClass = this.defineClass(this.standardErrorClass, "RuntimeError");
        this.threadErrorClass = this.defineClass(this.standardErrorClass, "ThreadError");
        this.typeErrorClass = this.defineClass(this.standardErrorClass, "TypeError");
        this.zeroDivisionErrorClass = this.defineClass(this.standardErrorClass, "ZeroDivisionError");
        this.rangeErrorClass = this.defineClass(this.standardErrorClass, "RangeError");
        this.floatDomainErrorClass = this.defineClass(this.rangeErrorClass, "FloatDomainError");
        this.indexErrorClass = this.defineClass(this.standardErrorClass, "IndexError");
        this.defineClass(this.indexErrorClass, "KeyError");
        this.defineClass(this.ioErrorClass, "EOFError");
        this.nameErrorClass = this.defineClass(this.standardErrorClass, "NameError");
        this.nameErrorFactory = Layouts.NAME_ERROR.createNameErrorShape(this.nameErrorClass, this.nameErrorClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.nameErrorClass, this.nameErrorFactory);
        this.noMethodErrorClass = this.defineClass(this.nameErrorClass, "NoMethodError");
        this.noMethodErrorFactory = Layouts.NO_METHOD_ERROR.createNoMethodErrorShape(this.noMethodErrorClass, this.noMethodErrorClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.noMethodErrorClass, this.noMethodErrorFactory);
        this.systemCallErrorClass = this.defineClass(this.standardErrorClass, "SystemCallError");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.systemCallErrorClass, Layouts.SYSTEM_CALL_ERROR.createSystemCallErrorShape(this.systemCallErrorClass, this.systemCallErrorClass));
        this.errnoModule = this.defineModule("Errno");
        for (Errno errno : Errno.values()) {
            if (!errno.name().startsWith("E") || errno.equals((Object)Errno.EWOULDBLOCK) && Errno.EWOULDBLOCK.intValue() == Errno.EAGAIN.intValue()) continue;
            this.errnoClasses.put(errno, this.defineClass(this.errnoModule, this.systemCallErrorClass, errno.name()));
        }
        DynamicObject scriptErrorClass = this.defineClass(this.exceptionClass, "ScriptError");
        this.loadErrorClass = this.defineClass(scriptErrorClass, "LoadError");
        this.notImplementedErrorClass = this.defineClass(scriptErrorClass, "NotImplementedError");
        this.syntaxErrorClass = this.defineClass(scriptErrorClass, "SyntaxError");
        this.securityErrorClass = this.defineClass(this.exceptionClass, "SecurityError");
        DynamicObject signalExceptionClass = this.defineClass(this.exceptionClass, "SignalException");
        this.defineClass(signalExceptionClass, "Interrupt");
        this.systemExitClass = this.defineClass(this.exceptionClass, "SystemExit");
        this.systemStackErrorClass = this.defineClass(this.exceptionClass, "SystemStackError");
        this.numericClass = this.defineClass("Numeric");
        this.complexClass = this.defineClass(this.numericClass, "Complex");
        this.floatClass = this.defineClass(this.numericClass, "Float");
        this.integerClass = this.defineClass(this.numericClass, "Integer");
        this.fixnumClass = this.defineClass(this.integerClass, "Fixnum");
        this.bignumClass = this.defineClass(this.integerClass, "Bignum");
        this.bignumFactory = CoreLibrary.alwaysFrozen(Layouts.BIGNUM.createBignumShape(this.bignumClass, this.bignumClass));
        Layouts.CLASS.setInstanceFactoryUnsafe(this.bignumClass, this.bignumFactory);
        this.rationalClass = this.defineClass(this.numericClass, "Rational");
        this.arrayClass = this.defineClass("Array");
        this.arrayFactory = Layouts.ARRAY.createArrayShape(this.arrayClass, this.arrayClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.arrayClass, this.arrayFactory);
        this.bindingClass = this.defineClass("Binding");
        this.bindingFactory = Layouts.BINDING.createBindingShape(this.bindingClass, this.bindingClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.bindingClass, this.bindingFactory);
        DynamicObject conditionVariableClass = this.defineClass("ConditionVariable");
        Layouts.CLASS.setInstanceFactoryUnsafe(conditionVariableClass, Layouts.CONDITION_VARIABLE.createConditionVariableShape(conditionVariableClass, conditionVariableClass));
        this.dirClass = this.defineClass("Dir");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.dirClass, Layouts.DIR.createDirShape(this.dirClass, this.dirClass));
        this.encodingClass = this.defineClass("Encoding");
        this.encodingFactory = Layouts.ENCODING.createEncodingShape(this.encodingClass, this.encodingClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.encodingClass, this.encodingFactory);
        this.falseClass = this.defineClass("FalseClass");
        this.fiberClass = this.defineClass("Fiber");
        this.fiberFactory = Layouts.FIBER.createFiberShape(this.fiberClass, this.fiberClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.fiberClass, this.fiberFactory);
        this.defineModule("FileTest");
        this.hashClass = this.defineClass("Hash");
        this.hashFactory = Layouts.HASH.createHashShape(this.hashClass, this.hashClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.hashClass, this.hashFactory);
        this.matchDataClass = this.defineClass("MatchData");
        this.matchDataFactory = Layouts.MATCH_DATA.createMatchDataShape(this.matchDataClass, this.matchDataClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.matchDataClass, this.matchDataFactory);
        this.methodClass = this.defineClass("Method");
        this.methodFactory = Layouts.METHOD.createMethodShape(this.methodClass, this.methodClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.methodClass, this.methodFactory);
        DynamicObject mutexClass = this.defineClass("Mutex");
        Layouts.CLASS.setInstanceFactoryUnsafe(mutexClass, Layouts.MUTEX.createMutexShape(mutexClass, mutexClass));
        this.nilClass = this.defineClass("NilClass");
        DynamicObjectFactory nilFactory = CoreLibrary.alwaysFrozen(Layouts.CLASS.getInstanceFactory(this.nilClass));
        Layouts.CLASS.setInstanceFactoryUnsafe(this.nilClass, nilFactory);
        this.procClass = this.defineClass("Proc");
        this.procFactory = Layouts.PROC.createProcShape(this.procClass, this.procClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.procClass, this.procFactory);
        this.processModule = this.defineModule("Process");
        DynamicObject queueClass = this.defineClass("Queue");
        Layouts.CLASS.setInstanceFactoryUnsafe(queueClass, Layouts.QUEUE.createQueueShape(queueClass, queueClass));
        DynamicObject sizedQueueClass = this.defineClass(queueClass, "SizedQueue");
        Layouts.CLASS.setInstanceFactoryUnsafe(sizedQueueClass, Layouts.SIZED_QUEUE.createSizedQueueShape(sizedQueueClass, sizedQueueClass));
        this.rangeClass = this.defineClass("Range");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.rangeClass, Layouts.OBJECT_RANGE.createObjectRangeShape(this.rangeClass, this.rangeClass));
        this.intRangeFactory = Layouts.INT_RANGE.createIntRangeShape(this.rangeClass, this.rangeClass);
        this.longRangeFactory = Layouts.LONG_RANGE.createLongRangeShape(this.rangeClass, this.rangeClass);
        this.regexpClass = this.defineClass("Regexp");
        this.regexpFactory = Layouts.REGEXP.createRegexpShape(this.regexpClass, this.regexpClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.regexpClass, this.regexpFactory);
        this.stringClass = this.defineClass("String");
        this.stringFactory = Layouts.STRING.createStringShape(this.stringClass, this.stringClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.stringClass, this.stringFactory);
        this.symbolClass = this.defineClass("Symbol");
        this.symbolFactory = CoreLibrary.alwaysFrozen(Layouts.SYMBOL.createSymbolShape(this.symbolClass, this.symbolClass));
        Layouts.CLASS.setInstanceFactoryUnsafe(this.symbolClass, this.symbolFactory);
        this.threadClass = this.defineClass("Thread");
        this.threadClass.define("@abort_on_exception", false);
        this.threadFactory = Layouts.THREAD.createThreadShape(this.threadClass, this.threadClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.threadClass, this.threadFactory);
        this.threadBacktraceClass = this.defineClass(this.threadClass, this.objectClass, "Backtrace");
        this.threadBacktraceLocationClass = this.defineClass(this.threadBacktraceClass, this.objectClass, "Location");
        this.threadBacktraceLocationFactory = ThreadBacktraceLocationLayoutImpl.INSTANCE.createThreadBacktraceLocationShape(this.threadBacktraceLocationClass, this.threadBacktraceLocationClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.threadBacktraceLocationClass, this.threadBacktraceLocationFactory);
        this.timeClass = this.defineClass("Time");
        this.timeFactory = Layouts.TIME.createTimeShape(this.timeClass, this.timeClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.timeClass, this.timeFactory);
        this.trueClass = this.defineClass("TrueClass");
        this.unboundMethodClass = this.defineClass("UnboundMethod");
        this.unboundMethodFactory = Layouts.UNBOUND_METHOD.createUnboundMethodShape(this.unboundMethodClass, this.unboundMethodClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.unboundMethodClass, this.unboundMethodFactory);
        this.ioClass = this.defineClass("IO");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.ioClass, Layouts.IO.createIOShape(this.ioClass, this.ioClass));
        this.internalBufferClass = this.defineClass(this.ioClass, this.objectClass, "InternalBuffer");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.internalBufferClass, Layouts.IO_BUFFER.createIOBufferShape(this.internalBufferClass, this.internalBufferClass));
        this.weakRefClass = this.defineClass(this.basicObjectClass, "WeakRef");
        this.weakRefFactory = Layouts.WEAK_REF_LAYOUT.createWeakRefShape(this.weakRefClass, this.weakRefClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.weakRefClass, this.weakRefFactory);
        DynamicObject tracePointClass = this.defineClass("TracePoint");
        Layouts.CLASS.setInstanceFactoryUnsafe(tracePointClass, Layouts.TRACE_POINT.createTracePointShape(tracePointClass, tracePointClass));
        DynamicObject comparableModule = this.defineModule("Comparable");
        this.defineModule("Config");
        this.enumerableModule = this.defineModule("Enumerable");
        this.defineModule("GC");
        this.kernelModule = this.defineModule("Kernel");
        this.defineModule("Math");
        this.objectSpaceModule = this.defineModule("ObjectSpace");
        this.signalModule = this.defineModule("Signal");
        this.encodingCompatibilityErrorClass = this.defineClass(this.encodingClass, this.encodingErrorClass, "CompatibilityError");
        this.encodingConverterClass = this.defineClass(this.encodingClass, this.objectClass, "Converter");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.encodingConverterClass, Layouts.ENCODING_CONVERTER.createEncodingConverterShape(this.encodingConverterClass, this.encodingConverterClass));
        this.truffleModule = this.defineModule("Truffle");
        this.defineModule(this.truffleModule, "Interop");
        this.defineModule(this.truffleModule, "CExt");
        this.defineModule(this.truffleModule, "Debug");
        this.defineModule(this.truffleModule, "Digest");
        this.defineModule(this.truffleModule, "ObjSpace");
        this.defineModule(this.truffleModule, "Etc");
        this.defineModule(this.truffleModule, "Coverage");
        this.defineModule(this.truffleModule, "Graal");
        this.defineModule(this.truffleModule, "Ropes");
        this.defineModule(this.truffleModule, "GC");
        this.defineModule(this.truffleModule, "Array");
        this.defineModule(this.truffleModule, "String");
        DynamicObject attachments = this.defineModule(this.truffleModule, "Attachments");
        this.defineModule(attachments, "Internal");
        this.defineModule(this.truffleModule, "Boot");
        this.defineModule(this.truffleModule, "Fixnum");
        this.defineModule(this.truffleModule, "Safe");
        this.defineModule(this.truffleModule, "System");
        this.defineModule(this.truffleModule, "Kernel");
        this.defineModule(this.truffleModule, "Process");
        this.defineModule(this.truffleModule, "Binding");
        this.defineModule(this.truffleModule, "POSIX");
        this.psychModule = this.defineModule("Psych");
        this.psychParserClass = this.defineClass(this.psychModule, this.objectClass, "Parser");
        DynamicObject psychHandlerClass = this.defineClass(this.psychModule, this.objectClass, "Handler");
        DynamicObject psychEmitterClass = this.defineClass(this.psychModule, psychHandlerClass, "Emitter");
        Layouts.CLASS.setInstanceFactoryUnsafe(psychEmitterClass, Layouts.PSYCH_EMITTER.createEmitterShape(psychEmitterClass, psychEmitterClass));
        this.handleClass = this.defineClass(this.truffleModule, this.objectClass, "Handle");
        this.handleFactory = Layouts.HANDLE.createHandleShape(this.handleClass, this.handleClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.handleClass, this.handleFactory);
        this.bigDecimalClass = this.defineClass(this.truffleModule, this.numericClass, "BigDecimal");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.bigDecimalClass, Layouts.BIG_DECIMAL.createBigDecimalShape(this.bigDecimalClass, this.bigDecimalClass));
        DynamicObject gem = this.defineModule(this.truffleModule, "Gem");
        this.defineModule(gem, "BCrypt");
        this.rubiniusModule = this.defineModule("Rubinius");
        this.rubiniusFFIModule = this.defineModule(this.rubiniusModule, "FFI");
        this.rubiniusFFIPointerClass = this.defineClass(this.rubiniusFFIModule, this.objectClass, "Pointer");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.rubiniusFFIPointerClass, Layouts.POINTER.createPointerShape(this.rubiniusFFIPointerClass, this.rubiniusFFIPointerClass));
        this.defineClass(this.rubiniusModule, this.objectClass, "Mirror");
        this.defineModule(this.rubiniusModule, "Type");
        DynamicObject statClass = this.defineClass(this.rubiniusModule, this.objectClass, "Stat");
        this.statFactory = Layouts.STAT.createStatShape(statClass, statClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(statClass, this.statFactory);
        this.byteArrayClass = this.defineClass(this.rubiniusModule, this.objectClass, "ByteArray");
        this.byteArrayFactory = Layouts.BYTE_ARRAY.createByteArrayShape(this.byteArrayClass, this.byteArrayClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.byteArrayClass, this.byteArrayFactory);
        this.lookupTableClass = this.defineClass(this.rubiniusModule, this.hashClass, "LookupTable");
        this.defineClass(this.rubiniusModule, this.objectClass, "StringData");
        this.transcodingClass = this.defineClass(this.encodingClass, this.objectClass, "Transcoding");
        this.randomizerClass = this.defineClass(this.rubiniusModule, this.objectClass, "Randomizer");
        this.atomicReferenceClass = this.defineClass(this.rubiniusModule, this.objectClass, "AtomicReference");
        Layouts.CLASS.setInstanceFactoryUnsafe(this.atomicReferenceClass, Layouts.ATOMIC_REFERENCE.createAtomicReferenceShape(this.atomicReferenceClass, this.atomicReferenceClass));
        this.randomizerFactory = Layouts.RANDOMIZER.createRandomizerShape(this.randomizerClass, this.randomizerClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.randomizerClass, this.randomizerFactory);
        this.includeModules(comparableModule);
        this.mainObject = this.objectFactory.newInstance(new Object[0]);
        this.nilObject = nilFactory.newInstance(new Object[0]);
        this.argv = Layouts.ARRAY.createArray(this.arrayFactory, null, 0);
        this.rubiniusUndefined = this.objectFactory.newInstance(new Object[0]);
        this.globalVariables = new GlobalVariables(this.nilObject);
        this.digestClass = this.defineClass(this.truffleModule, this.basicObjectClass, "Digest");
        this.digestFactory = Layouts.DIGEST.createDigestShape(this.digestClass, this.digestClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(this.digestClass, this.digestFactory);
        assert (Layouts.CLASS.getSuperclass(this.basicObjectClass) == null);
        Layouts.CLASS.setSuperclass(this.basicObjectClass, this.nilObject);
    }

    private static DynamicObjectFactory alwaysFrozen(DynamicObjectFactory factory) {
        return factory.getShape().addProperty(ALWAYS_FROZEN_PROPERTY).createFactory();
    }

    private void includeModules(DynamicObject comparableModule) {
        assert (RubyGuards.isRubyModule(comparableModule));
        Layouts.MODULE.getFields(this.objectClass).include(this.context, this.node, this.kernelModule);
        Layouts.MODULE.getFields(this.numericClass).include(this.context, this.node, comparableModule);
        Layouts.MODULE.getFields(this.symbolClass).include(this.context, this.node, comparableModule);
        Layouts.MODULE.getFields(this.arrayClass).include(this.context, this.node, this.enumerableModule);
        Layouts.MODULE.getFields(this.dirClass).include(this.context, this.node, this.enumerableModule);
        Layouts.MODULE.getFields(this.hashClass).include(this.context, this.node, this.enumerableModule);
        Layouts.MODULE.getFields(this.rangeClass).include(this.context, this.node, this.enumerableModule);
    }

    public void initialize() {
        this.initializeGlobalVariables();
        this.initializeConstants();
        this.initializeEncodingConstants();
        this.initializeSignalConstants();
    }

    public void addPrimitives() {
        PrimitiveManager primitiveManager = this.context.getPrimitiveManager();
        ForkJoinPool.commonPool().invokeAll(Arrays.asList(() -> {
            primitiveManager.addPrimitiveNodes(SymbolNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(FixnumNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(BignumNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(FloatNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(VMPrimitiveNodesFactory.getFactories());
            return null;
        }, () -> {
            primitiveManager.addPrimitiveNodes(EncodingNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(EncodingConverterNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(RegexpPrimitiveNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(RandomizerPrimitiveNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(ObjectNodesFactory.getFactories());
            return null;
        }, () -> {
            primitiveManager.addPrimitiveNodes(ArrayNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(StatPrimitiveNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(PointerPrimitiveNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(NativeFunctionPrimitiveNodesFactory.getFactories());
            return null;
        }, () -> {
            primitiveManager.addPrimitiveNodes(DirNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(IOPrimitiveNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(IOBufferPrimitiveNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(ExceptionNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(NameErrorNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(NoMethodErrorNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(SystemCallErrorNodesFactory.getFactories());
            return null;
        }, () -> {
            primitiveManager.addPrimitiveNodes(ThreadNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(WeakRefPrimitiveNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(TimeNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(StringNodesFactory.getFactories());
            primitiveManager.addPrimitiveNodes(UndefinedPrimitiveNodesFactory.getFactories());
            return null;
        }));
    }

    public void addCoreMethods() {
        this.arrayMinBlock = new ArrayNodes.MinBlock(this.context);
        this.arrayMaxBlock = new ArrayNodes.MaxBlock(this.context);
        CoreMethodNodeManager coreMethodNodeManager = new CoreMethodNodeManager(this.context, this.node.getSingletonClassNode());
        ForkJoinPool.commonPool().invokeAll(Arrays.asList(() -> {
            coreMethodNodeManager.addCoreMethodNodes(ArrayNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(BasicObjectNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(BindingNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(BignumNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(ClassNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(ConditionVariableNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(ExceptionNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(NameErrorNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(NoMethodErrorNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(SystemCallErrorNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(FalseClassNodesFactory.getFactories());
            return null;
        }, () -> {
            coreMethodNodeManager.addCoreMethodNodes(FiberNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(FixnumNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(FloatNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(HashNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(IntegerNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(KernelNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(MainNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(MatchDataNodesFactory.getFactories());
            return null;
        }, () -> {
            coreMethodNodeManager.addCoreMethodNodes(MathNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(ModuleNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(MutexNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(ObjectSpaceNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(ProcessNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(ProcNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(QueueNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(RangeNodesFactory.getFactories());
            return null;
        }, () -> {
            coreMethodNodeManager.addCoreMethodNodes(RegexpNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(SizedQueueNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(StringNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(SymbolNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(ThreadNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TrueClassNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TruffleGCNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TruffleBootNodesFactory.getFactories());
            return null;
        }, () -> {
            coreMethodNodeManager.addCoreMethodNodes(AttachmentsInternalNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TruffleGraalNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(EncodingNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(EncodingConverterNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(InteropNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(CExtNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(MethodNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(UnboundMethodNodesFactory.getFactories());
            return null;
        }, () -> {
            coreMethodNodeManager.addCoreMethodNodes(ByteArrayNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TimeNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TrufflePosixNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(RubiniusTypeNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(ThreadBacktraceLocationNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(DigestNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(BigDecimalNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(ObjSpaceNodesFactory.getFactories());
            return null;
        }, () -> {
            coreMethodNodeManager.addCoreMethodNodes(EtcNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(PsychParserNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(PsychEmitterNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(AtomicReferenceNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TracePointNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(CoverageNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TruffleRopesNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TruffleFixnumNodesFactory.getFactories());
            return null;
        }, () -> {
            coreMethodNodeManager.addCoreMethodNodes(TruffleSafeNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TruffleSystemNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TruffleKernelNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TruffleProcessNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TruffleDebugNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TruffleBindingNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TruffleArrayNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(TruffleStringNodesFactory.getFactories());
            coreMethodNodeManager.addCoreMethodNodes(BCryptNodesFactory.getFactories());
            return null;
        }));
        coreMethodNodeManager.allMethodInstalled();
        this.basicObjectSendMethod = Layouts.MODULE.getFields(this.basicObjectClass).getMethod("__send__");
        assert (this.basicObjectSendMethod != null);
    }

    private void initializeGlobalVariables() {
        GlobalVariables globals = this.globalVariables;
        this.loadPathStorage = globals.put("$LOAD_PATH", Layouts.ARRAY.createArray(this.arrayFactory, null, 0));
        globals.alias("$:", this.loadPathStorage);
        this.loadedFeaturesStorage = globals.put("$LOADED_FEATURES", Layouts.ARRAY.createArray(this.arrayFactory, null, 0));
        globals.alias("$\"", this.loadedFeaturesStorage);
        globals.put("$,", this.nilObject);
        globals.put("$*", this.argv);
        globals.put("$0", StringOperations.createString(this.context, StringOperations.encodeRope(this.context.getJRubyRuntime().getInstanceConfig().displayedFileName(), (Encoding)UTF8Encoding.INSTANCE)));
        globals.put("$DEBUG", this.context.getJRubyRuntime().isDebug());
        DynamicObject value = this.context.getJRubyRuntime().warningsEnabled() ? Boolean.valueOf(this.context.getJRubyRuntime().isVerbose()) : this.nilObject;
        globals.put("$VERBOSE", value);
        DynamicObject defaultRecordSeparator = StringOperations.createString(this.context, StringOperations.encodeRope(CLI_RECORD_SEPARATOR, (Encoding)UTF8Encoding.INSTANCE));
        this.node.freezeNode.executeFreeze(defaultRecordSeparator);
        globals.put("$/", defaultRecordSeparator);
        globals.put("$SAFE", 0);
    }

    private void initializeConstants() {
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_CHAR", 0);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_UCHAR", 1);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_BOOL", 2);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_SHORT", 3);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_USHORT", 4);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_INT", 5);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_UINT", 6);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_LONG", 7);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_ULONG", 8);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_LL", 9);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_ULL", 10);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_FLOAT", 11);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_DOUBLE", 12);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_PTR", 13);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_VOID", 14);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_STRING", 15);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_STRPTR", 16);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_CHARARR", 17);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_ENUM", 18);
        Layouts.MODULE.getFields(this.rubiniusFFIModule).setConstant(this.context, this.node, "TYPE_VARARGS", 19);
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_VERSION", StringOperations.createString(this.context, StringOperations.encodeRope("2.3.1", (Encoding)UTF8Encoding.INSTANCE)));
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "JRUBY_VERSION", StringOperations.createString(this.context, StringOperations.encodeRope("9.1.4.0", (Encoding)UTF8Encoding.INSTANCE)));
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_PATCHLEVEL", 0);
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_REVISION", Constants.RUBY_REVISION);
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_ENGINE", StringOperations.createString(this.context, StringOperations.encodeRope("jruby+truffle", (Encoding)UTF8Encoding.INSTANCE)));
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_PLATFORM", StringOperations.createString(this.context, StringOperations.encodeRope("java", (Encoding)UTF8Encoding.INSTANCE)));
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_RELEASE_DATE", StringOperations.createString(this.context, StringOperations.encodeRope("2016-09-01", (Encoding)UTF8Encoding.INSTANCE)));
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_DESCRIPTION", StringOperations.createString(this.context, StringOperations.encodeRope(OutputStrings.getVersionString(), (Encoding)UTF8Encoding.INSTANCE)));
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "RUBY_COPYRIGHT", StringOperations.createString(this.context, StringOperations.encodeRope(OutputStrings.getCopyrightString(), (Encoding)UTF8Encoding.INSTANCE)));
        Layouts.MODULE.getFields(this.basicObjectClass).setConstant(this.context, this.node, "BasicObject", this.basicObjectClass);
        Layouts.MODULE.getFields(this.objectClass).setConstant(this.context, this.node, "ARGV", this.argv);
        Layouts.MODULE.getFields(this.rubiniusModule).setConstant(this.context, this.node, "UNDEFINED", this.rubiniusUndefined);
        Layouts.MODULE.getFields(this.rubiniusModule).setConstant(this.context, this.node, "LIBC", Platform.LIBC);
        Layouts.MODULE.getFields(this.processModule).setConstant(this.context, this.node, "CLOCK_MONOTONIC", 1);
        Layouts.MODULE.getFields(this.processModule).setConstant(this.context, this.node, "CLOCK_REALTIME", 2);
        if (Platform.getPlatform().getOS() == Platform.OS_TYPE.LINUX) {
            Layouts.MODULE.getFields(this.processModule).setConstant(this.context, this.node, "CLOCK_THREAD_CPUTIME_ID", 3);
            Layouts.MODULE.getFields(this.processModule).setConstant(this.context, this.node, "CLOCK_MONOTONIC_RAW", 4);
        }
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "INVALID_MASK", 15);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "INVALID_REPLACE", 2);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "UNDEF_MASK", 240);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "UNDEF_REPLACE", 32);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "UNDEF_HEX_CHARREF", 48);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "PARTIAL_INPUT", 65536);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "AFTER_OUTPUT", 131072);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "UNIVERSAL_NEWLINE_DECORATOR", 256);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "CRLF_NEWLINE_DECORATOR", 4096);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "CR_NEWLINE_DECORATOR", 8192);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "XML_TEXT_DECORATOR", 16384);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "XML_ATTR_CONTENT_DECORATOR", 32768);
        Layouts.MODULE.getFields(this.encodingConverterClass).setConstant(this.context, this.node, "XML_ATTR_QUOTE_DECORATOR", 0x100000);
        Layouts.MODULE.getFields(this.psychParserClass).setConstant(this.context, this.node, "ANY", YAMLEncoding.YAML_ANY_ENCODING.ordinal());
        Layouts.MODULE.getFields(this.psychParserClass).setConstant(this.context, this.node, "UTF8", YAMLEncoding.YAML_UTF8_ENCODING.ordinal());
        Layouts.MODULE.getFields(this.psychParserClass).setConstant(this.context, this.node, "UTF16LE", YAMLEncoding.YAML_UTF16LE_ENCODING.ordinal());
        Layouts.MODULE.getFields(this.psychParserClass).setConstant(this.context, this.node, "UTF16BE", YAMLEncoding.YAML_UTF16BE_ENCODING.ordinal());
        DynamicObject javaModule = this.defineModule(this.truffleModule, "Java");
        Layouts.MODULE.getFields(javaModule).setConstant(this.context, this.node, "System", systemObject);
        for (Map.Entry<Errno, DynamicObject> entry : this.errnoClasses.entrySet()) {
            Errno errno = entry.getKey();
            DynamicObject errnoClass = entry.getValue();
            Layouts.CLASS.getFields(errnoClass).setConstant(this.context, this.node, "Errno", errno.intValue());
        }
        if (Errno.EWOULDBLOCK.intValue() == Errno.EAGAIN.intValue()) {
            Layouts.MODULE.getFields(this.errnoModule).setConstant(this.context, this.node, Errno.EWOULDBLOCK.name(), this.errnoClasses.get(Errno.EAGAIN));
        }
    }

    private void initializeSignalConstants() {
        Object[] signals = new Object[SignalManager.SIGNALS_LIST.size()];
        int i = 0;
        for (Map.Entry<String, Integer> signal : SignalManager.SIGNALS_LIST.entrySet()) {
            DynamicObject signalName = StringOperations.createString(this.context, StringOperations.encodeRope(signal.getKey(), (Encoding)UTF8Encoding.INSTANCE));
            Object[] objects = new Object[]{signalName, signal.getValue()};
            signals[i++] = Layouts.ARRAY.createArray(this.arrayFactory, objects, objects.length);
        }
        Layouts.MODULE.getFields(this.signalModule).setConstant(this.context, this.node, "SIGNAL_LIST", Layouts.ARRAY.createArray(this.arrayFactory, signals, signals.length));
    }

    private DynamicObject defineClass(String name) {
        return this.defineClass(this.objectClass, name);
    }

    private DynamicObject defineClass(DynamicObject superclass, String name) {
        assert (RubyGuards.isRubyClass(superclass));
        return ClassNodes.createInitializedRubyClass(this.context, this.objectClass, superclass, name);
    }

    private DynamicObject defineClass(DynamicObject lexicalParent, DynamicObject superclass, String name) {
        assert (RubyGuards.isRubyModule(lexicalParent));
        assert (RubyGuards.isRubyClass(superclass));
        return ClassNodes.createInitializedRubyClass(this.context, lexicalParent, superclass, name);
    }

    private DynamicObject defineModule(String name) {
        return this.defineModule(this.objectClass, name);
    }

    private DynamicObject defineModule(DynamicObject lexicalParent, String name) {
        assert (RubyGuards.isRubyModule(lexicalParent));
        return ModuleNodes.createModule(this.context, this.moduleClass, lexicalParent, name, this.node);
    }

    public void loadRubyCore() {
        try {
            Main.printTruffleTimeMetric((String)"before-load-core");
            this.state = State.LOADING_RUBY_CORE;
            Future[] coreFileFutures = new Future[coreFiles.length];
            try {
                int n;
                for (n = 0; n < coreFiles.length; ++n) {
                    int finalN = n;
                    coreFileFutures[n] = ForkJoinPool.commonPool().submit(() -> this.context.getCodeLoader().parse(this.context.getSourceCache().getSource(this.getCoreLoadPath() + coreFiles[finalN]), (Encoding)UTF8Encoding.INSTANCE, ParserContext.TOP_LEVEL, null, true, this.node));
                    if (this.context.getOptions().CORE_PARALLEL_LOAD) continue;
                    coreFileFutures[n].get();
                }
                for (n = 0; n < coreFiles.length; ++n) {
                    RubyRootNode rootNode = (RubyRootNode)coreFileFutures[n].get();
                    CodeLoader.DeferredCall deferredCall = this.context.getCodeLoader().prepareExecute(ParserContext.TOP_LEVEL, DeclarationContext.TOP_LEVEL, rootNode, null, this.context.getCoreLibrary().getMainObject());
                    deferredCall.callWithoutCallNode();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new JavaException(e);
            }
            Main.printTruffleTimeMetric((String)"after-load-core");
        }
        catch (RaiseException e) {
            DynamicObject rubyException = e.getException();
            BacktraceFormatter.createDefaultFormatter(this.getContext()).printBacktrace(this.context, rubyException, Layouts.EXCEPTION.getBacktrace(rubyException));
            throw new TruffleFatalException("couldn't load the core library", e);
        }
        finally {
            this.state = State.LOADED;
        }
        this.eagainWaitReadable = (DynamicObject)Layouts.MODULE.getFields(this.ioClass).getConstant("EAGAINWaitReadable").getValue();
        assert (Layouts.CLASS.isClass(this.eagainWaitReadable));
        this.eagainWaitWritable = (DynamicObject)Layouts.MODULE.getFields(this.ioClass).getConstant("EAGAINWaitWritable").getValue();
        assert (Layouts.CLASS.isClass(this.eagainWaitWritable));
    }

    public void initializePostBoot() {
        if (this.context.getOptions().PLATFORM_SAFE_LOAD) {
            try {
                Main.printTruffleTimeMetric((String)"before-post-boot");
                try {
                    for (String path : new String[]{"/post-boot/gems.rb", "/post-boot/shims.rb"}) {
                        RubyRootNode rootNode = this.context.getCodeLoader().parse(this.context.getSourceCache().getSource(this.getCoreLoadPath() + path), (Encoding)UTF8Encoding.INSTANCE, ParserContext.TOP_LEVEL, null, true, this.node);
                        CodeLoader.DeferredCall deferredCall = this.context.getCodeLoader().prepareExecute(ParserContext.TOP_LEVEL, DeclarationContext.TOP_LEVEL, rootNode, null, this.context.getCoreLibrary().getMainObject());
                        deferredCall.callWithoutCallNode();
                    }
                }
                catch (IOException e) {
                    throw new JavaException(e);
                }
                Main.printTruffleTimeMetric((String)"after-post-boot");
            }
            catch (RaiseException e) {
                DynamicObject rubyException = e.getException();
                BacktraceFormatter.createDefaultFormatter(this.getContext()).printBacktrace(this.context, rubyException, Layouts.EXCEPTION.getBacktrace(rubyException));
                throw new TruffleFatalException("couldn't load the post-boot code", e);
            }
        }
    }

    public void initializeEncodingConstants() {
        this.getContext().getJRubyRuntime().getEncodingService().defineEncodings(new EncodingService.EncodingDefinitionVisitor(){

            public void defineEncoding(EncodingDB.Entry encodingEntry, byte[] name, int p, int end) {
                CoreLibrary.this.context.getEncodingManager().defineEncoding(encodingEntry, name, p, end);
            }

            public void defineConstant(int encodingListIndex, String constName) {
                DynamicObject rubyEncoding = CoreLibrary.this.context.getEncodingManager().getRubyEncoding(encodingListIndex);
                Layouts.MODULE.getFields(CoreLibrary.this.encodingClass).setConstant(CoreLibrary.this.context, CoreLibrary.this.node, constName, rubyEncoding);
            }
        });
        this.getContext().getJRubyRuntime().getEncodingService().defineAliases(new EncodingService.EncodingAliasVisitor(){

            public void defineAlias(int encodingListIndex, String constName) {
                CoreLibrary.this.context.getEncodingManager().defineAlias(encodingListIndex, constName);
            }

            public void defineConstant(int encodingListIndex, String constName) {
                DynamicObject rubyEncoding = CoreLibrary.this.context.getEncodingManager().getRubyEncoding(encodingListIndex);
                Layouts.MODULE.getFields(CoreLibrary.this.encodingClass).setConstant(CoreLibrary.this.context, CoreLibrary.this.node, constName, rubyEncoding);
            }
        });
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject getMetaClass(Object object) {
        if (object instanceof DynamicObject) {
            return Layouts.BASIC_OBJECT.getMetaClass((DynamicObject)object);
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return this.trueClass;
            }
            return this.falseClass;
        }
        if (object instanceof Byte) {
            return this.fixnumClass;
        }
        if (object instanceof Short) {
            return this.fixnumClass;
        }
        if (object instanceof Integer) {
            return this.fixnumClass;
        }
        if (object instanceof Long) {
            return this.fixnumClass;
        }
        if (object instanceof Float) {
            return this.floatClass;
        }
        if (object instanceof Double) {
            return this.floatClass;
        }
        if (object == null) {
            throw new RuntimeException("Can't get metaclass for null");
        }
        throw new UnsupportedOperationException(StringUtils.format("Don't know how to get the metaclass for %s", object.getClass()));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject getLogicalClass(Object object) {
        if (object instanceof DynamicObject) {
            return Layouts.BASIC_OBJECT.getLogicalClass((DynamicObject)object);
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return this.trueClass;
            }
            return this.falseClass;
        }
        if (object instanceof Byte) {
            return this.fixnumClass;
        }
        if (object instanceof Short) {
            return this.fixnumClass;
        }
        if (object instanceof Integer) {
            return this.fixnumClass;
        }
        if (object instanceof Long) {
            return this.fixnumClass;
        }
        if (object instanceof Float) {
            return this.floatClass;
        }
        if (object instanceof Double) {
            return this.floatClass;
        }
        if (object == null) {
            throw new RuntimeException();
        }
        throw new UnsupportedOperationException(StringUtils.format("Don't know how to get the logical class for %s", object.getClass()));
    }

    public static double toDouble(Object value, DynamicObject nil) {
        assert (value != null);
        if (value == nil) {
            return 0.0;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).longValue();
        }
        if (RubyGuards.isRubyBignum(value)) {
            return Layouts.BIGNUM.getValue((DynamicObject)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnsupportedOperationException();
    }

    public static boolean fitsIntoInteger(long value) {
        return (long)((int)value) == value;
    }

    public static int long2int(long value) {
        assert (CoreLibrary.fitsIntoInteger(value));
        return (int)value;
    }

    public RubyContext getContext() {
        return this.context;
    }

    public String getCoreLoadPath() {
        return this.coreLoadPath;
    }

    public DynamicObject getArrayClass() {
        return this.arrayClass;
    }

    public DynamicObject getBasicObjectClass() {
        return this.basicObjectClass;
    }

    public DynamicObject getBigDecimalClass() {
        return this.bigDecimalClass;
    }

    public DynamicObjectFactory getBindingFactory() {
        return this.bindingFactory;
    }

    public DynamicObject getClassClass() {
        return this.classClass;
    }

    public DynamicObject getFalseClass() {
        return this.falseClass;
    }

    public DynamicObjectFactory getFiberFactory() {
        return this.fiberFactory;
    }

    public DynamicObject getFixnumClass() {
        return this.fixnumClass;
    }

    public DynamicObject getFloatClass() {
        return this.floatClass;
    }

    public DynamicObject getStandardErrorClass() {
        return this.standardErrorClass;
    }

    public DynamicObject getLoadErrorClass() {
        return this.loadErrorClass;
    }

    public DynamicObject getMatchDataClass() {
        return this.matchDataClass;
    }

    public DynamicObjectFactory getMatchDataFactory() {
        return this.matchDataFactory;
    }

    public DynamicObject getModuleClass() {
        return this.moduleClass;
    }

    public DynamicObject getNameErrorClass() {
        return this.nameErrorClass;
    }

    public DynamicObjectFactory getNameErrorFactory() {
        return this.nameErrorFactory;
    }

    public DynamicObject getNilClass() {
        return this.nilClass;
    }

    public DynamicObject getNoMethodErrorClass() {
        return this.noMethodErrorClass;
    }

    public DynamicObjectFactory getNoMethodErrorFactory() {
        return this.noMethodErrorFactory;
    }

    public DynamicObject getObjectClass() {
        return this.objectClass;
    }

    public DynamicObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public DynamicObject getProcClass() {
        return this.procClass;
    }

    public DynamicObject getRangeClass() {
        return this.rangeClass;
    }

    public DynamicObject getRationalClass() {
        return this.rationalClass;
    }

    public DynamicObject getRegexpClass() {
        return this.regexpClass;
    }

    public DynamicObjectFactory getRegexpFactory() {
        return this.regexpFactory;
    }

    public DynamicObject getRubyTruffleErrorClass() {
        return this.rubyTruffleErrorClass;
    }

    public DynamicObject getStringClass() {
        return this.stringClass;
    }

    public DynamicObject getThreadClass() {
        return this.threadClass;
    }

    public DynamicObjectFactory getThreadFactory() {
        return this.threadFactory;
    }

    public DynamicObject getTypeErrorClass() {
        return this.typeErrorClass;
    }

    public DynamicObject getTrueClass() {
        return this.trueClass;
    }

    public DynamicObject getZeroDivisionErrorClass() {
        return this.zeroDivisionErrorClass;
    }

    public DynamicObject getKernelModule() {
        return this.kernelModule;
    }

    public GlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    public DynamicObject getLoadPath() {
        return (DynamicObject)this.loadPathStorage.getValue();
    }

    public DynamicObject getLoadedFeatures() {
        return (DynamicObject)this.loadedFeaturesStorage.getValue();
    }

    public DynamicObject getMainObject() {
        return this.mainObject;
    }

    public DynamicObject getNilObject() {
        return this.nilObject;
    }

    public DynamicObject getENV() {
        return (DynamicObject)Layouts.MODULE.getFields(this.objectClass).getConstant("ENV").getValue();
    }

    public ArrayNodes.MinBlock getArrayMinBlock() {
        return this.arrayMinBlock;
    }

    public ArrayNodes.MaxBlock getArrayMaxBlock() {
        return this.arrayMaxBlock;
    }

    public DynamicObject getNumericClass() {
        return this.numericClass;
    }

    public DynamicObjectFactory getUnboundMethodFactory() {
        return this.unboundMethodFactory;
    }

    public DynamicObjectFactory getMethodFactory() {
        return this.methodFactory;
    }

    public DynamicObject getComplexClass() {
        return this.complexClass;
    }

    public DynamicObjectFactory getByteArrayFactory() {
        return this.byteArrayFactory;
    }

    public DynamicObjectFactory getStatFactory() {
        return this.statFactory;
    }

    public DynamicObject getLookupTableClass() {
        return this.lookupTableClass;
    }

    public DynamicObject getTranscodingClass() {
        return this.transcodingClass;
    }

    public DynamicObject getRubiniusFFIPointerClass() {
        return this.rubiniusFFIPointerClass;
    }

    public DynamicObject getRubiniusUndefined() {
        return this.rubiniusUndefined;
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject getErrnoClass(Errno errno) {
        return this.errnoClasses.get(errno);
    }

    public DynamicObject getSymbolClass() {
        return this.symbolClass;
    }

    public DynamicObjectFactory getSymbolFactory() {
        return this.symbolFactory;
    }

    public DynamicObject getThreadBacktraceLocationClass() {
        return this.threadBacktraceLocationClass;
    }

    public DynamicObjectFactory getThreadBacktraceLocationFactory() {
        return this.threadBacktraceLocationFactory;
    }

    public DynamicObject getInternalBufferClass() {
        return this.internalBufferClass;
    }

    public boolean isInitializing() {
        return this.state == State.INITIALIZING;
    }

    public boolean isLoadingRubyCore() {
        return this.state == State.LOADING_RUBY_CORE;
    }

    public boolean isLoaded() {
        return this.state == State.LOADED;
    }

    public boolean isSend(InternalMethod method) {
        return method.getCallTarget() == this.basicObjectSendMethod.getCallTarget();
    }

    public DynamicObjectFactory getIntRangeFactory() {
        return this.intRangeFactory;
    }

    public DynamicObjectFactory getLongRangeFactory() {
        return this.longRangeFactory;
    }

    public DynamicObject getDigestClass() {
        return this.digestClass;
    }

    public DynamicObjectFactory getDigestFactory() {
        return this.digestFactory;
    }

    public DynamicObjectFactory getArrayFactory() {
        return this.arrayFactory;
    }

    public DynamicObjectFactory getBignumFactory() {
        return this.bignumFactory;
    }

    public DynamicObjectFactory getProcFactory() {
        return this.procFactory;
    }

    public DynamicObjectFactory getStringFactory() {
        return this.stringFactory;
    }

    public DynamicObjectFactory getHashFactory() {
        return this.hashFactory;
    }

    public DynamicObjectFactory getWeakRefFactory() {
        return this.weakRefFactory;
    }

    public Object getObjectSpaceModule() {
        return this.objectSpaceModule;
    }

    public DynamicObjectFactory getRandomizerFactory() {
        return this.randomizerFactory;
    }

    public DynamicObjectFactory getTimeFactory() {
        return this.timeFactory;
    }

    public DynamicObject getSystemExitClass() {
        return this.systemExitClass;
    }

    public DynamicObjectFactory getHandleFactory() {
        return this.handleFactory;
    }

    public DynamicObject getRuntimeErrorClass() {
        return this.runtimeErrorClass;
    }

    public DynamicObject getSystemStackErrorClass() {
        return this.systemStackErrorClass;
    }

    public DynamicObject getArgumentErrorClass() {
        return this.argumentErrorClass;
    }

    public DynamicObject getIndexErrorClass() {
        return this.indexErrorClass;
    }

    public DynamicObject getLocalJumpErrorClass() {
        return this.localJumpErrorClass;
    }

    public DynamicObject getNotImplementedErrorClass() {
        return this.notImplementedErrorClass;
    }

    public DynamicObject getSyntaxErrorClass() {
        return this.syntaxErrorClass;
    }

    public DynamicObject getFloatDomainErrorClass() {
        return this.floatDomainErrorClass;
    }

    public DynamicObject getIOErrorClass() {
        return this.ioErrorClass;
    }

    public DynamicObject getRangeErrorClass() {
        return this.rangeErrorClass;
    }

    public DynamicObject getRegexpErrorClass() {
        return this.regexpErrorClass;
    }

    public DynamicObjectFactory getEncodingFactory() {
        return this.encodingFactory;
    }

    public DynamicObject getEncodingCompatibilityErrorClass() {
        return this.encodingCompatibilityErrorClass;
    }

    public DynamicObject getFiberErrorClass() {
        return this.fiberErrorClass;
    }

    public DynamicObject getThreadErrorClass() {
        return this.threadErrorClass;
    }

    public DynamicObject getSecurityErrorClass() {
        return this.securityErrorClass;
    }

    public DynamicObject getSystemCallErrorClass() {
        return this.systemCallErrorClass;
    }

    public DynamicObject getEagainWaitReadable() {
        return this.eagainWaitReadable;
    }

    public DynamicObject getEagainWaitWritable() {
        return this.eagainWaitWritable;
    }

    public DynamicObject getTruffleModule() {
        return this.truffleModule;
    }

    private static class CoreLibraryNode
    extends RubyNode {
        @Node.Child
        SingletonClassNode singletonClassNode;
        @Node.Child
        FreezeNode freezeNode;

        public CoreLibraryNode(RubyContext context) {
            super(context, null);
            this.singletonClassNode = SingletonClassNodeGen.create(context, null, null);
            this.freezeNode = FreezeNodeGen.create(context, null, null);
            this.adoptChildren();
        }

        public SingletonClassNode getSingletonClassNode() {
            return this.singletonClassNode;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.nil();
        }
    }

    private static enum State {
        INITIALIZING,
        LOADING_RUBY_CORE,
        LOADED;

    }
}

