/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.globals.ReadThreadLocalGlobalVariableNode;

public class ReadMatchReferenceNode
extends RubyNode {
    public static final int PRE = -1;
    public static final int POST = -2;
    public static final int GLOBAL = -3;
    public static final int HIGHEST = -4;
    private final int index;
    @Node.Child
    private ReadThreadLocalGlobalVariableNode readMatchNode;
    private final ConditionProfile matchNilProfile = ConditionProfile.createBinaryProfile();

    public ReadMatchReferenceNode(RubyContext context, SourceSection sourceSection, int index) {
        super(context, sourceSection);
        this.index = index;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object match = this.getReadMatchNode().execute(frame);
        if (this.matchNilProfile.profile(match == this.nil())) {
            return this.nil();
        }
        DynamicObject matchData = (DynamicObject)match;
        switch (this.index) {
            case -1: {
                return Layouts.MATCH_DATA.getPre(matchData);
            }
            case -2: {
                return Layouts.MATCH_DATA.getPost(matchData);
            }
            case -3: {
                return Layouts.MATCH_DATA.getGlobal(matchData);
            }
            case -4: {
                Object[] values = Layouts.MATCH_DATA.getValues(matchData);
                for (int n = values.length - 1; n >= 0; --n) {
                    if (values[n] == this.nil()) continue;
                    return values[n];
                }
                return this.nil();
            }
        }
        Object[] values = Layouts.MATCH_DATA.getValues(matchData);
        if (this.index >= values.length) {
            return this.nil();
        }
        return values[this.index];
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        if (this.isNil(this.execute(frame))) {
            return this.nil();
        }
        return this.coreStrings().GLOBAL_VARIABLE.createInstance();
    }

    private ReadThreadLocalGlobalVariableNode getReadMatchNode() {
        if (this.readMatchNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.readMatchNode = this.insert(new ReadThreadLocalGlobalVariableNode(this.getContext(), this.getSourceSection(), "$~", true));
        }
        return this.readMatchNode;
    }
}

