/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;

public class WeakPropertyChangeListener
implements PropertyChangeListener {
    private WeakReference<PropertyChangeListener> weakRef;

    public WeakPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.weakRef = new WeakReference<PropertyChangeListener>(propertyChangeListener);
    }

    protected void removeFromSource(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        try {
            object.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class).invoke(object, this);
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Could not remove WeakPropertyChangeListener from " + object + ".");
            internalError.initCause(exception);
            throw internalError;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.weakRef.get();
        if (propertyChangeListener == null) {
            this.removeFromSource(propertyChangeEvent);
            return;
        }
        propertyChangeListener.propertyChange(propertyChangeEvent);
    }

    public PropertyChangeListener getTarget() {
        return (PropertyChangeListener)this.weakRef.get();
    }

    public String toString() {
        return super.toString() + "[" + this.weakRef.get() + "]";
    }
}

