/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.openide.filesystems.FileObject;

public final class PhpClass
extends PhpBaseElement {
    private final Collection<Field> fields = new LinkedList<Field>();
    private final Collection<Method> methods = new LinkedList<Method>();

    public PhpClass(@NonNull String name, @NullAllowed String fullyQualifiedName, @NullAllowed String description) {
        super(name, fullyQualifiedName, description);
    }

    public PhpClass(@NonNull String name, @NullAllowed String fullyQualifiedName) {
        super(name, fullyQualifiedName);
    }

    public PhpClass(@NonNull String name, @NullAllowed String fullyQualifiedName, int offset) {
        this(name, fullyQualifiedName, offset, null);
    }

    public PhpClass(@NonNull String name, @NullAllowed String fullyQualifiedName, int offset, @NullAllowed String description) {
        super(name, fullyQualifiedName, offset, description);
    }

    public PhpClass addField(@NonNull String name, @NullAllowed String fullyQualifiedName, int offset, @NullAllowed String description) {
        this.fields.add(new Field(name, fullyQualifiedName, offset, description));
        return this;
    }

    public PhpClass addField(@NonNull String name, @NullAllowed String fullyQualifiedName, int offset) {
        return this.addField(name, fullyQualifiedName, offset, null);
    }

    public PhpClass addField(@NonNull String name, @NullAllowed String fullyQualifiedName) {
        return this.addField(name, fullyQualifiedName, -1, null);
    }

    public PhpClass addField(@NonNull String name, @NullAllowed String fullyQualifiedName, @NullAllowed String description) {
        return this.addField(name, fullyQualifiedName, -1, description);
    }

    public PhpClass addField(@NonNull String name, @NullAllowed PhpClass type, @NullAllowed FileObject file, int offset) {
        this.fields.add(new Field(name, type, file, offset));
        return this;
    }

    public PhpClass addMethod(@NonNull String name, @NullAllowed String fullyQualifiedName, int offset, @NullAllowed String description) {
        this.methods.add(new Method(name, fullyQualifiedName, offset, description));
        return this;
    }

    public PhpClass addMethod(@NonNull String name, @NullAllowed String fullyQualifiedName, int offset) {
        return this.addMethod(name, fullyQualifiedName, offset, null);
    }

    public PhpClass addMethod(@NonNull String name, @NullAllowed String fullyQualifiedName) {
        return this.addMethod(name, fullyQualifiedName, -1, null);
    }

    public PhpClass addMethod(@NonNull String name, @NullAllowed String fullyQualifiedName, @NullAllowed String description) {
        return this.addMethod(name, fullyQualifiedName, -1, description);
    }

    public Collection<Field> getFields() {
        return new ArrayList<Field>(this.fields);
    }

    public Collection<Method> getMethods() {
        return new ArrayList<Method>(this.methods);
    }

    public final class Method
    extends PhpBaseElement {
        Method(@NullAllowed String name, String fullyQualifiedName, @NullAllowed int offset, String description) {
            super(name, fullyQualifiedName, offset, description);
        }

        public PhpClass getPhpClass() {
            return PhpClass.this;
        }
    }

    public final class Field
    extends PhpBaseElement {
        Field(@NullAllowed String name, String fullyQualifiedName, @NullAllowed int offset, String description) {
            super(name, fullyQualifiedName, offset, description);
        }

        Field(@NullAllowed String name, @NullAllowed PhpClass type, FileObject file, int offset) {
            super(name, null, type, file, offset, null);
        }

        public PhpClass getPhpClass() {
            return PhpClass.this;
        }
    }
}

