/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.BaseNode;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BreakNode;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.ContinueNode;
import jdk.nashorn.internal.ir.DoWhileNode;
import jdk.nashorn.internal.ir.EmptyNode;
import jdk.nashorn.internal.ir.ExecuteNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IfNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.LabelNode;
import jdk.nashorn.internal.ir.LabeledNode;
import jdk.nashorn.internal.ir.LineNumberNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.ThrowNode;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.WithNode;
import jdk.nashorn.internal.ir.visitor.NodeOperatorVisitor;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Source;

final class Lower
extends NodeOperatorVisitor {
    private final Compiler compiler;
    private final Source source;
    private final Deque<Node> nesting;
    private static final DebugLogger LOG = new DebugLogger("lower");
    private Node lastStatement;
    private List<Node> statements;

    Lower(Compiler compiler) {
        this.compiler = compiler;
        this.source = compiler.getSource();
        this.nesting = new ArrayDeque<Node>();
        this.statements = new ArrayList<Node>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node enter(Block block) {
        Node savedLastStatement = this.lastStatement;
        List<Node> savedStatements = this.statements;
        try {
            this.statements = new ArrayList<Node>();
            for (Node statement : block.getStatements()) {
                statement.accept(this);
                if (this.lastStatement == null || !this.lastStatement.isTerminal()) continue;
                Lower.copyTerminal(block, this.lastStatement);
                break;
            }
            block.setStatements(this.statements);
        }
        finally {
            this.statements = savedStatements;
            this.lastStatement = savedLastStatement;
        }
        return null;
    }

    @Override
    public Node enter(BreakNode breakNode) {
        return this.enterBreakOrContinue(breakNode);
    }

    @Override
    public Node enter(CallNode callNode) {
        Node function = Lower.markerFunction(callNode.getFunction());
        callNode.setFunction(function);
        this.checkEval(callNode);
        return callNode;
    }

    @Override
    public Node leave(CaseNode caseNode) {
        caseNode.copyTerminalFlags(caseNode.getBody());
        return caseNode;
    }

    @Override
    public Node leave(CatchNode catchNode) {
        catchNode.copyTerminalFlags(catchNode.getBody());
        this.addStatement(catchNode);
        return catchNode;
    }

    @Override
    public Node enter(ContinueNode continueNode) {
        return this.enterBreakOrContinue(continueNode);
    }

    @Override
    public Node enter(DoWhileNode doWhileNode) {
        return this.enter((WhileNode)doWhileNode);
    }

    @Override
    public Node leave(DoWhileNode doWhileNode) {
        return this.leave((WhileNode)doWhileNode);
    }

    @Override
    public Node enter(EmptyNode emptyNode) {
        return null;
    }

    @Override
    public Node leave(ExecuteNode executeNode) {
        Node expr = executeNode.getExpression();
        if (this.getCurrentFunctionNode().isScript() && !(expr instanceof Block) && !Lower.isInternalExpression(expr) && !this.isEvalResultAssignment(expr)) {
            executeNode.setExpression(new BinaryNode(this.source, Token.recast(executeNode.getToken(), TokenType.ASSIGN), this.getCurrentFunctionNode().getResultNode(), expr));
        }
        Lower.copyTerminal(executeNode, executeNode.getExpression());
        this.addStatement(executeNode);
        return executeNode;
    }

    @Override
    public Node enter(ForNode forNode) {
        this.nest(forNode);
        return forNode;
    }

    @Override
    public Node leave(ForNode forNode) {
        boolean escapes;
        Node test = forNode.getTest();
        Block body = forNode.getBody();
        if (!forNode.isForIn() && test == null) {
            Lower.setHasGoto(forNode);
        }
        if (escapes = this.controlFlowEscapes(body)) {
            Lower.setTerminal(body, false);
        }
        this.unnest(forNode);
        if (!forNode.isForIn() && Lower.conservativeAlwaysTrue(test)) {
            forNode.setTest(null);
            Lower.setTerminal(forNode, !escapes);
        }
        this.addStatement(forNode);
        return forNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node enter(FunctionNode functionNode) {
        LOG.info("START FunctionNode: " + functionNode.getName());
        this.initFunctionNode(functionNode);
        Node initialEvalResult = LiteralNode.newInstance((Node)functionNode, ScriptRuntime.UNDEFINED);
        this.nest(functionNode);
        List<Node> savedStatements = this.statements;
        Node savedLastStatement = this.lastStatement;
        this.statements = new ArrayList<Node>();
        this.lastStatement = null;
        for (FunctionNode nestedFunction : functionNode.getFunctions()) {
            IdentNode ident = nestedFunction.getIdent();
            if (ident == null || !nestedFunction.isStatement()) continue;
            initialEvalResult = new IdentNode(ident);
        }
        if (functionNode.needsSelfSymbol()) {
            this.statements.add(functionNode.getSelfSymbolInit().accept(this));
        }
        try {
            for (FunctionNode nestedFunction : functionNode.getFunctions()) {
                VarNode varNode = nestedFunction.getFunctionVarNode();
                if (varNode == null) continue;
                LineNumberNode lineNumberNode = nestedFunction.getFunctionVarLineNumberNode();
                if (lineNumberNode != null) {
                    lineNumberNode.accept(this);
                }
                varNode.accept(this);
                varNode.setIsFunctionVarNode();
            }
            if (functionNode.isScript()) {
                new ExecuteNode(this.source, functionNode.getFirstToken(), functionNode.getFinish(), initialEvalResult).accept(this);
            }
            for (Node statement : functionNode.getStatements()) {
                statement.accept(this);
                LOG.info("Checking lastStatement=" + this.lastStatement + " for terminal flags");
                if (this.lastStatement == null || !this.lastStatement.hasTerminalFlags()) continue;
                Lower.copyTerminal(functionNode, this.lastStatement);
                break;
            }
            functionNode.setStatements(this.statements);
            if (!functionNode.isTerminal()) {
                this.guaranteeReturn(functionNode);
            }
            for (FunctionNode nestedFunction : functionNode.getFunctions()) {
                nestedFunction.accept(this);
            }
        }
        finally {
            this.statements = savedStatements;
            this.lastStatement = savedLastStatement;
        }
        LOG.info("END FunctionNode: " + functionNode.getName());
        this.unnest(functionNode);
        return null;
    }

    @Override
    public Node enter(IfNode ifNode) {
        return this.nest(ifNode);
    }

    @Override
    public Node leave(IfNode ifNode) {
        Block pass = ifNode.getPass();
        Block fail = ifNode.getFail();
        if (pass.isTerminal() && fail != null && fail.isTerminal()) {
            Lower.setTerminal(ifNode, true);
        }
        this.addStatement(ifNode);
        this.unnest(ifNode);
        return ifNode;
    }

    @Override
    public Node enter(LabelNode labelNode) {
        Block body = labelNode.getBody();
        body.accept(this);
        Lower.copyTerminal(labelNode, body);
        this.addStatement(labelNode);
        return null;
    }

    @Override
    public Node enter(LineNumberNode lineNumberNode) {
        this.addStatement(lineNumberNode, false);
        return null;
    }

    @Override
    public Node enter(ReturnNode returnNode) {
        TryNode tryNode = returnNode.getTryChain();
        Node expr = returnNode.getExpression();
        if (tryNode != null) {
            if (expr != null) {
                long token = returnNode.getToken();
                IdentNode resultNode = new IdentNode(this.getCurrentFunctionNode().getResultNode());
                BinaryNode assignResult = new BinaryNode(this.source, Token.recast(token, TokenType.ASSIGN), resultNode, expr);
                new ExecuteNode(this.source, token, Token.descPosition(token), assignResult).accept(this);
                if (this.copyFinally(tryNode, null)) {
                    return null;
                }
                returnNode.setExpression(resultNode);
            } else if (this.copyFinally(tryNode, null)) {
                return null;
            }
        } else if (expr != null) {
            returnNode.setExpression(expr.accept(this));
        }
        this.addStatement(returnNode);
        return null;
    }

    @Override
    public Node leave(ReturnNode returnNode) {
        this.addStatement(returnNode);
        return returnNode;
    }

    @Override
    public Node enter(SwitchNode switchNode) {
        this.nest(switchNode);
        return switchNode;
    }

    @Override
    public Node leave(SwitchNode switchNode) {
        this.unnest(switchNode);
        List<CaseNode> cases = switchNode.getCases();
        CaseNode defaultCase = switchNode.getDefaultCase();
        boolean allTerminal = !cases.isEmpty();
        for (CaseNode caseNode : switchNode.getCases()) {
            allTerminal &= caseNode.isTerminal();
        }
        if (allTerminal && defaultCase != null && defaultCase.isTerminal()) {
            Lower.setTerminal(switchNode, true);
        }
        this.addStatement(switchNode);
        return switchNode;
    }

    @Override
    public Node leave(ThrowNode throwNode) {
        this.addStatement(throwNode);
        return throwNode;
    }

    @Override
    public Node enter(TryNode tryNode) {
        Block finallyBody = tryNode.getFinallyBody();
        long token = tryNode.getToken();
        int finish = tryNode.getFinish();
        this.nest(tryNode);
        if (finallyBody == null) {
            return tryNode;
        }
        if (!tryNode.getCatchBlocks().isEmpty()) {
            TryNode innerTryNode = new TryNode(this.source, token, finish, tryNode.getNext());
            innerTryNode.setBody(tryNode.getBody());
            innerTryNode.setCatchBlocks(tryNode.getCatchBlocks());
            Block outerBody = new Block(this.source, token, finish, tryNode.getBody().getParent(), this.getCurrentFunctionNode());
            outerBody.setStatements(new ArrayList<Node>(Arrays.asList(innerTryNode)));
            tryNode.setBody(outerBody);
            tryNode.setCatchBlocks(null);
            innerTryNode.getBody().setParent(tryNode.getBody());
            for (Block block : innerTryNode.getCatchBlocks()) {
                block.setParent(tryNode.getBody());
            }
        }
        Block catchBlock = new Block(this.source, token, finish, this.getCurrentBlock(), this.getCurrentFunctionNode());
        Block catchBody = new Block(this.source, token, finish, catchBlock, this.getCurrentFunctionNode());
        Node catchAllFinally = finallyBody.clone();
        catchBody.addStatement(new ExecuteNode(this.source, finallyBody.getToken(), finallyBody.getFinish(), catchAllFinally));
        Lower.setTerminal(catchBody, true);
        IdentNode exception = new IdentNode(this.source, token, finish, this.compiler.uniqueName("catch_all"));
        CatchNode catchAllNode = new CatchNode(this.source, token, finish, new IdentNode(exception), null, catchBody);
        catchAllNode.setIsSyntheticRethrow();
        catchBlock.addStatement(catchAllNode);
        tryNode.setCatchBlocks(new ArrayList<Block>(Arrays.asList(catchBlock)));
        return tryNode;
    }

    @Override
    public Node leave(TryNode tryNode) {
        Block finallyBody = tryNode.getFinallyBody();
        boolean allTerminal = tryNode.getBody().isTerminal() && (finallyBody == null || finallyBody.isTerminal());
        for (Block catchBlock : tryNode.getCatchBlocks()) {
            allTerminal &= catchBlock.isTerminal();
        }
        tryNode.setIsTerminal(allTerminal);
        this.addStatement(tryNode);
        this.unnest(tryNode);
        if (finallyBody != null) {
            tryNode.setFinallyBody(null);
            this.addStatement(finallyBody);
        }
        return tryNode;
    }

    @Override
    public Node leave(VarNode varNode) {
        this.addStatement(varNode);
        return varNode;
    }

    @Override
    public Node enter(WhileNode whileNode) {
        return this.nest(whileNode);
    }

    @Override
    public Node leave(WhileNode whileNode) {
        Block body;
        boolean escapes;
        Node test = whileNode.getTest();
        if (test == null) {
            Lower.setHasGoto(whileNode);
        }
        if (escapes = this.controlFlowEscapes(body = whileNode.getBody())) {
            Lower.setTerminal(body, false);
        }
        WhileNode node = whileNode;
        if (body.isTerminal()) {
            if (whileNode instanceof DoWhileNode) {
                Lower.setTerminal(whileNode, true);
            } else if (Lower.conservativeAlwaysTrue(test)) {
                node = new ForNode(this.source, whileNode.getToken(), whileNode.getFinish());
                ((ForNode)node).setBody(body);
                ((ForNode)node).accept(this);
                Lower.setTerminal(node, !escapes);
            }
        }
        this.unnest(whileNode);
        this.addStatement(node);
        return node;
    }

    @Override
    public Node leave(WithNode withNode) {
        if (withNode.getBody().isTerminal()) {
            Lower.setTerminal(withNode, true);
        }
        this.addStatement(withNode);
        return withNode;
    }

    @Override
    public Node leaveDELETE(UnaryNode unaryNode) {
        Node rhs = unaryNode.rhs();
        if (rhs instanceof IdentNode || rhs instanceof BaseNode) {
            return unaryNode;
        }
        this.addStatement(new ExecuteNode(rhs));
        return LiteralNode.newInstance((Node)unaryNode, true);
    }

    private static Node markerFunction(Node function) {
        if (function instanceof IdentNode) {
            return new IdentNode((IdentNode)function){

                @Override
                public boolean isFunction() {
                    return true;
                }
            };
        }
        if (function instanceof AccessNode) {
            return new AccessNode((AccessNode)function){

                @Override
                public boolean isFunction() {
                    return true;
                }
            };
        }
        if (function instanceof IndexNode) {
            return new IndexNode((IndexNode)function){

                @Override
                public boolean isFunction() {
                    return true;
                }
            };
        }
        return function;
    }

    private static String evalLocation(IdentNode node) {
        return node.getSource().getName() + '#' + node.getSource().getLine(node.position()) + "<eval>";
    }

    private void checkEval(CallNode callNode) {
        if (callNode.getFunction() instanceof IdentNode) {
            List<Node> args = callNode.getArgs();
            IdentNode callee = (IdentNode)callNode.getFunction();
            if (args.size() >= 1 && CompilerConstants.EVAL.tag().equals(callee.getName())) {
                CallNode.EvalArgs evalArgs = new CallNode.EvalArgs(args.get(0).clone().accept(this), this.getCurrentFunctionNode().getThisNode(), Lower.evalLocation(callee), this.getCurrentFunctionNode().isStrictMode());
                callNode.setEvalArgs(evalArgs);
            }
        }
    }

    private static boolean conservativeAlwaysTrue(Node node) {
        return node == null || node instanceof LiteralNode && Boolean.TRUE.equals(((LiteralNode)node).getValue());
    }

    private boolean controlFlowEscapes(Node loopBody) {
        final ArrayList escapes = new ArrayList();
        loopBody.accept(new NodeVisitor(){

            @Override
            public Node leave(BreakNode node) {
                escapes.add(node);
                return node;
            }

            @Override
            public Node leave(ContinueNode node) {
                if (Lower.this.nesting.contains(node.getTargetNode())) {
                    escapes.add(node);
                }
                return node;
            }
        });
        return !escapes.isEmpty();
    }

    private void guaranteeReturn(FunctionNode functionNode) {
        Node resultNode;
        if (functionNode.isScript()) {
            resultNode = functionNode.getResultNode();
        } else {
            if (this.lastStatement != null && this.lastStatement.isTerminal() || this.lastStatement instanceof ReturnNode) {
                return;
            }
            resultNode = LiteralNode.newInstance((Node)functionNode, ScriptRuntime.UNDEFINED);
        }
        ReturnNode returnNode = new ReturnNode(this.source, functionNode.getLastToken(), functionNode.getFinish(), resultNode, null);
        ((Node)returnNode).accept(this);
    }

    private Node nest(Node node) {
        LOG.info("Nesting: " + node);
        LOG.indent();
        this.nesting.push(node);
        return node;
    }

    private void unnest(Node node) {
        LOG.unindent();
        assert (this.nesting.getFirst() == node) : "inconsistent nesting order : " + this.nesting.getFirst() + " != " + node;
        LOG.info("Unnesting: " + this.nesting);
        this.nesting.pop();
    }

    private static void setTerminal(Node node, boolean isTerminal) {
        LOG.info("terminal = " + isTerminal + " for " + node);
        node.setIsTerminal(isTerminal);
    }

    private static void setHasGoto(Node node) {
        LOG.info("hasGoto = true for " + node);
        node.setHasGoto();
    }

    private static void copyTerminal(Node node, Node sourceNode) {
        LOG.info("copy terminal flags " + sourceNode + " -> " + node);
        node.copyTerminalFlags(sourceNode);
    }

    private void addStatement(Node statement, boolean storeInLastStatement) {
        LOG.info("add statement = " + statement + " (lastStatement = " + this.lastStatement + ")");
        this.statements.add(statement);
        if (storeInLastStatement) {
            this.lastStatement = statement;
        }
    }

    private void addStatement(Node statement) {
        this.addStatement(statement, true);
    }

    private boolean isNestedTry(TryNode tryNode, Block target) {
        for (Block current = this.getCurrentBlock(); current != target; current = current.getParent()) {
            if (tryNode.getBody() == current) {
                return true;
            }
            for (Block catchBlock : tryNode.getCatchBlocks()) {
                if (catchBlock != current) continue;
                return true;
            }
        }
        return false;
    }

    private boolean copyFinally(TryNode node, Node targetNode) {
        Block target = null;
        if (targetNode instanceof Block) {
            target = (Block)targetNode;
        }
        for (TryNode tryNode = node; tryNode != null; tryNode = tryNode.getNext()) {
            if (target != null && !this.isNestedTry(tryNode, target)) {
                return false;
            }
            Block finallyBody = tryNode.getFinallyBody();
            if (finallyBody == null) continue;
            finallyBody = (Block)finallyBody.clone();
            boolean hasTerminalFlags = finallyBody.hasTerminalFlags();
            new ExecuteNode(this.source, finallyBody.getToken(), finallyBody.getFinish(), finallyBody).accept(this);
            if (!hasTerminalFlags) continue;
            this.getCurrentBlock().copyTerminalFlags(finallyBody);
            return true;
        }
        return false;
    }

    private Node enterBreakOrContinue(LabeledNode labeledNode) {
        TryNode tryNode = labeledNode.getTryChain();
        if (tryNode != null && this.copyFinally(tryNode, labeledNode.getTargetNode())) {
            return null;
        }
        this.addStatement(labeledNode);
        return null;
    }

    private static boolean isInternalExpression(Node expression) {
        Symbol symbol = expression.getSymbol();
        return symbol != null && symbol.isInternal();
    }

    private boolean isEvalResultAssignment(Node expression) {
        Node e = expression;
        if (e.tokenType() == TokenType.DISCARD) {
            e = ((UnaryNode)expression).rhs();
        }
        IdentNode resultNode = this.getCurrentFunctionNode().getResultNode();
        return e instanceof BinaryNode && ((BinaryNode)e).lhs().equals(resultNode);
    }

    private void initFunctionNode(FunctionNode functionNode) {
        long token = functionNode.getToken();
        int finish = functionNode.getFinish();
        functionNode.setThisNode(new IdentNode(this.source, token, finish, CompilerConstants.THIS.tag()));
        functionNode.setScopeNode(new IdentNode(this.source, token, finish, CompilerConstants.SCOPE.tag()));
        functionNode.setResultNode(new IdentNode(this.source, token, finish, CompilerConstants.SCRIPT_RETURN.tag()));
        functionNode.setCalleeNode(new IdentNode(this.source, token, finish, CompilerConstants.CALLEE.tag()));
        if (functionNode.isVarArg()) {
            functionNode.setVarArgsNode(new IdentNode(this.source, token, finish, CompilerConstants.VARARGS.tag()));
            if (functionNode.needsArguments()) {
                functionNode.setArgumentsNode(new IdentNode(this.source, token, finish, CompilerConstants.ARGUMENTS.tag()));
            }
        }
    }
}

