/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import jdk.nashorn.internal.objects.ArrayBufferView;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArrayBuffer;
import jdk.nashorn.internal.objects.annotations.Constructor;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayData;

@ScriptClass(value="Float64Array")
public class NativeFloat64Array
extends ArrayBufferView {
    private static final int BYTES_PER_ELEMENT = 8;
    private static final ArrayBufferView.Factory FACTORY = new ArrayBufferView.Factory(8){

        @Override
        public ArrayBufferView construct(NativeArrayBuffer buffer, int byteOffset, int length) {
            return new NativeFloat64Array(buffer, byteOffset, length);
        }

        @Override
        public ArrayData createArrayData(NativeArrayBuffer buffer, int byteOffset, int length) {
            return new Float64ArrayData(buffer, byteOffset, length);
        }
    };

    @Constructor(arity=1)
    public static Object constructor(boolean newObj, Object self, Object ... args) {
        return NativeFloat64Array.constructorImpl(args, FACTORY);
    }

    NativeFloat64Array(NativeArrayBuffer buffer, int byteOffset, int length) {
        super(buffer, byteOffset, length);
    }

    @Override
    protected ArrayBufferView.Factory factory() {
        return FACTORY;
    }

    @Override
    protected boolean isFloatArray() {
        return true;
    }

    @Function(attributes=2)
    protected static Object set(Object self, Object array, Object offset) {
        return ArrayBufferView.setImpl(self, array, offset);
    }

    @Function(attributes=2)
    protected static Object subarray(Object self, Object begin, Object end) {
        return ArrayBufferView.subarrayImpl(self, begin, end);
    }

    @Override
    protected ScriptObject getPrototype() {
        return Global.instance().getFloat64ArrayPrototype();
    }

    private static final class Float64ArrayData
    extends ArrayBufferView.ArrayDataImpl {
        private Float64ArrayData(NativeArrayBuffer buffer, int byteOffset, int elementLength) {
            super(buffer, byteOffset, elementLength);
        }

        @Override
        protected int byteIndex(int index) {
            return index * 8 + this.byteOffset;
        }

        @Override
        protected double getDoubleImpl(int index) {
            int byteIndex = this.byteIndex(index);
            byte[] byteArray = this.buffer.getByteArray();
            long bits = (long)byteArray[byteIndex] & 0xFFL | (long)byteArray[byteIndex + 1] << 8 & 0xFF00L | (long)byteArray[byteIndex + 2] << 16 & 0xFF0000L | (long)byteArray[byteIndex + 3] << 24 & 0xFF000000L | (long)byteArray[byteIndex + 4] << 32 & 0xFF00000000L | (long)byteArray[byteIndex + 5] << 40 & 0xFF0000000000L | (long)byteArray[byteIndex + 6] << 48 & 0xFF000000000000L | (long)byteArray[byteIndex + 7] << 56 & 0xFF00000000000000L;
            return Double.longBitsToDouble(bits);
        }

        @Override
        protected int getIntImpl(int index) {
            return (int)this.getDoubleImpl(index);
        }

        @Override
        protected long getLongImpl(int key) {
            return (long)this.getDoubleImpl(key);
        }

        @Override
        protected Object getObjectImpl(int key) {
            return this.getDoubleImpl(key);
        }

        @Override
        protected void setImpl(int index, double value) {
            long bits = Double.doubleToRawLongBits(value);
            int byteIndex = this.byteIndex(index);
            byte[] byteArray = this.buffer.getByteArray();
            byteArray[byteIndex] = (byte)(bits & 0xFFL);
            byteArray[byteIndex + 1] = (byte)(bits >>> 8 & 0xFFL);
            byteArray[byteIndex + 2] = (byte)(bits >>> 16 & 0xFFL);
            byteArray[byteIndex + 3] = (byte)(bits >>> 24 & 0xFFL);
            byteArray[byteIndex + 4] = (byte)(bits >>> 32 & 0xFFL);
            byteArray[byteIndex + 5] = (byte)(bits >>> 40 & 0xFFL);
            byteArray[byteIndex + 6] = (byte)(bits >>> 48 & 0xFFL);
            byteArray[byteIndex + 7] = (byte)(bits >>> 56 & 0xFFL);
        }

        @Override
        protected void setImpl(int key, int value) {
            this.setImpl(key, (double)value);
        }

        @Override
        protected void setImpl(int key, long value) {
            this.setImpl(key, (double)value);
        }

        @Override
        protected void setImpl(int key, Object value) {
            this.setImpl(key, JSType.toNumber(value));
        }
    }
}

