/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.arrays;

import java.util.Iterator;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayIterator;
import jdk.nashorn.internal.runtime.arrays.EmptyArrayLikeIterator;
import jdk.nashorn.internal.runtime.arrays.MapIterator;
import jdk.nashorn.internal.runtime.arrays.ReverseArrayIterator;
import jdk.nashorn.internal.runtime.arrays.ReverseMapIterator;

public abstract class ArrayLikeIterator<T>
implements Iterator<T> {
    protected int index;
    protected final boolean includeUndefined;

    protected ArrayLikeIterator(boolean includeUndefined) {
        this.includeUndefined = includeUndefined;
        this.index = 0;
    }

    public boolean isReverse() {
        return false;
    }

    protected int bumpIndex() {
        return this.index++;
    }

    public int nextIndex() {
        return this.index;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public abstract int getLength();

    public static ArrayLikeIterator<Object> arrayLikeIterator(Object object) {
        return ArrayLikeIterator.arrayLikeIterator(object, false);
    }

    public static ArrayLikeIterator<Object> reverseArrayLikeIterator(Object object) {
        return ArrayLikeIterator.reverseArrayLikeIterator(object, false);
    }

    public static ArrayLikeIterator<Object> arrayLikeIterator(Object object, boolean includeUndefined) {
        Object obj = object;
        if (ScriptObject.isArray(obj)) {
            return new ArrayIterator((ScriptObject)obj, includeUndefined);
        }
        if ((obj = JSType.toScriptObject(obj)) instanceof ScriptObject) {
            return new MapIterator((ScriptObject)obj, includeUndefined);
        }
        return new EmptyArrayLikeIterator();
    }

    public static ArrayLikeIterator<Object> reverseArrayLikeIterator(Object object, boolean includeUndefined) {
        Object obj = object;
        if (ScriptObject.isArray(obj)) {
            return new ReverseArrayIterator((ScriptObject)obj, includeUndefined);
        }
        if ((obj = JSType.toScriptObject(obj)) instanceof ScriptObject) {
            return new ReverseMapIterator((ScriptObject)obj, includeUndefined);
        }
        assert (!obj.getClass().isArray());
        return new EmptyArrayLikeIterator();
    }
}

