/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.callstack.models;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.netbeans.lib.v8debug.V8Frame;
import org.netbeans.lib.v8debug.V8Script;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.callstack.models.Bundle;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.netbeans.modules.javascript.v8debug.frames.CallStack;
import org.netbeans.modules.javascript2.debug.models.ViewModelSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.datatransfer.PasteType;

public class DebuggingModel
extends ViewModelSupport
implements TreeModel,
ExtendedNodeModel {
    private static final String ICON_CALL_STACK = "org/netbeans/modules/debugger/resources/threadsView/call_stack_16.png";
    private static final String ICON_EMPTY = "org/netbeans/modules/debugger/resources/empty.gif";
    private static final Object DBG_RUNNING_NODE = new Object();
    private final V8Debugger dbg;

    public DebuggingModel(ContextProvider contextProvider) {
        this.dbg = (V8Debugger)contextProvider.lookupFirst(null, V8Debugger.class);
        ChangeListener changeListener = new ChangeListener();
        this.dbg.addListener(changeListener);
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            if (this.dbg.isSuspended()) {
                CallStack cs = this.dbg.getCurrentCallStack();
                if (cs != null) {
                    return cs.getCallFrames();
                }
            } else {
                return new Object[]{DBG_RUNNING_NODE};
            }
            return EMPTY_CHILDREN;
        }
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof CallStack) {
            return true;
        }
        if (node == DBG_RUNNING_NODE) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public boolean canRename(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object node) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object node) throws IOException, UnknownTypeException {
        return null;
    }

    public Transferable clipboardCut(Object node) throws IOException, UnknownTypeException {
        return null;
    }

    public PasteType[] getPasteTypes(Object node, Transferable t) throws UnknownTypeException {
        return null;
    }

    public void setName(Object node, String name) throws UnknownTypeException {
    }

    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node instanceof CallFrame) {
            return ICON_CALL_STACK;
        }
        if (node == DBG_RUNNING_NODE) {
            return ICON_EMPTY;
        }
        throw new UnknownTypeException(node);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof CallFrame) {
            CallFrame cf = (CallFrame)node;
            V8Frame frame = cf.getFrame();
            String text = "";
            String scriptName = DebuggingModel.getScriptName(cf);
            String thisName = cf.getThisName();
            if ("Object".equals(thisName) || "global".equals(thisName)) {
                thisName = null;
            }
            String functionName = cf.getFunctionName();
            long line = frame.getLine() + 1L;
            long column = frame.getColumn() + 1L;
            text = (thisName != null && !thisName.isEmpty() ? thisName + '.' : "") + functionName + " (" + (scriptName != null ? scriptName : "?") + ":" + line + ":" + column + ")";
            return text;
        }
        if (node == DBG_RUNNING_NODE) {
            return Bundle.CTL_DebuggerRunning();
        }
        throw new UnknownTypeException(node);
    }

    static String getScriptName(CallFrame cf) {
        V8Script script = cf.getScript();
        if (script != null) {
            String scriptName = script.getName();
            if (scriptName == null) {
                return null;
            }
            int i = scriptName.lastIndexOf(47);
            if (i < 0) {
                i = scriptName.lastIndexOf(92);
            }
            if (i > 0) {
                scriptName = scriptName.substring(i + 1);
            }
            return scriptName;
        }
        return null;
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not to be called.");
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof CallFrame) {
            CallFrame cf = (CallFrame)node;
            V8Frame frame = cf.getFrame();
            String text = frame.getText();
            if (text != null) {
                text = text.replace("\\n", "\n");
            }
            return text;
        }
        if (node == DBG_RUNNING_NODE) {
            return Bundle.CTL_DebuggerRunningDescr();
        }
        throw new UnknownTypeException(node);
    }

    private class ChangeListener
    implements V8Debugger.Listener {
        private WeakReference<CallFrame> lastCurrentFrame = new WeakReference<Object>(null);

        @Override
        public void notifySuspended(boolean suspended) {
            DebuggingModel.this.fireChangeEvent((ModelEvent)new ModelEvent.TreeChanged((Object)DebuggingModel.this));
        }

        @Override
        public void notifyCurrentFrame(CallFrame cf) {
            CallFrame last = (CallFrame)this.lastCurrentFrame.get();
            if (last != null) {
                DebuggingModel.this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)DebuggingModel.this, (Object)last));
            }
            if (cf != null) {
                DebuggingModel.this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)DebuggingModel.this, (Object)cf));
            }
            this.lastCurrentFrame = new WeakReference<CallFrame>(cf);
        }

        @Override
        public void notifyFinished() {
        }
    }
}

