/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.frames;

import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.lib.v8debug.V8Frame;
import org.netbeans.lib.v8debug.V8Script;
import org.netbeans.lib.v8debug.vars.ReferencedValue;
import org.netbeans.lib.v8debug.vars.V8ScriptValue;
import org.netbeans.lib.v8debug.vars.V8Value;
import org.netbeans.modules.javascript.v8debug.ReferencedValues;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;

public final class CallStack {
    public static final CallStack EMPTY = new CallStack(new V8Frame[0], new ReferencedValue[0]);
    private final V8Frame[] frames;
    private final ReferencedValues rvals;
    private CallFrame[] callFrames;
    private CallFrame topFrame;

    public CallStack(V8Frame[] frames, ReferencedValue[] referencedValues) {
        this.frames = frames;
        this.rvals = new ReferencedValues(referencedValues);
    }

    public boolean isEmpty() {
        return this.frames.length == 0;
    }

    public V8Frame[] getFrames() {
        return this.frames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallFrame[] getCallFrames() {
        CallStack callStack = this;
        synchronized (callStack) {
            if (this.callFrames == null) {
                CallFrame[] cfs = new CallFrame[this.frames.length];
                if (this.frames.length > 0) {
                    if (this.topFrame == null) {
                        this.topFrame = new CallFrame(this.frames[0], this.rvals, true);
                    }
                    cfs[0] = this.topFrame;
                }
                for (int i = 1; i < this.frames.length; ++i) {
                    cfs[i] = new CallFrame(this.frames[i], this.rvals, false);
                }
                this.callFrames = cfs;
            }
            return this.callFrames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public CallFrame getTopFrame() {
        if (this.frames.length > 0) {
            CallStack callStack = this;
            synchronized (callStack) {
                if (this.topFrame == null) {
                    this.topFrame = new CallFrame(this.frames[0], this.rvals, true);
                }
                return this.topFrame;
            }
        }
        return null;
    }

    public V8Script getScript(V8Frame frame) {
        long ref = frame.getScriptRef();
        V8Value val = this.rvals.getReferencedValue(ref);
        if (val instanceof V8ScriptValue) {
            return ((V8ScriptValue)val).getScript();
        }
        return null;
    }
}

