/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.vars;

import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Request;
import org.netbeans.lib.v8debug.V8Response;
import org.netbeans.lib.v8debug.commands.Evaluate;
import org.netbeans.lib.v8debug.vars.V8Boolean;
import org.netbeans.lib.v8debug.vars.V8Function;
import org.netbeans.lib.v8debug.vars.V8Number;
import org.netbeans.lib.v8debug.vars.V8Object;
import org.netbeans.lib.v8debug.vars.V8String;
import org.netbeans.lib.v8debug.vars.V8Value;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.vars.EvaluationError;

public class V8Evaluator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static V8Value evaluate(V8Debugger debugger, String expression) throws EvaluationError {
        final V8Value[] valueRef = new V8Value[]{null};
        final String[] errRef = new String[]{null};
        V8Request request = debugger.sendCommandRequest(V8Command.Evaluate, (V8Arguments)new Evaluate.Arguments(expression), new V8Debugger.CommandResponseCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyResponse(V8Request request, V8Response response) {
                V8Value[] v8ValueArray = valueRef;
                synchronized (valueRef) {
                    if (response != null) {
                        if (!response.isSuccess()) {
                            errRef[0] = response.getErrorMessage();
                        } else {
                            valueRef[0] = ((Evaluate.ResponseBody)response.getBody()).getValue();
                        }
                    }
                    valueRef.notifyAll();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
        });
        if (request == null) {
            return null;
        }
        V8Value[] v8ValueArray = valueRef;
        synchronized (valueRef) {
            if (valueRef[0] == null && errRef[0] == null) {
                try {
                    valueRef.wait();
                }
                catch (InterruptedException ex) {
                    throw new EvaluationError(ex.getLocalizedMessage());
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (errRef[0] != null) {
                throw new EvaluationError(errRef[0]);
            }
            return valueRef[0];
        }
    }

    public static String getStringValue(V8Value value) {
        switch (value.getType()) {
            case Boolean: {
                return Boolean.toString(((V8Boolean)value).getValue());
            }
            case Function: {
                V8Function function = (V8Function)value;
                String source = function.getSource();
                if (source != null) {
                    return source;
                }
                String name = function.getName();
                if (name == null || name.isEmpty()) {
                    name = function.getInferredName();
                }
                return "function " + name + "()";
            }
            case Null: {
                return String.valueOf((Object)null);
            }
            case Number: {
                V8Number n = (V8Number)value;
                switch (n.getKind()) {
                    case Double: {
                        return Double.toString(n.getDoubleValue());
                    }
                    case Long: {
                        return Long.toString(n.getLongValue());
                    }
                }
                throw new IllegalStateException("Unknown kind: " + n.getKind());
            }
            case Object: {
                V8Object.Array arr;
                V8Object o = (V8Object)value;
                StringBuilder sb = new StringBuilder("(");
                sb.append(o.getClassName());
                sb.append(')');
                if (o.getText() != null) {
                    sb.append(' ');
                    sb.append(o.getText());
                }
                if ((arr = o.getArray()) != null) {
                    sb.append(" length=");
                    sb.append(arr.getLength());
                }
                return sb.toString();
            }
            case String: {
                return "\"" + ((V8String)value).getValue() + "\"";
            }
            case Undefined: {
                return "undefined";
            }
        }
        if (value.getText() != null) {
            return value.getText();
        }
        throw new IllegalStateException("Unknown value type: " + value.getType());
    }

    public static String getStringType(V8Value value) {
        V8Value.Type type = value.getType();
        if (type == V8Value.Type.Object) {
            V8Object obj = (V8Object)value;
            return obj.getClassName();
        }
        return type.toString();
    }
}

