/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.vars.tooltip;

import java.io.Closeable;
import java.io.IOException;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.netbeans.modules.javascript2.debug.tooltip.DebuggerTooltipSupport;

public class V8DebuggerTooltipSupport
implements DebuggerTooltipSupport {
    private final V8Debugger debugger;
    private final CallFrame currentFrame;
    private V8Debugger.Listener closeableListener;

    V8DebuggerTooltipSupport(V8Debugger debugger, CallFrame currentFrame) {
        this.debugger = debugger;
        this.currentFrame = currentFrame;
    }

    public V8Debugger getDebugger() {
        return this.debugger;
    }

    public CallFrame getCurrentFrame() {
        return this.currentFrame;
    }

    public void addCloseable(Closeable closeable) {
        this.closeableListener = new TooltipCloseableListener(closeable);
        this.debugger.addListener(this.closeableListener);
    }

    public void removeCloseable(Closeable closeable) {
        this.debugger.removeListener(this.closeableListener);
    }

    private static final class TooltipCloseableListener
    implements V8Debugger.Listener {
        private final Closeable closeable;

        public TooltipCloseableListener(Closeable closeable) {
            this.closeable = closeable;
        }

        @Override
        public void notifySuspended(boolean suspended) {
            if (!suspended) {
                this.doClose();
            }
        }

        @Override
        public void notifyCurrentFrame(CallFrame cf) {
            this.doClose();
        }

        @Override
        public void notifyFinished() {
            this.doClose();
        }

        private void doClose() {
            try {
                this.closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

