/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public final class MultipleLoggers {
    public static Iterable<ErrorDescription> checkMultipleLoggers(HintContext ctx) {
        Element cls = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (cls == null || cls.getKind() != ElementKind.CLASS || cls.getModifiers().contains((Object)Modifier.ABSTRACT) || cls.getEnclosingElement() != null && cls.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            return null;
        }
        TypeElement loggerTypeElement = ctx.getInfo().getElements().getTypeElement("java.util.logging.Logger");
        if (loggerTypeElement == null) {
            return null;
        }
        TypeMirror loggerTypeElementAsType = loggerTypeElement.asType();
        if (loggerTypeElementAsType == null || loggerTypeElementAsType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        LinkedList<VariableElement> loggerFields = new LinkedList<VariableElement>();
        List<VariableElement> fields = ElementFilter.fieldsIn(cls.getEnclosedElements());
        for (VariableElement f : fields) {
            if (f.getKind() != ElementKind.FIELD || !f.asType().equals(loggerTypeElementAsType)) continue;
            loggerFields.add(f);
        }
        if (loggerFields.size() > 1) {
            StringBuilder loggers = new StringBuilder();
            for (VariableElement f : loggerFields) {
                int[] span;
                Tree path = ctx.getInfo().getTrees().getTree(f);
                if (!(path instanceof VariableTree) || (span = ctx.getInfo().getTreeUtilities().findNameSpan((VariableTree)path)) == null) continue;
                if (loggers.length() > 0) {
                    loggers.append(", ");
                }
                loggers.append(f.getSimpleName().toString());
            }
            LinkedList<ErrorDescription> errors = new LinkedList<ErrorDescription>();
            for (VariableElement f : loggerFields) {
                Tree path = ctx.getInfo().getTrees().getTree(f);
                ErrorDescription ed = ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)path, (String)NbBundle.getMessage(MultipleLoggers.class, (String)"MSG_MultipleLoggers_checkMultipleLoggers", (Object)loggers, (Object)cls), (Fix[])new Fix[0]);
                errors.add(ed);
            }
            return errors;
        }
        return null;
    }
}

