/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.control;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.hints.control.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.util.NbBundle;

public class RemoveUnnecessary {
    private static final Set<Tree.Kind> LOOP_KINDS = EnumSet.of(Tree.Kind.DO_WHILE_LOOP, Tree.Kind.ENHANCED_FOR_LOOP, Tree.Kind.FOR_LOOP, Tree.Kind.WHILE_LOOP);

    public static ErrorDescription unnecessaryReturn(HintContext ctx) {
        return RemoveUnnecessary.unnecessaryReturnContinue(ctx, null, "UnnecessaryReturnStatement");
    }

    public static ErrorDescription unnecessaryContinue(HintContext ctx) {
        return RemoveUnnecessary.unnecessaryReturnContinue(ctx, ctx.getInfo().getTreeUtilities().getBreakContinueTarget(ctx.getPath()), "UnnecessaryContinueStatement");
    }

    private static ErrorDescription unnecessaryReturnContinue(HintContext ctx, StatementTree targetLoop, String key) {
        TreePath tp = ctx.getPath();
        block8: while (tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
            List<? extends StatementTree> statements;
            Tree current = tp.getLeaf();
            tp = tp.getParentPath();
            switch (tp.getLeaf().getKind()) {
                case METHOD: {
                    if (targetLoop != null) {
                        return null;
                    }
                    MethodTree mt = (MethodTree)tp.getLeaf();
                    if (mt.getReturnType() == null) {
                        if (mt.getName().contentEquals("<init>")) break block8;
                        return null;
                    }
                    TypeMirror tm = ctx.getInfo().getTrees().getTypeMirror(new TreePath(tp, mt.getReturnType()));
                    if (tm != null && tm.getKind() == TypeKind.VOID) break block8;
                    return null;
                }
                case LAMBDA_EXPRESSION: {
                    TypeMirror returnType;
                    if (targetLoop != null) {
                        return null;
                    }
                    TypeMirror functionalType = ctx.getInfo().getTrees().getTypeMirror(tp);
                    if (functionalType == null || functionalType.getKind() != TypeKind.DECLARED) {
                        return null;
                    }
                    ExecutableType descriptorType = ctx.getInfo().getTypeUtilities().getDescriptorType((DeclaredType)functionalType);
                    TypeMirror typeMirror = returnType = descriptorType != null ? descriptorType.getReturnType() : null;
                    if (returnType != null && returnType.getKind() == TypeKind.VOID) break block8;
                    return null;
                }
                case BLOCK: {
                    statements = ((BlockTree)tp.getLeaf()).getStatements();
                    break;
                }
                case CASE: {
                    if (tp.getParentPath().getLeaf().getKind() == Tree.Kind.SWITCH) {
                        List<? extends CaseTree> cases = ((SwitchTree)tp.getParentPath().getLeaf()).getCases();
                        ArrayList<? extends StatementTree> locStatements = new ArrayList<StatementTree>();
                        for (int i = cases.indexOf(tp.getLeaf()); i < cases.size(); ++i) {
                            locStatements.addAll(cases.get(i).getStatements());
                        }
                        statements = locStatements;
                        break;
                    }
                    statements = ((CaseTree)tp.getLeaf()).getStatements();
                    break;
                }
                case DO_WHILE_LOOP: 
                case ENHANCED_FOR_LOOP: 
                case FOR_LOOP: 
                case WHILE_LOOP: {
                    if (tp.getLeaf() == targetLoop) break block8;
                    return null;
                }
                case TRY: {
                    if (((TryTree)tp.getLeaf()).getFinallyBlock() == current) {
                        return null;
                    }
                }
                default: {
                    continue block8;
                }
            }
            assert (!statements.isEmpty());
            int i = statements.indexOf(current);
            if (i == -1) {
                return null;
            }
            while (i + 1 < statements.size()) {
                StatementTree next = statements.get(i + 1);
                if (next.getKind() == Tree.Kind.EMPTY_STATEMENT) {
                    ++i;
                    continue;
                }
                if (next.getKind() == Tree.Kind.BLOCK) {
                    statements = ((BlockTree)next).getStatements();
                    i = -1;
                    continue;
                }
                if (next.getKind() == Tree.Kind.BREAK) {
                    StatementTree target = ctx.getInfo().getTreeUtilities().getBreakContinueTarget(new TreePath(tp, next));
                    if (target == null) {
                        return null;
                    }
                    tp = TreePath.getPath(ctx.getInfo().getCompilationUnit(), (Tree)target);
                    continue block8;
                }
                return null;
            }
        }
        String displayName = NbBundle.getMessage(RemoveUnnecessary.class, (String)("ERR_" + key));
        String fixDisplayName = NbBundle.getMessage(RemoveUnnecessary.class, (String)("FIX_" + key));
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[]{JavaFixUtilities.removeFromParent((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath())});
    }

    public static ErrorDescription unnecessaryContinueLabel(HintContext ctx) {
        return RemoveUnnecessary.unnecessaryLabel(ctx, false);
    }

    public static ErrorDescription unnecessaryBreakLabel(HintContext ctx) {
        return RemoveUnnecessary.unnecessaryLabel(ctx, true);
    }

    private static ErrorDescription unnecessaryLabel(HintContext ctx, boolean brk) {
        TreePath loop;
        for (loop = ctx.getPath(); !(loop == null || LOOP_KINDS.contains((Object)loop.getLeaf().getKind()) || brk && loop.getLeaf().getKind() == Tree.Kind.SWITCH); loop = loop.getParentPath()) {
        }
        if (loop == null) {
            return null;
        }
        if (ctx.getInfo().getTreeUtilities().getBreakContinueTarget(ctx.getPath()) != loop.getParentPath().getLeaf()) {
            return null;
        }
        Fix fix = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)(brk ? Bundle.FIX_UnnecessaryBreakStatementLabel() : Bundle.FIX_UnnecessaryContinueStatementLabel()), (TreePath)ctx.getPath(), (String)(brk ? "break;" : "continue;"));
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)(brk ? Bundle.ERR_UnnecessaryBreakStatementLabel() : Bundle.ERR_UnnecessaryContinueStatementLabel()), (Fix[])new Fix[]{fix});
    }
}

