/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class CreateFieldFix
implements EnhancedFix {
    private FileObject targetFile;
    private ElementHandle<TypeElement> target;
    private TypeMirrorHandle proposedType;
    private ClasspathInfo cpInfo;
    private Set<Modifier> modifiers;
    private final boolean remote;
    private String name;
    private String inFQN;

    public CreateFieldFix(CompilationInfo info, String name, Set<Modifier> modifiers, TypeElement target, TypeMirror proposedType, FileObject targetFile) {
        this.name = name;
        this.inFQN = Utilities.target2String(target);
        this.cpInfo = info.getClasspathInfo();
        this.modifiers = modifiers;
        this.targetFile = targetFile;
        this.target = ElementHandle.create((Element)target);
        if (proposedType.getKind() == TypeKind.NULL || proposedType.getKind() == TypeKind.NONE) {
            TypeElement te = info.getElements().getTypeElement("java.lang.Object");
            proposedType = te == null ? null : te.asType();
        }
        this.proposedType = proposedType == null ? null : TypeMirrorHandle.create((TypeMirror)proposedType);
        this.remote = !org.openide.util.Utilities.compareObjects((Object)info.getFileObject(), (Object)targetFile);
    }

    public String getText() {
        return NbBundle.getMessage(CreateFieldFix.class, (String)"LBL_FIX_Create_Field", (Object)this.name, (Object)this.inFQN);
    }

    public ChangeInfo implement() throws IOException {
        JavaSource js = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[]{this.targetFile});
        ModificationResult diff = js.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy working) throws IOException {
                working.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement targetType = (TypeElement)CreateFieldFix.this.target.resolve((CompilationInfo)working);
                if (targetType == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target.");
                    return;
                }
                ClassTree targetTree = working.getTrees().getTree(targetType);
                if (targetTree == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target tree: " + targetType.getQualifiedName() + ".");
                    return;
                }
                TypeMirror proposedType = CreateFieldFix.this.proposedType.resolve((CompilationInfo)working);
                if (proposedType == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve proposed type.");
                    return;
                }
                TreeMaker make = working.getTreeMaker();
                TypeMirror tm = proposedType;
                VariableTree var = make.Variable(make.Modifiers(CreateFieldFix.this.modifiers), (CharSequence)CreateFieldFix.this.name, make.Type(tm), null);
                ClassTree decl = GeneratorUtilities.get((WorkingCopy)working).insertClassMember(targetTree, (Tree)var);
                working.rewrite((Tree)targetTree, (Tree)decl);
            }
        });
        ChangeInfo ci = Utilities.commitAndComputeChangeInfo(this.targetFile, diff, null);
        if (this.remote) {
            return ci;
        }
        return null;
    }

    String toDebugString(CompilationInfo info) {
        return "CreateFieldFix:" + this.name + ":" + this.target.getQualifiedName() + ":" + this.proposedType.resolve(info).toString() + ":" + this.modifiers;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateFieldFix other = (CreateFieldFix)obj;
        if (!(this.target == other.target || this.target != null && this.target.equals(other.target))) {
            return false;
        }
        if (!(this.modifiers == other.modifiers || this.modifiers != null && this.modifiers.equals(other.modifiers))) {
            return false;
        }
        return this.name == other.name || this.name != null && this.name.equals(other.name);
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + (this.target != null ? this.target.hashCode() : 0);
        hash = 79 * hash + (this.modifiers != null ? this.modifiers.hashCode() : 0);
        hash = 79 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public CharSequence getSortText() {
        return "Create 6000 " + this.getText();
    }
}

