/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.swing.JButton;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.introduce.IntroduceFieldPanel;
import org.netbeans.modules.java.hints.introduce.IntroduceFixBase;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;
import org.netbeans.modules.java.hints.introduce.IntroduceKind;
import org.netbeans.modules.java.hints.introduce.TreeUtils;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

final class IntroduceVariableFix
extends IntroduceFixBase
implements Fix {
    private final String guessedName;

    static TreePath findAddPosition(CompilationInfo info, TreePath original, Set<? extends TreePath> candidates, int[] outPosition) {
        TreePath statement = original;
        for (TreePath treePath : candidates) {
            int stPathStart;
            Tree leaf = treePath.getLeaf();
            int leafStart = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), leaf);
            if (leafStart >= (stPathStart = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), statement.getLeaf()))) continue;
            statement = treePath;
        }
        LinkedList<? extends TreePath> allCandidates = new LinkedList<TreePath>();
        allCandidates.add(original);
        allCandidates.addAll(candidates);
        while (statement != null && statement.getParentPath() != null && !TreeUtils.isParentOf(statement.getParentPath(), allCandidates)) {
            statement = statement.getParentPath();
        }
        if ((statement = TreeUtils.findStatementInBlock(statement)) == null) {
            return null;
        }
        if (statement.getParentPath() == null) {
            return null;
        }
        if (statement.getParentPath().getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
            outPosition[0] = 0;
            return statement;
        }
        StatementTree statementTree = (StatementTree)statement.getLeaf();
        int index = IntroduceHint.getStatements(statement).indexOf(statementTree);
        if (index == -1) {
            return null;
        }
        outPosition[0] = index;
        return statement;
    }

    public IntroduceVariableFix(TreePathHandle handle, JavaSource js, String guessedName, int numDuplicates, IntroduceKind kind, int offset) {
        super(js, handle, numDuplicates, offset);
        this.guessedName = guessedName;
    }

    public String toString() {
        return "[IntroduceFix:" + this.guessedName + ":" + this.duplicatesCount + ":" + (Object)((Object)IntroduceKind.CREATE_VARIABLE) + "]";
    }

    public String getKeyExt() {
        return "IntroduceVariable";
    }

    public String getText() {
        return NbBundle.getMessage(IntroduceHint.class, (String)("FIX_" + this.getKeyExt()));
    }

    public ChangeInfo implement() throws IOException, BadLocationException {
        JButton btnOk = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
        JButton btnCancel = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
        IntroduceFieldPanel panel = new IntroduceFieldPanel(this.guessedName, null, this.duplicatesCount, true, this.handle.getKind() == Tree.Kind.VARIABLE, 2, "introduceVariable", btnOk);
        String caption = NbBundle.getMessage(IntroduceHint.class, (String)("CAP_" + this.getKeyExt()));
        DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
            return null;
        }
        final String name = panel.getFieldName();
        final boolean replaceAll = panel.isReplaceAll();
        final boolean declareFinal = panel.isDeclareFinal();
        this.js.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy parameter) throws Exception {
                AbstractList nueStatements;
                int index;
                TreePath statement;
                parameter.toPhase(JavaSource.Phase.RESOLVED);
                TreePath resolved = IntroduceVariableFix.this.handle.resolve((CompilationInfo)parameter);
                if (resolved == null) {
                    return;
                }
                TypeMirror tm = IntroduceHint.resolveType((CompilationInfo)parameter, resolved);
                if (tm == null) {
                    return;
                }
                if (!Utilities.isValidType(tm = Utilities.convertIfAnonymous(Utilities.resolveCapturedType((CompilationInfo)parameter, tm)))) {
                    return;
                }
                Tree original = resolved.getLeaf();
                boolean variableRewrite = original.getKind() == Tree.Kind.VARIABLE;
                ExpressionTree expression = !variableRewrite ? (ExpressionTree)resolved.getLeaf() : ((VariableTree)original).getInitializer();
                TreeMaker make = parameter.getTreeMaker();
                boolean expressionStatement = resolved.getParentPath().getLeaf().getKind() == Tree.Kind.EXPRESSION_STATEMENT;
                TreePath method = TreeUtils.findMethod(resolved);
                if (method == null) {
                    return;
                }
                if (replaceAll) {
                    Set candidates = SourceUtils.computeDuplicates((CompilationInfo)parameter, (TreePath)resolved, (TreePath)method, (AtomicBoolean)new AtomicBoolean());
                    for (TreePath p : candidates) {
                        Tree leaf = p.getLeaf();
                        parameter.rewrite(leaf, (Tree)make.Identifier((CharSequence)name));
                    }
                    int[] out = new int[1];
                    statement = IntroduceVariableFix.findAddPosition((CompilationInfo)parameter, resolved, candidates, out);
                    if (statement == null) {
                        return;
                    }
                    index = out[0];
                } else {
                    int[] out = new int[1];
                    statement = IntroduceVariableFix.findAddPosition((CompilationInfo)parameter, resolved, Collections.emptySet(), out);
                    if (statement == null) {
                        return;
                    }
                    index = out[0];
                }
                if (statement.getParentPath().getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
                    nueStatements = new ArrayList<ReturnTree>();
                    nueStatements.add(make.Return((ExpressionTree)statement.getLeaf()));
                } else {
                    nueStatements = new LinkedList<StatementTree>(IntroduceHint.getStatements(statement));
                }
                GeneratorUtilities.get((WorkingCopy)parameter).importComments(IntroduceHint.getStatementOrBlock(statement).getLeaf(), parameter.getCompilationUnit());
                ModifiersTree mods = make.Modifiers(declareFinal ? EnumSet.of(Modifier.FINAL) : EnumSet.noneOf(Modifier.class));
                VariableTree newVariable = make.Variable(mods, (CharSequence)name, make.Type(tm), expression);
                nueStatements.add(index, make.asReplacementOf((Tree)newVariable, resolved.getLeaf(), true));
                if (expressionStatement) {
                    make.asReplacementOf((Tree)newVariable, resolved.getParentPath().getLeaf());
                    nueStatements.remove(resolved.getParentPath().getLeaf());
                }
                IntroduceHint.doReplaceInBlockCatchSingleStatement(parameter, new HashMap<Tree, Tree>(), statement, nueStatements);
                if (!expressionStatement) {
                    Tree origParent = resolved.getParentPath().getLeaf();
                    Tree newParent = parameter.getTreeUtilities().translate(origParent, Collections.singletonMap(resolved.getLeaf(), make.asNew((Tree)make.Identifier((CharSequence)name))));
                    parameter.rewrite(origParent, newParent);
                }
            }
        }).commit();
        return null;
    }
}

