/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.java.hints.ArithmeticUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.modules.java.hints.suggestions.IfToSwitchSupport;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.util.NbBundle;

public class ConvertToStringSwitch {
    static final boolean DEF_ALSO_EQ = true;
    static final int DEF_THRESHOLD = 3;
    static final String KEY_ALSO_EQ = "also-equals";
    static final String KEY_THRESHOLD = "threshold";
    public static final boolean DEFAULT_OPTION_GENERATE_EMPTY_DEFAULT = true;
    public static final String OPTION_GENERATE_EMPTY_DEFAULT = "iftoswitch.generate.default";
    private static final String[] INIT_PATTERNS = new String[]{"$c1.equals($c2)", "$c1.contentEquals($c2)"};
    private static final String[] INIT_PATTERNS_EQ = new String[]{"$c1 == $c2"};
    private static final String[] PATTERNS = new String[]{"$var.equals($constant)", "$constant.equals($var)", "$var.contentEquals($constant)", "$constant.contentEquals($var)"};
    private static final String[] PATTERNS_EQ = new String[]{"$var == $constant", "$constant == $var"};

    public static List<ErrorDescription> hint(final HintContext ctx) {
        IfToSwitchSupport eval;
        if (ctx.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.IF || ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_7) < 0) {
            return null;
        }
        final TypeElement jlString = ctx.getInfo().getElements().getTypeElement("java.lang.String");
        if (jlString == null) {
            return null;
        }
        final ArrayList<String> initPatterns = new ArrayList<String>(INIT_PATTERNS.length + INIT_PATTERNS_EQ.length);
        initPatterns.addAll(Arrays.asList(INIT_PATTERNS));
        if (ctx.getPreferences().getBoolean(KEY_ALSO_EQ, true)) {
            initPatterns.addAll(Arrays.asList(INIT_PATTERNS_EQ));
        }
        if (!(eval = new IfToSwitchSupport(ctx){
            private boolean[] varConst;
            {
                super(x0);
                this.varConst = new boolean[1];
            }

            @Override
            protected Object evalConstant(TreePath path) {
                Object o;
                TypeMirror m = this.ci.getTrees().getTypeMirror(path);
                if (this.ci.getTypes().asElement(m) == jlString && ArithmeticUtilities.isRealValue(o = ArithmeticUtilities.compute(this.ci, path, true, true))) {
                    return o;
                }
                return null;
            }

            @Override
            protected TreePath matchesChainedItem(TreePath test, TreePath variable) {
                this.varConst[0] = false;
                TreePath p = ConvertToStringSwitch.isStringComparison(ctx, test, this.varConst, variable);
                if (p == null) {
                    return null;
                }
                if (this.varConst[0]) {
                    this.controlVariableNotNull();
                }
                return p;
            }

            @Override
            protected TreePath matches(TreePath test, boolean initial) {
                for (String pat : initPatterns) {
                    if (!MatcherUtilities.matches((HintContext)ctx, (TreePath)test, (String)pat, (boolean)true)) continue;
                    TreePath c1 = (TreePath)ctx.getVariables().get("$c1");
                    TypeMirror m = ctx.getInfo().getTrees().getTypeMirror(c1);
                    if (!Utilities.isValidType(m) || ctx.getInfo().getTypes().asElement(m) != jlString) continue;
                    TreePath c2 = (TreePath)ctx.getVariables().get("$c2");
                    m = ctx.getInfo().getTrees().getTypeMirror(c2);
                    if (!Utilities.isValidType(m) || ctx.getInfo().getTypes().asElement(m) != jlString) continue;
                    this.reportConstantAndLiteral(c1, c2);
                    return c1;
                }
                return null;
            }
        }).process((TreePath)ctx.getVariables().get("$cond"))) {
            return null;
        }
        int minBranches = ctx.getPreferences().getInt(KEY_THRESHOLD, 3);
        if (eval.getNumberOfBranches() < minBranches) {
            return null;
        }
        if (eval.containsDuplicateConstants()) {
            ArrayList<ErrorDescription> descs = new ArrayList<ErrorDescription>(eval.getDuplicateConstants().size());
            HashSet<String> seen = new HashSet<String>();
            for (Map.Entry<TreePath, Object> en : eval.getDuplicateConstants().entrySet()) {
                String lit = en.getValue().toString();
                if (!seen.add(lit)) continue;
                TreePath t = en.getKey();
                descs.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)t, (String)Bundle.TEXT_ChainedIfContainsSameValues(lit), (Fix[])new Fix[0]));
            }
            return descs;
        }
        Fix convert = eval.createFix(NbBundle.getMessage(ConvertToStringSwitch.class, (String)"FIX_ConvertToStringSwitch"), ctx.getPreferences().getBoolean(OPTION_GENERATE_EMPTY_DEFAULT, true)).toEditorFix();
        ErrorDescription ed = ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.TEXT_ConvertToSwitch(), (Fix[])new Fix[]{convert});
        return Collections.singletonList(ed);
    }

    private static TreePath isStringComparison(HintContext ctx, TreePath tp, boolean[] varConst, TreePath var) {
        Tree leaf = tp.getLeaf();
        while (leaf.getKind() == Tree.Kind.PARENTHESIZED) {
            tp = new TreePath(tp, ((ParenthesizedTree)leaf).getExpression());
            leaf = tp.getLeaf();
        }
        ArrayList<String> patterns = new ArrayList<String>(PATTERNS.length + PATTERNS_EQ.length);
        patterns.addAll(Arrays.asList(PATTERNS));
        ctx.getVariables().put("$var", var);
        if (ctx.getPreferences().getBoolean(KEY_ALSO_EQ, true)) {
            patterns.addAll(Arrays.asList(PATTERNS_EQ));
        }
        int i = -1;
        assert (PATTERNS.length == 4);
        for (String patt : patterns) {
            ++i;
            ctx.getVariables().remove("$constant");
            if (!MatcherUtilities.matches((HintContext)ctx, (TreePath)tp, (String)patt, (boolean)true)) continue;
            if (i % 2 == 0 && i < 4) {
                varConst[0] = true;
            }
            return (TreePath)ctx.getVariables().get("$constant");
        }
        return null;
    }
}

