/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class WildflyPluginProperties {
    public static final String PROPERTY_DISPLAY_NAME = "displayName";
    public static final String PROPERTY_SERVER = "server";
    public static final String PROPERTY_DEPLOY_DIR = "deploy-dir";
    public static final String PROPERTY_SERVER_DIR = "server-dir";
    public static final String PROPERTY_ROOT_DIR = "root-dir";
    public static final String PROPERTY_HOST = "host";
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_ADMIN_PORT = "admin-port";
    public static final String PROPERTY_JAVA_OPTS = "java_opts";
    public static final String PROPERTY_CONFIG_FILE = "config_file";
    private static WildflyPluginProperties pluginProperties = null;
    private String installLocation;
    private String domainLocation;
    private String configLocation;
    private WildflyPluginUtils.Version serverVersion = WildflyPluginUtils.WILDFLY_8_0_0;
    private static final String INSTALL_ROOT_KEY = "installRoot";
    public static final String INSTALL_ROOT_PROP_NAME = "com.sun.aas.installRoot";
    private FileObject propertiesFile = null;

    public static WildflyPluginProperties getInstance() {
        if (pluginProperties == null) {
            pluginProperties = new WildflyPluginProperties();
        }
        return pluginProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WildflyPluginProperties() {
        InputStream inStream = null;
        try {
            try {
                this.propertiesFile = this.getPropertiesFile();
                if (null != this.propertiesFile) {
                    inStream = this.propertiesFile.getInputStream();
                }
                this.loadPluginProperties(inStream);
                if (null == inStream) return;
            }
            catch (FileNotFoundException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
                this.loadPluginProperties(inStream);
                if (null == inStream) return;
                inStream.close();
                return;
            }
            catch (IOException e2) {
                Logger.getLogger("global").log(Level.INFO, null, e2);
                this.loadPluginProperties(inStream);
                if (null == inStream) return;
                {
                    catch (Throwable throwable) {
                        this.loadPluginProperties(inStream);
                        if (null == inStream) throw throwable;
                        inStream.close();
                        throw throwable;
                    }
                }
                inStream.close();
                return;
            }
            inStream.close();
            return;
        }
        catch (IOException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
        }
    }

    void loadPluginProperties(InputStream inStream) {
        String loc;
        Properties inProps = new Properties();
        if (null != inStream) {
            try {
                inProps.load(inStream);
            }
            catch (IOException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
        }
        if ((loc = inProps.getProperty(INSTALL_ROOT_KEY)) != null) {
            this.setInstallLocation(loc);
        }
    }

    private FileObject getPropertiesFile() throws IOException {
        FileObject dir = FileUtil.getConfigFile((String)"J2EE");
        FileObject retVal = null;
        if (null != dir && null == (retVal = dir.getFileObject("jb", "properties"))) {
            retVal = dir.createData("jb", "properties");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties() {
        block11: {
            Properties outProp = new Properties();
            String installRoot = this.getInstallLocation();
            if (installRoot != null) {
                outProp.setProperty(INSTALL_ROOT_KEY, installRoot);
            }
            FileLock l = null;
            OutputStream outStream = null;
            try {
                if (null == this.propertiesFile) break block11;
                try {
                    l = this.propertiesFile.lock();
                    outStream = this.propertiesFile.getOutputStream(l);
                    if (null != outStream) {
                        outProp.store(outStream, "");
                    }
                }
                catch (IOException e) {
                    Logger.getLogger("global").log(Level.INFO, null, e);
                }
                finally {
                    if (null != outStream) {
                        outStream.close();
                    }
                    if (null != l) {
                        l.releaseLock();
                    }
                }
            }
            catch (IOException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
        }
    }

    public boolean isCurrentServerLocationValid() {
        if (this.getInstallLocation() != null) {
            return WildflyPluginUtils.isGoodJBServerLocation(new File(this.getInstallLocation()));
        }
        return false;
    }

    public int getAdminPort() {
        if (this.installLocation == null || WildflyPluginUtils.WILDFLY_8_0_0.compareTo(this.serverVersion) > 0) {
            return 9999;
        }
        return 9990;
    }

    public void setInstallLocation(String installLocation) {
        this.installLocation = installLocation.endsWith(File.separator) ? installLocation.substring(0, installLocation.length() - 1) : installLocation;
        this.serverVersion = WildflyPluginUtils.getServerVersion(new File(this.installLocation));
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        if (configLocation.endsWith(File.separator)) {
            configLocation = configLocation.substring(0, configLocation.length() - 1);
        }
        this.configLocation = configLocation;
    }

    public void setDomainLocation(String domainLocation) {
        if (domainLocation.endsWith(File.separator)) {
            domainLocation = domainLocation.substring(0, domainLocation.length() - 1);
        }
        this.domainLocation = domainLocation;
    }

    public String getDomainLocation() {
        return this.domainLocation;
    }
}

