/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.spi.utils.CndFileExistSensitiveCache;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.dlight.libs.common.PerformanceLogger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class CndFileUtils {
    private static final boolean TRUE_CASE_SENSITIVE_SYSTEM;
    private static final FileChangeListener FSL;
    private static final FSProblemListener FSPL;
    private static final FileSystem fileFileSystem;
    public static final int FS_TIME_OUT = 30;
    public static final String LS_FOLDER_UTILS_PERFORMANCE_EVENT = "LS_FOLDER_UTILS_PERFORMANCE_EVENT";
    public static final String READ_FILE_PERFORMANCE_EVENT = "READ_FILE_PERFORMANCE_EVENT";
    private static final ConcurrentHashMap<FileSystem, ConcurrentHashMap<CharSequence, FileObject>> foCache;
    private static final boolean isWindows;
    private static final String windowsDrive;
    private static final String windowsPathSeparator = "\\";
    private static final boolean ASSERT_INDEXED_NOTFOUND;
    private static L1Cache l1Cache;
    private static final Lock maRefLock;
    private static final Map<FileSystem, Reference<ConcurrentMap<String, Flags>>> maps;
    private static final ThreadLocal<Boolean> fileSystemError;
    private static final boolean TRACE_EXTERNAL_CHANGES;
    private static volatile Collection<? extends CndFileExistSensitiveCache> listeners;

    private CndFileUtils() {
    }

    public static boolean isSystemCaseSensitive() {
        return TRUE_CASE_SENSITIVE_SYSTEM;
    }

    public static boolean areFilenamesEqual(String firstFile, String secondFile) {
        return CndFileUtils.isSystemCaseSensitive() ? firstFile.equals(secondFile) : firstFile.equalsIgnoreCase(secondFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFileExistenceCache() {
        try {
            maRefLock.lock();
            for (Reference<ConcurrentMap<String, Flags>> reference : maps.values()) {
                reference.clear();
            }
            maps.clear();
        }
        finally {
            maRefLock.unlock();
        }
        for (CndFileExistSensitiveCache cndFileExistSensitiveCache : CndFileUtils.getCaches()) {
            cndFileExistSensitiveCache.invalidateAll();
        }
    }

    public static InputStream getInputStream(FileObject fo, int maxSize) throws IOException {
        return CndFileSystemProvider.getInputStream(fo, maxSize);
    }

    public static File normalizeFile(File file) {
        CndUtils.assertAbsoluteFileInConsole(file, "Is it OK to normalize not absolute file? [" + file + "] during this session it is [" + file.getAbsolutePath() + "] but will be different if start IDE from another folder");
        String path = file.getPath();
        String normPath = CndFileUtils.normalizeAbsolutePath(file.getAbsolutePath());
        return path.equals(normPath) ? file : new File(normPath);
    }

    public static File toFile(FileObject fileObject) {
        return CndFileSystemProvider.toFile(fileObject);
    }

    public static FileObject toFileObject(File file) {
        return CndFileSystemProvider.toFileObject(file);
    }

    public static FileObject toFileObject(FileSystem fs, CharSequence absolutePath) {
        FileObject res;
        ConcurrentHashMap<CharSequence, FileObject> old;
        CndUtils.assertTrueInConsole(absolutePath != null, "null path ", fs);
        ConcurrentHashMap<CharSequence, Object> map = foCache.get(fs);
        if (map == null && (old = foCache.putIfAbsent(fs, map = new ConcurrentHashMap())) != null) {
            map = old;
        }
        if (((res = map.get(absolutePath)) == null || !res.isValid()) && (res = CndFileUtils.toFileObjectImpl(fs, absolutePath)) != null && res.isValid()) {
            map.put(absolutePath, res);
        }
        return res;
    }

    private static FileObject toFileObjectImpl(FileSystem fs, CharSequence absolutePath) {
        if (CndFileUtils.isLocalFileSystem(fs)) {
            return CndFileUtils.toFileObject(absolutePath);
        }
        return fs.findResource(absolutePath.toString());
    }

    public static FileObject toFileObject(CharSequence absoluteLocalPath) {
        return CndFileSystemProvider.toFileObject(absoluteLocalPath);
    }

    public static String getCanonicalPath(CharSequence path) throws IOException {
        return new File(path.toString()).getCanonicalPath();
    }

    public static FileObject getCanonicalFileObject(FileObject fo) throws IOException {
        Parameters.notNull((CharSequence)"FileObject", (Object)fo);
        return CndFileSystemProvider.getCanonicalFileObject(fo);
    }

    public static String getCanonicalPath(FileObject fo) throws IOException {
        return CndFileSystemProvider.getCanonicalPath(fo);
    }

    public static boolean isValidLocalFile(String absolutePath) {
        if (CndPathUtilities.isPathAbsolute(absolutePath)) {
            return new File(absolutePath).exists();
        }
        return false;
    }

    public static boolean isValidLocalFile(String base, String name) {
        if (CndPathUtilities.isPathAbsolute(base)) {
            return new File(base, name).exists();
        }
        return false;
    }

    public static boolean isValidLocalFile(File base, String name) {
        if (CndPathUtilities.isPathAbsolute(base.getPath())) {
            return new File(base, name).exists();
        }
        return false;
    }

    public static File createLocalFile(String absolutePath) {
        Parameters.notNull((CharSequence)"null path", (Object)absolutePath);
        CndUtils.assertAbsolutePathInConsole(absolutePath);
        return new File(absolutePath);
    }

    public static File createLocalFile(File base, String path) {
        Parameters.notNull((CharSequence)"null base file", (Object)base);
        CndUtils.assertAbsoluteFileInConsole(base);
        Parameters.notNull((CharSequence)"null path", (Object)path);
        return new File(base, path);
    }

    public static File createLocalFile(String base, String path) {
        Parameters.notNull((CharSequence)"null base file", (Object)base);
        CndUtils.assertAbsolutePathInConsole(base);
        Parameters.notNull((CharSequence)"null path", (Object)path);
        return new File(base, path);
    }

    public static File createLocalFile(URI uri) {
        File file = Utilities.toFile((URI)uri);
        CndUtils.assertAbsoluteFileInConsole(file);
        return file;
    }

    public static String normalizePath(FileObject fo) {
        try {
            return CndFileUtils.normalizeAbsolutePath(fo.getFileSystem(), fo.getPath());
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return fo.getPath();
        }
    }

    public static String normalizeAbsolutePath(FileSystem fs, String path) {
        return CndFileSystemProvider.normalizeAbsolutePath(fs, path);
    }

    public static String normalizeAbsolutePath(String path) {
        CndUtils.assertAbsolutePathInConsole(path, "path for normalization must be absolute");
        if (path.startsWith("/") && Utilities.isWindows()) {
            return PathUtilities.normalizeUnixPath((String)path);
        }
        boolean caseSensitive = CndFileUtils.isSystemCaseSensitive();
        if (!caseSensitive && Utilities.isWindows()) {
            path = path.replace('\\', '/');
        }
        String normalized = !caseSensitive || path.endsWith("/.") || path.endsWith("\\.") || path.contains("..") || path.contains("./") || path.contains(".\\") ? FileUtil.normalizeFile((File)new File(path)).getAbsolutePath() : path;
        return normalized;
    }

    public static boolean exists(File file) {
        return CndFileUtils.getFlags(CndFileUtils.getLocalFileSystem(), file.getAbsolutePath(), true).exist;
    }

    public static boolean exists(FileSystem fs, String absolutePath) {
        return CndFileUtils.getFlags(fs, absolutePath, true).exist;
    }

    public static boolean isExistingFile(String filePath) {
        return CndFileUtils.isExistingFile(CndFileUtils.getLocalFileSystem(), filePath);
    }

    public static boolean isExistingFile(FileSystem fs, String filePath) {
        Flags flags = CndFileUtils.getFlags(fs, filePath, true);
        return flags.exist && !flags.directory;
    }

    public static boolean isExistingDirectory(FileSystem fs, String filePath) {
        Flags flags = CndFileUtils.getFlags(fs, filePath, false);
        return flags.exist && flags.directory;
    }

    public static FileObject urlToFileObject(CharSequence url) {
        return CndFileSystemProvider.urlToFileObject(url);
    }

    public static FileSystem urlToFileSystem(CharSequence url) {
        return CndFileSystemProvider.urlToFileSystem(url);
    }

    public static CharSequence fileObjectToUrl(FileObject fileObject) {
        return CndFileSystemProvider.fileObjectToUrl(fileObject);
    }

    private static Flags getFlags(FileSystem fs, String absolutePath, boolean indexParentFolder) {
        assert (fs != null);
        assert (absolutePath != null);
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrueInConsole(!absolutePath.contains("var/cache/remote-files"), "trying to get access to " + absolutePath);
        }
        if (isWindows && CndFileUtils.isLocalFileSystem(fs) && (absolutePath = absolutePath.replace('/', '\\')).startsWith(windowsPathSeparator)) {
            absolutePath = windowsDrive + absolutePath.substring(1);
        }
        absolutePath = CndFileUtils.changeStringCaseIfNeeded(fs, absolutePath);
        ConcurrentMap<String, Flags> files = CndFileUtils.getFilesMap(fs);
        Flags exists = (Flags)files.get(absolutePath);
        if (exists == null) {
            String parent = CndPathUtilities.getDirName(absolutePath);
            if (parent != null) {
                Flags parentDirFlags = (Flags)files.get(parent);
                if (parentDirFlags == null || parentDirFlags == Flags.DIRECTORY) {
                    if (parentDirFlags == null) {
                        parentDirFlags = Flags.get(fs, parent);
                        files.putIfAbsent(parent, parentDirFlags);
                    }
                    if (parentDirFlags == Flags.NOT_FOUND || parentDirFlags == Flags.BROKEN_LINK || parentDirFlags == Flags.FILE) {
                        exists = Flags.NOT_FOUND;
                    } else if (parentDirFlags == Flags.NOT_FOUND_CONNECTION_ISSUE) {
                        exists = Flags.NOT_FOUND_CONNECTION_ISSUE;
                    } else if (indexParentFolder) {
                        assert (parentDirFlags == Flags.DIRECTORY) : "must be DIRECTORY but was " + parentDirFlags;
                        CndFileUtils.index(fs, parent, files);
                        exists = (Flags)files.get(absolutePath);
                        if (exists == null) {
                            exists = Flags.NOT_FOUND;
                        }
                    }
                } else if (parentDirFlags == Flags.INDEXED_DIRECTORY) {
                    exists = Flags.NOT_FOUND;
                    if (ASSERT_INDEXED_NOTFOUND) assert (Flags.get(fs, absolutePath) == Flags.NOT_FOUND) : absolutePath + " exists, but reported as NOT_FOUND";
                } else {
                    exists = parentDirFlags == Flags.NOT_FOUND || parentDirFlags == Flags.BROKEN_LINK ? Flags.NOT_FOUND : (parentDirFlags == Flags.NOT_FOUND_CONNECTION_ISSUE ? Flags.NOT_FOUND_CONNECTION_ISSUE : (Flags)files.get(absolutePath));
                }
            }
            if (exists == null) {
                exists = Flags.get(fs, absolutePath);
                files.putIfAbsent(absolutePath, exists);
            }
            if (exists == Flags.DIRECTORY) {
                CndFileUtils.index(fs, absolutePath, files);
            }
        } else if (exists == Flags.NOT_FOUND_CONNECTION_ISSUE) {
            CndFileSystemProviderHelper.fireFileSystemProblemOccurred(new FSPath(fs, absolutePath));
        }
        return exists;
    }

    public static boolean isLocalFileSystem(FileSystem fs) {
        return fs == CndFileUtils.getLocalFileSystem();
    }

    public static boolean isLocalFileSystem(FileObject fo) {
        try {
            return fo.getFileSystem() == CndFileUtils.getLocalFileSystem();
        }
        catch (FileStateInvalidException ex) {
            return false;
        }
    }

    private static void index(FileSystem fs, String path, ConcurrentMap<String, Flags> files) {
        if (CndFileUtils.isLocalFileSystem(fs)) {
            File file = new File(path);
            if (CndFileSystemProvider.canRead(path).booleanValue()) {
                CndFileSystemProvider.FileInfo[] listFiles;
                for (CndFileSystemProvider.FileInfo curFile : listFiles = CndFileUtils.listFilesImpl(file)) {
                    String absPath = CndFileUtils.changeStringCaseIfNeeded(fs, curFile.absolutePath);
                    if (isWindows) {
                        absPath = absPath.replace('/', '\\');
                    }
                    if (curFile.directory) {
                        files.putIfAbsent(absPath, Flags.DIRECTORY);
                        continue;
                    }
                    if (curFile.file) {
                        files.put(absPath, Flags.FILE);
                        continue;
                    }
                    files.put(absPath, Flags.BROKEN_LINK);
                }
            }
        } else {
            FileObject file = fs.findResource(path);
            if (file != null && file.isFolder() && file.canRead()) {
                char fileSeparatorChar = CndFileUtils.getFileSeparatorChar(fs);
                fileSystemError.set(Boolean.FALSE);
                FileObject[] children = file.getChildren();
                if (fileSystemError.get().booleanValue()) {
                    files.put(path, Flags.NOT_FOUND_CONNECTION_ISSUE);
                    return;
                }
                for (FileObject child : children) {
                    String absPath = path + fileSeparatorChar + child.getNameExt();
                    if (child.isFolder()) {
                        files.putIfAbsent(absPath, Flags.DIRECTORY);
                        continue;
                    }
                    if (child.isData()) {
                        files.put(absPath, Flags.FILE);
                        continue;
                    }
                    files.put(absPath, Flags.BROKEN_LINK);
                }
            }
        }
        assert (CndFileUtils.changeStringCaseIfNeeded(fs, path).equals(path));
        files.put(path, Flags.INDEXED_DIRECTORY);
    }

    private static String changeStringCaseIfNeeded(FileSystem fs, String path) {
        if (CndFileUtils.isLocalFileSystem(fs)) {
            if (CndFileUtils.isSystemCaseSensitive()) {
                return path;
            }
            return path.toLowerCase();
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap<String, Flags> getFilesMap(FileSystem fs) {
        ConcurrentHashMap<String, Flags> map;
        L1Cache aCache;
        if (CndTraceFlags.L1_CACHE_FILE_UTILS && (aCache = l1Cache) != null && (map = aCache.get(fs)) != null) {
            return map;
        }
        try {
            maRefLock.lock();
            Reference<ConcurrentMap<String, Flags>> mapRef = maps.get(fs);
            if (mapRef == null || (map = mapRef.get()) == null) {
                map = new ConcurrentHashMap();
                mapRef = new SoftReference(map);
                maps.put(fs, mapRef);
                if (CndTraceFlags.L1_CACHE_FILE_UTILS) {
                    l1Cache = new L1Cache(fs, mapRef);
                }
            }
        }
        finally {
            maRefLock.unlock();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CndFileSystemProvider.FileInfo[] listFilesImpl(File file) {
        CndFileSystemProvider.FileInfo[] info = CndFileSystemProvider.getChildInfo(file.getAbsolutePath());
        if (info == null) {
            File[] children;
            PerformanceLogger.PerformaceAction lsPerformanceEvent;
            block5: {
                lsPerformanceEvent = PerformanceLogger.getLogger().start(LS_FOLDER_UTILS_PERFORMANCE_EVENT, (Object)file);
                children = null;
                try {
                    lsPerformanceEvent.setTimeOut(30);
                    children = file.listFiles();
                    if (children != null) {
                        info = new CndFileSystemProvider.FileInfo[children.length];
                        for (int i = 0; i < children.length; ++i) {
                            info[i] = new CndFileSystemProvider.FileInfo(children[i].getAbsolutePath(), children[i].isDirectory(), children[i].isFile());
                        }
                        break block5;
                    }
                    info = new CndFileSystemProvider.FileInfo[]{};
                }
                catch (Throwable throwable) {
                    lsPerformanceEvent.log(new Object[]{children == null ? 0 : children.length});
                    throw throwable;
                }
            }
            lsPerformanceEvent.log(new Object[]{children == null ? 0 : children.length});
        }
        return info;
    }

    public static FileSystem getLocalFileSystem() {
        return fileFileSystem;
    }

    public static char getFileSeparatorChar(FileSystem fs) {
        if (CndFileUtils.isLocalFileSystem(fs)) {
            return File.separatorChar;
        }
        return '/';
    }

    public static List<String> toPathList(Collection<FSPath> paths) {
        if (paths != null && paths.size() > 0) {
            ArrayList<String> result = new ArrayList<String>(paths.size());
            for (FSPath fSPath : paths) {
                result.add(fSPath.getPath());
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<FSPath> toFSPathList(FileSystem fileSystem, Collection<String> paths) {
        if (paths != null && paths.size() > 0) {
            ArrayList<FSPath> result = new ArrayList<FSPath>(paths.size());
            for (String path : paths) {
                result.add(new FSPath(fileSystem, path));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static FileSystem decodeFileSystem(CharSequence stringRepresentation) throws IOException {
        FileObject rootFileObject = CndFileUtils.urlToFileObject(stringRepresentation);
        assert (rootFileObject != null) : "Restored null file object for URL " + stringRepresentation;
        return rootFileObject.getFileSystem();
    }

    public static CharSequence codeFileSystem(FileSystem fs) throws IOException {
        CharSequence rootUrl = CharSequences.create((CharSequence)CndFileUtils.fileObjectToUrl(fs.getRoot()));
        return rootUrl;
    }

    private static Collection<? extends CndFileExistSensitiveCache> getCaches() {
        if (listeners == null) {
            listeners = Lookup.getDefault().lookupAll(CndFileExistSensitiveCache.class);
        }
        return listeners;
    }

    static {
        boolean caseSenstive;
        FSL = new FSListener();
        FSPL = new FSProblemListener();
        FileSystem afileFileSystem = null;
        File tmpDirFile = new File(System.getProperty("java.io.tmpdir"));
        FileObject tmpDirFo = FileUtil.toFileObject((File)(tmpDirFile = FileUtil.normalizeFile((File)tmpDirFile)));
        if (tmpDirFo != null) {
            try {
                afileFileSystem = tmpDirFo.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            tmpDirFile = new File(System.getProperty("netbeans.user"));
            tmpDirFo = FileUtil.toFileObject((File)(tmpDirFile = FileUtil.normalizeFile((File)tmpDirFile)));
            if (tmpDirFo != null) {
                try {
                    afileFileSystem = tmpDirFo.getFileSystem();
                }
                catch (FileStateInvalidException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (afileFileSystem == null) {
            afileFileSystem = InvalidFileObjectSupport.getDummyFileSystem();
            Exceptions.printStackTrace((Throwable)new Exception("Cannot get local file system"));
        }
        fileFileSystem = afileFileSystem;
        try {
            File tmpFile = File.createTempFile("CaseSensitiveFile", ".check");
            String absPath = tmpFile.getAbsolutePath();
            absPath = absPath.toUpperCase();
            caseSenstive = !new File(absPath).exists();
            tmpFile.delete();
        }
        catch (IOException ex) {
            caseSenstive = Utilities.isUnix() && !Utilities.isMac();
        }
        TRUE_CASE_SENSITIVE_SYSTEM = caseSenstive;
        CndFileSystemProvider.addFileChangeListener(FSL);
        CndFileSystemProviderHelper.addFileSystemProblemListener(FSPL);
        foCache = new ConcurrentHashMap();
        isWindows = Utilities.isWindows();
        if (isWindows) {
            String disk = new File(windowsPathSeparator).getAbsolutePath();
            if (!disk.endsWith(windowsPathSeparator)) {
                assert (disk.endsWith(":")) : "unexpected disk name " + disk;
                disk = disk + windowsPathSeparator;
            }
            windowsDrive = disk;
        } else {
            windowsDrive = "";
        }
        ASSERT_INDEXED_NOTFOUND = Boolean.getBoolean("cnd.modelimpl.assert.notfound");
        maRefLock = new ReentrantLock();
        maps = new WeakHashMap<FileSystem, Reference<ConcurrentMap<String, Flags>>>();
        fileSystemError = new ThreadLocal();
        TRACE_EXTERNAL_CHANGES = Boolean.getBoolean("cnd.modelimpl.trace.external.changes");
    }

    private static final class FSListener
    implements FileChangeListener {
        private FSListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
            String path = this.checkSeparators(fe.getFile());
            String absPath = CndFileUtils.changeStringCaseIfNeeded(this.getFileSystem(fe), path);
            FileSystem fs = this.getFileSystem(fe);
            if (CndFileUtils.getFilesMap(fs).put(absPath, Flags.DIRECTORY) != null) {
                FSListener.invalidateFile(fs, path, absPath);
            }
        }

        public void fileDataCreated(FileEvent fe) {
            String path = this.checkSeparators(fe.getFile());
            String absPath = CndFileUtils.changeStringCaseIfNeeded(this.getFileSystem(fe), path);
            FileSystem fs = this.getFileSystem(fe);
            if (CndFileUtils.getFilesMap(fs).put(absPath, Flags.FILE) != null) {
                FSListener.invalidateFile(fs, path, absPath);
            }
        }

        public void fileDeleted(FileEvent fe) {
            this.clearCachesAboutFile(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            FSPath parent = this.clearCachesAboutFile((FileEvent)fe);
            if (parent != null) {
                String ext = fe.getExt();
                String oldName = ext.length() == 0 ? fe.getName() : fe.getName() + "." + ext;
                this.clearCachesAboutFile(parent.getChild(oldName), false);
            }
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        private FSPath clearCachesAboutFile(FileEvent fe) {
            return this.clearCachesAboutFile(FSPath.toFSPath(fe.getFile()), false);
        }

        private FSPath clearCachesAboutFile(FSPath f, boolean withParent) {
            this.cleanCachesImpl(f);
            if (withParent) {
                FSPath parent = f.getParent();
                if (parent != null) {
                    this.cleanCachesImpl(parent);
                }
                return parent;
            }
            return null;
        }

        private String checkSeparators(FileObject fo) {
            return this.checkSeparators(FSPath.toFSPath(fo));
        }

        private String checkSeparators(FSPath path) {
            String absPath = path.getPath();
            if (isWindows && CndFileUtils.isLocalFileSystem(path.getFileSystem())) {
                absPath = absPath.replace('/', '\\');
            }
            return absPath;
        }

        private FileSystem getFileSystem(FileEvent fe) {
            return this.getFileSystem(fe.getFile());
        }

        private FileSystem getFileSystem(FileObject fo) {
            try {
                return fo.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private static void invalidateFile(FileSystem fileSystem, String file, String localPathOrRemoteUrl) {
            for (CndFileExistSensitiveCache cache : CndFileUtils.getCaches()) {
                cache.invalidateFile(fileSystem, file);
                cache.invalidateFile(fileSystem, localPathOrRemoteUrl);
            }
        }

        private void cleanCachesImpl(FSPath fsPath) {
            String file = this.checkSeparators(fsPath);
            String absPath = CndFileUtils.changeStringCaseIfNeeded(fsPath.getFileSystem(), file);
            Flags removed = (Flags)CndFileUtils.getFilesMap(CndFileUtils.getLocalFileSystem()).remove(absPath);
            if (TRACE_EXTERNAL_CHANGES) {
                System.err.printf("clean cache for %s->%s\n", absPath, removed);
            }
            FSListener.invalidateFile(fsPath.getFileSystem(), file, absPath);
        }
    }

    private static class CndFileSystemProviderHelper {
        private CndFileSystemProviderHelper() {
        }

        public static void addFileSystemProblemListener(CndFileSystemProvider.CndFileSystemProblemListener listener) {
            FakeProvider.addProblemListener(listener);
        }

        public static void fireFileSystemProblemOccurred(FSPath fSPath) {
            FakeProvider.fireProblem(fSPath);
        }

        private static abstract class FakeProvider
        extends CndFileSystemProvider {
            private FakeProvider() {
            }

            public static void addProblemListener(CndFileSystemProvider.CndFileSystemProblemListener listener) {
                CndFileSystemProvider.addFileSystemProblemListener(listener);
            }

            protected static void fireProblem(FSPath fSPath) {
                CndFileSystemProvider.fireFileSystemProblemOccurred(fSPath);
            }
        }
    }

    private static final class FSProblemListener
    implements CndFileSystemProvider.CndFileSystemProblemListener {
        private FSProblemListener() {
        }

        @Override
        public void problemOccurred(FSPath fsPath) {
            fileSystemError.set(Boolean.TRUE);
        }

        @Override
        public void recovered(FileSystem fileSystem) {
        }
    }

    private static final class Flags {
        private final boolean exist;
        private final boolean directory;
        private static final Flags FILE = new Flags(true, false);
        private static final Flags DIRECTORY = new Flags(true, true);
        private static final Flags INDEXED_DIRECTORY = new Flags(true, true);
        private static final Flags NOT_FOUND = new Flags(false, true);
        private static final Flags NOT_FOUND_CONNECTION_ISSUE = new Flags(false, true);
        private static final Flags BROKEN_LINK = new Flags(false, false);

        private Flags(boolean exist, boolean directory) {
            this.exist = exist;
            this.directory = directory;
        }

        private static Flags get(FileSystem fs, String absPath) {
            FileObject fo;
            fileSystemError.set(Boolean.FALSE);
            if (CndFileUtils.isLocalFileSystem(fs)) {
                absPath = FileUtil.normalizePath((String)absPath);
                fo = CndFileSystemProvider.toFileObject(absPath);
            } else {
                fo = fs.findResource(absPath);
            }
            if (fo != null && fo.isValid()) {
                if (fo.isFolder()) {
                    return DIRECTORY;
                }
                assert (fo.isData()) : "not a file " + fo;
                return FILE;
            }
            return (Boolean)fileSystemError.get() != false ? NOT_FOUND_CONNECTION_ISSUE : NOT_FOUND;
        }

        public String toString() {
            if (this == NOT_FOUND) {
                return "NOT_FOUND";
            }
            if (this == NOT_FOUND_CONNECTION_ISSUE) {
                return "NOT_FOUND_CONNECTION_ISSUE";
            }
            if (this == INDEXED_DIRECTORY) {
                return "INDEXED_DIRECTORY";
            }
            if (this == DIRECTORY) {
                return "DIRECTORY";
            }
            if (this == FILE) {
                return "FILE";
            }
            if (this == BROKEN_LINK) {
                return "BROKEN_LINK";
            }
            return "UNKNOWN";
        }
    }

    private static final class L1Cache {
        private final FileSystem fs;
        private final Reference<ConcurrentMap<String, Flags>> mapRef;

        private L1Cache(FileSystem fs, Reference<ConcurrentMap<String, Flags>> mapRef) {
            this.fs = fs;
            this.mapRef = mapRef;
        }

        private ConcurrentMap<String, Flags> get(FileSystem fs) {
            if (this.fs == fs) {
                return this.mapRef.get();
            }
            return null;
        }
    }
}

