/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.diff.builtin.Base64;
import org.netbeans.modules.diff.builtin.Hunk;
import org.netbeans.modules.diff.builtin.PatchException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ContextualPatch {
    public static final String MAGIC = "# This patch file was generated by NetBeans IDE";
    private final Pattern unifiedRangePattern = Pattern.compile("@@ -(\\d+)(,\\d+)? \\+(\\d+)(,\\d+)? @@(\\s.*)?");
    private final Pattern baseRangePattern = Pattern.compile("\\*\\*\\* (\\d+)(,\\d+)? \\*\\*\\*\\*");
    private final Pattern modifiedRangePattern = Pattern.compile("--- (\\d+)(,\\d+)? ----");
    private final Pattern normalChangeRangePattern = Pattern.compile("(\\d+)(,(\\d+))?c(\\d+)(,(\\d+))?");
    private final Pattern normalAddRangePattern = Pattern.compile("(\\d+)a(\\d+),(\\d+)");
    private final Pattern normalDeleteRangePattern = Pattern.compile("(\\d+),(\\d+)d(\\d+)");
    private final Pattern binaryHeaderPattern = Pattern.compile("MIME: (.*?); encoding: (.*?); length: (-?\\d+?)");
    private final File patchFile;
    private final File suggestedContext;
    private File context;
    private BufferedReader patchReader;
    private String patchLine;
    private boolean patchLineRead;
    private int lastPatchedLine;

    public static ContextualPatch create(File patchFile, File context) {
        return new ContextualPatch(patchFile, context);
    }

    private ContextualPatch(File patchFile, File context) {
        this.patchFile = patchFile;
        this.suggestedContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PatchReport> patch(boolean dryRun, ProgressHandle ph) throws PatchException, IOException {
        ArrayList<PatchReport> report = new ArrayList<PatchReport>();
        this.init();
        try {
            SinglePatch patch;
            this.patchLine = this.patchReader.readLine();
            ArrayList<SinglePatch> patches = new ArrayList<SinglePatch>();
            while ((patch = this.getNextPatch()) != null) {
                patches.add(patch);
            }
            this.computeContext(patches);
            if (ph != null && patches.size() > 0) {
                ph.switchToDeterminate(patches.size());
            }
            this.resortPatches(patches);
            for (int i = 0; i < patches.size(); ++i) {
                SinglePatch patch2 = (SinglePatch)patches.get(i);
                try {
                    this.applyPatch(patch2, dryRun);
                    if (ph != null) {
                        ph.progress(patch2.targetPath, i + 1);
                    }
                    report.add(new PatchReport(patch2.targetFile, this.computeBackup(patch2.rename ? patch2.sourceFile : patch2.targetFile), patch2.binary, PatchStatus.Patched, null));
                    patch2.applied = true;
                    continue;
                }
                catch (Exception e) {
                    report.add(new PatchReport(patch2.targetFile, null, patch2.binary, PatchStatus.Failure, e));
                }
            }
            this.applyPendingDeletes(patches, report);
            ArrayList<PatchReport> arrayList = report;
            return arrayList;
        }
        finally {
            if (this.patchReader != null) {
                try {
                    this.patchReader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void resortPatches(List<SinglePatch> patches) {
        Collections.sort(patches, new Comparator<SinglePatch>(){

            @Override
            public int compare(SinglePatch p1, SinglePatch p2) {
                if (p1.copy && !p2.copy) {
                    return -1;
                }
                if (!p1.copy && p2.copy) {
                    return 1;
                }
                if (p1.rename && !p2.rename) {
                    return -1;
                }
                if (!p1.rename && p2.rename) {
                    return 1;
                }
                return 0;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPendingDeletes(List<SinglePatch> patches, List<PatchReport> report) throws IOException {
        for (SinglePatch patch : patches) {
            FileObject src;
            if (!patch.rename || !patch.applied || (src = FileUtil.toFileObject((File)patch.sourceFile)) == null) continue;
            FileLock lock = src.lock();
            try {
                src.delete(lock);
            }
            catch (IOException ex) {
                report.add(new PatchReport(patch.sourceFile, null, patch.binary, PatchStatus.Failure, ex));
            }
            finally {
                lock.releaseLock();
            }
        }
    }

    private void init() throws IOException {
        this.patchReader = new BufferedReader(new FileReader(this.patchFile));
        String encoding = "ISO-8859-1";
        String line = this.patchReader.readLine();
        if (MAGIC.equals(line)) {
            encoding = "utf8";
            line = this.patchReader.readLine();
        }
        this.patchReader.close();
        byte[] buffer = new byte[MAGIC.length()];
        FileInputStream in = new FileInputStream(this.patchFile);
        int read = ((InputStream)in).read(buffer);
        ((InputStream)in).close();
        if (read != -1 && MAGIC.equals(new String(buffer, "utf8"))) {
            encoding = "utf8";
        }
        this.patchReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.patchFile), encoding));
    }

    private void applyPatch(SinglePatch patch, boolean dryRun) throws IOException, PatchException {
        List<Object> target;
        this.lastPatchedLine = 1;
        patch.sourceFile = this.computeSourceFile(patch);
        patch.targetFile = this.computeTargetFile(patch);
        if (patch.sourceFile != null && patch.sourceFile.exists()) {
            if (patch.binary) {
                target = new ArrayList();
            } else {
                target = this.readFile(patch.sourceFile);
                if (this.patchCreatesNewFileThatAlreadyExists(patch, target)) {
                    return;
                }
            }
        } else if (patch.targetFile.exists() && !patch.binary) {
            target = this.readFile(patch.targetFile);
            if (this.patchCreatesNewFileThatAlreadyExists(patch, target)) {
                return;
            }
        } else {
            target = new ArrayList();
        }
        if (!patch.binary) {
            for (Hunk hunk : patch.hunks) {
                this.applyHunk(target, hunk);
            }
        }
        if (!dryRun) {
            if (patch.sourceFile != null) {
                this.backup(patch.sourceFile);
            }
            this.backup(patch.targetFile);
            this.writeFile(patch, target);
        }
    }

    private boolean patchCreatesNewFileThatAlreadyExists(SinglePatch patch, List<String> originalFile) throws PatchException {
        if (patch.hunks.length != 1) {
            return false;
        }
        Hunk hunk = patch.hunks[0];
        if (hunk.baseStart != 0 || hunk.baseCount != 0 || hunk.modifiedStart != 1 || hunk.modifiedCount != originalFile.size()) {
            return false;
        }
        ArrayList<String> target = new ArrayList<String>(hunk.modifiedCount);
        this.applyHunk(target, hunk);
        return target.equals(originalFile);
    }

    private void backup(File target) throws IOException {
        if (target.exists()) {
            this.copyStreamsCloseAll(new FileOutputStream(this.computeBackup(target)), new FileInputStream(target));
        }
    }

    private File computeBackup(File target) {
        return new File(target.getParentFile(), target.getName() + ".original~");
    }

    private void copyStreamsCloseAll(OutputStream writer, InputStream reader) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while ((n = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, n);
        }
        writer.close();
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(SinglePatch patch, List<String> lines) throws IOException {
        patch.targetFile.getParentFile().mkdirs();
        FileObject fo = null;
        if (fo == null) {
            fo = FileUtil.toFileObject((File)patch.targetFile);
        }
        if (fo == null) {
            fo = FileUtil.createData((File)patch.targetFile);
        }
        if (fo == null) {
            return;
        }
        if (patch.binary) {
            if (patch.hunks.length == 0) {
                if (!patch.rename) {
                    fo.delete();
                }
            } else {
                byte[] content = Base64.decode(patch.hunks[0].lines);
                this.copyStreamsCloseAll(fo.getOutputStream(), new ByteArrayInputStream(content));
            }
        } else {
            Charset charset = this.getEncoding(patch.targetFile);
            try (PrintWriter w = new PrintWriter(new OutputStreamWriter(fo.getOutputStream(), charset));){
                if (lines.size() == 0) {
                    return;
                }
                for (String line : lines.subList(0, lines.size() - 1)) {
                    w.println(line);
                }
                w.print(lines.get(lines.size() - 1));
                if (!patch.noEndingNewline) {
                    w.println();
                }
            }
        }
    }

    private void applyHunk(List<String> target, Hunk hunk) throws PatchException {
        int idx = this.findHunkIndex(target, hunk);
        if (idx == -1) {
            throw new PatchException("Cannot apply hunk @@ " + hunk.baseCount);
        }
        this.applyHunk(target, hunk, idx, false);
    }

    private int findHunkIndex(List<String> target, Hunk hunk) throws PatchException {
        int i;
        int idx = hunk.modifiedStart;
        if (idx >= this.lastPatchedLine && this.applyHunk(target, hunk, idx, true)) {
            return idx;
        }
        for (i = idx - 1; i >= this.lastPatchedLine; --i) {
            if (!this.applyHunk(target, hunk, i, true)) continue;
            return i;
        }
        for (i = idx + 1; i < target.size(); ++i) {
            if (!this.applyHunk(target, hunk, i, true)) continue;
            return i;
        }
        return -1;
    }

    private boolean applyHunk(List<String> target, Hunk hunk, int idx, boolean dryRun) throws PatchException {
        --idx;
        for (String hunkLine : hunk.lines) {
            String targetLine;
            boolean isAddition = this.isAdditionLine(hunkLine);
            if (!isAddition && !(targetLine = target.get(idx).trim()).equals(hunkLine.substring(1).trim())) {
                if (dryRun) {
                    return false;
                }
                throw new PatchException("Unapplicable hunk @@ " + hunk.baseStart);
            }
            if (dryRun) {
                if (isAddition) {
                    --idx;
                }
            } else if (isAddition) {
                target.add(idx, hunkLine.substring(1));
            } else if (this.isRemovalLine(hunkLine)) {
                target.remove(idx);
                --idx;
            }
            ++idx;
        }
        this.lastPatchedLine = ++idx;
        return true;
    }

    private boolean isAdditionLine(String hunkLine) {
        return hunkLine.charAt(0) == '+';
    }

    private boolean isRemovalLine(String hunkLine) {
        return hunkLine.charAt(0) == '-';
    }

    private Charset getEncoding(File file) {
        try {
            return FileEncodingQuery.getEncoding((FileObject)FileUtil.toFileObject((File)file));
        }
        catch (Throwable throwable) {
            return Charset.defaultCharset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFile(File target) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(target), this.getEncoding(target)));
        if (r == null) {
            r = new BufferedReader(new FileReader(target));
        }
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = r.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private SinglePatch getNextPatch() throws IOException, PatchException {
        SinglePatch patch = new SinglePatch();
        while (true) {
            String line;
            if ((line = this.readPatchLine()) == null) {
                if (patch.rename && patch.sourcePath != null && patch.targetPath != null) break;
                patch = null;
                break;
            }
            if (line.startsWith("Index:")) {
                patch.targetPath = line.substring(6).trim();
                continue;
            }
            if (line.startsWith("MIME: application/octet-stream;")) {
                this.unreadPatchLine();
                this.readBinaryPatchContent(patch);
                break;
            }
            if (line.startsWith("--- ")) {
                this.unreadPatchLine();
                this.readPatchContent(patch);
                break;
            }
            if (line.startsWith("*** ")) {
                this.unreadPatchLine();
                this.readContextPatchContent(patch);
                break;
            }
            if (this.isNormalDiffRange(line)) {
                this.unreadPatchLine();
                this.readNormalPatchContent(patch);
                break;
            }
            if (line.startsWith("rename from ")) {
                patch.sourcePath = line.substring(12);
                patch.rename = true;
                continue;
            }
            if (line.startsWith("rename to ")) {
                patch.targetPath = line.substring(10);
                continue;
            }
            if (line.startsWith("copy from ")) {
                patch.sourcePath = line.substring(10);
                patch.copy = true;
                continue;
            }
            if (!line.startsWith("copy to ")) continue;
            patch.targetPath = line.substring(8);
        }
        return patch;
    }

    private boolean isNormalDiffRange(String line) {
        return this.normalAddRangePattern.matcher(line).matches() || this.normalChangeRangePattern.matcher(line).matches() || this.normalDeleteRangePattern.matcher(line).matches();
    }

    private void readBinaryPatchContent(SinglePatch patch) throws PatchException, IOException {
        ArrayList<Hunk> hunks = new ArrayList<Hunk>();
        Hunk hunk = new Hunk();
        while (true) {
            String line;
            if ((line = this.readPatchLine()) == null || line.startsWith("Index:") || line.length() == 0) {
                this.unreadPatchLine();
                break;
            }
            if (patch.binary) {
                hunk.lines.add(line);
                continue;
            }
            Matcher m = this.binaryHeaderPattern.matcher(line);
            if (!m.matches()) continue;
            patch.binary = true;
            int length = Integer.parseInt(m.group(3));
            if (length == -1) break;
            hunks.add(hunk);
        }
        patch.hunks = hunks.toArray(new Hunk[hunks.size()]);
    }

    private void readNormalPatchContent(SinglePatch patch) throws IOException, PatchException {
        ArrayList<Hunk> hunks;
        block6: {
            String line;
            hunks = new ArrayList<Hunk>();
            Hunk hunk = null;
            while (true) {
                if ((line = this.readPatchLine()) == null || line.startsWith("Index:")) break block6;
                Matcher m = this.normalAddRangePattern.matcher(line);
                if (m.matches()) {
                    hunk = new Hunk();
                    hunks.add(hunk);
                    this.parseNormalRange(hunk, m);
                    continue;
                }
                m = this.normalChangeRangePattern.matcher(line);
                if (m.matches()) {
                    hunk = new Hunk();
                    hunks.add(hunk);
                    this.parseNormalRange(hunk, m);
                    continue;
                }
                m = this.normalDeleteRangePattern.matcher(line);
                if (m.matches()) {
                    hunk = new Hunk();
                    hunks.add(hunk);
                    this.parseNormalRange(hunk, m);
                    continue;
                }
                if (line.startsWith("> ")) {
                    hunk.lines.add("+" + line.substring(2));
                    continue;
                }
                if (line.startsWith("< ")) {
                    hunk.lines.add("-" + line.substring(2));
                    continue;
                }
                if (!line.startsWith("---")) break;
            }
            throw new PatchException("Invalid hunk line: " + line);
        }
        this.unreadPatchLine();
        patch.hunks = hunks.toArray(new Hunk[hunks.size()]);
    }

    private void parseNormalRange(Hunk hunk, Matcher m) {
        if (m.pattern() == this.normalAddRangePattern) {
            hunk.baseStart = Integer.parseInt(m.group(1));
            hunk.baseCount = 0;
            hunk.modifiedStart = Integer.parseInt(m.group(2));
            hunk.modifiedCount = Integer.parseInt(m.group(3)) - hunk.modifiedStart + 1;
        } else if (m.pattern() == this.normalDeleteRangePattern) {
            hunk.baseStart = Integer.parseInt(m.group(1));
            hunk.baseCount = Integer.parseInt(m.group(2)) - hunk.baseStart + 1;
            hunk.modifiedStart = Integer.parseInt(m.group(3));
            hunk.modifiedCount = 0;
        } else {
            hunk.baseStart = Integer.parseInt(m.group(1));
            hunk.baseCount = m.group(3) != null ? Integer.parseInt(m.group(3)) - hunk.baseStart + 1 : 1;
            hunk.modifiedStart = Integer.parseInt(m.group(4));
            hunk.modifiedCount = m.group(6) != null ? Integer.parseInt(m.group(6)) - hunk.modifiedStart + 1 : 1;
        }
    }

    private void readContextPatchContent(SinglePatch patch) throws IOException, PatchException {
        ArrayList<Hunk> hunks;
        block6: {
            String line;
            String base = this.readPatchLine();
            if (base == null || !base.startsWith("*** ")) {
                throw new PatchException("Invalid context diff header: " + base);
            }
            String modified = this.readPatchLine();
            if (modified == null || !modified.startsWith("--- ")) {
                throw new PatchException("Invalid context diff header: " + modified);
            }
            if (patch.targetPath == null) {
                this.computeTargetPath(base, modified, patch);
            }
            hunks = new ArrayList<Hunk>();
            Hunk hunk = null;
            int lineCount = -1;
            while (true) {
                if ((line = this.readPatchLine()) == null || line.length() == 0 || line.startsWith("Index:")) break block6;
                if (line.startsWith("***************")) {
                    hunk = new Hunk();
                    this.parseContextRange(hunk, this.readPatchLine());
                    hunks.add(hunk);
                    continue;
                }
                if (line.startsWith("--- ")) {
                    lineCount = 0;
                    this.parseContextRange(hunk, line);
                    hunk.lines.add(line);
                    continue;
                }
                char c = line.charAt(0);
                if (c != ' ' && c != '+' && c != '-' && c != '!') break;
                if (lineCount >= hunk.modifiedCount) continue;
                hunk.lines.add(line);
                if (lineCount == -1) continue;
                ++lineCount;
            }
            throw new PatchException("Invalid hunk line: " + line);
        }
        this.unreadPatchLine();
        patch.hunks = hunks.toArray(new Hunk[hunks.size()]);
        this.convertContextToUnified(patch);
    }

    private void convertContextToUnified(SinglePatch patch) throws PatchException {
        Hunk[] unifiedHunks = new Hunk[patch.hunks.length];
        int idx = 0;
        for (Hunk hunk : patch.hunks) {
            unifiedHunks[idx++] = this.convertContextToUnified(hunk);
        }
        patch.hunks = unifiedHunks;
    }

    private Hunk convertContextToUnified(Hunk hunk) throws PatchException {
        Hunk unifiedHunk = new Hunk();
        unifiedHunk.baseStart = hunk.baseStart;
        unifiedHunk.modifiedStart = hunk.modifiedStart;
        int split = -1;
        for (int i = 0; i < hunk.lines.size(); ++i) {
            if (!hunk.lines.get(i).startsWith("--- ")) continue;
            split = i;
            break;
        }
        if (split == -1) {
            throw new PatchException("Missing split divider in context patch");
        }
        int baseIdx = 0;
        int modifiedIdx = split + 1;
        ArrayList<String> unifiedLines = new ArrayList<String>(hunk.lines.size());
        while (baseIdx < split || modifiedIdx < hunk.lines.size()) {
            String modifiedLine;
            String baseLine = baseIdx < split ? hunk.lines.get(baseIdx) : "~";
            String string = modifiedLine = modifiedIdx < hunk.lines.size() ? hunk.lines.get(modifiedIdx) : "~";
            if (baseLine.startsWith("- ")) {
                unifiedLines.add("-" + baseLine.substring(2));
                ++unifiedHunk.baseCount;
                ++baseIdx;
                continue;
            }
            if (modifiedLine.startsWith("+ ")) {
                unifiedLines.add("+" + modifiedLine.substring(2));
                ++unifiedHunk.modifiedCount;
                ++modifiedIdx;
                continue;
            }
            if (baseLine.startsWith("! ")) {
                unifiedLines.add("-" + baseLine.substring(2));
                ++unifiedHunk.baseCount;
                ++baseIdx;
                continue;
            }
            if (modifiedLine.startsWith("! ")) {
                unifiedLines.add("+" + modifiedLine.substring(2));
                ++unifiedHunk.modifiedCount;
                ++modifiedIdx;
                continue;
            }
            if (baseLine.startsWith("  ") && modifiedLine.startsWith("  ")) {
                unifiedLines.add(baseLine.substring(1));
                ++unifiedHunk.baseCount;
                ++unifiedHunk.modifiedCount;
                ++baseIdx;
                ++modifiedIdx;
                continue;
            }
            if (baseLine.startsWith("  ")) {
                unifiedLines.add(baseLine.substring(1));
                ++unifiedHunk.baseCount;
                ++unifiedHunk.modifiedCount;
                ++baseIdx;
                continue;
            }
            if (modifiedLine.startsWith("  ")) {
                unifiedLines.add(modifiedLine.substring(1));
                ++unifiedHunk.baseCount;
                ++unifiedHunk.modifiedCount;
                ++modifiedIdx;
                continue;
            }
            throw new PatchException("Invalid context patch: " + baseLine);
        }
        unifiedHunk.lines = unifiedLines;
        return unifiedHunk;
    }

    private void readPatchContent(SinglePatch patch) throws IOException, PatchException {
        ArrayList<Hunk> hunks;
        block7: {
            String base = this.readPatchLine();
            if (base == null || !base.startsWith("--- ")) {
                throw new PatchException("Invalid unified diff header: " + base);
            }
            String modified = this.readPatchLine();
            if (modified == null || !modified.startsWith("+++ ")) {
                throw new PatchException("Invalid unified diff header: " + modified);
            }
            if (patch.targetPath == null) {
                this.computeTargetPath(base, modified, patch);
            }
            hunks = new ArrayList<Hunk>();
            Hunk hunk = null;
            while (true) {
                String line;
                if ((line = this.readPatchLine()) == null || line.length() == 0 || line.startsWith("Index:")) {
                    this.unreadPatchLine();
                    break block7;
                }
                char c = line.charAt(0);
                if (c == '@') {
                    hunk = new Hunk();
                    this.parseRange(hunk, line);
                    hunks.add(hunk);
                    continue;
                }
                if (c == ' ' || c == '+' || c == '-') {
                    hunk.lines.add(line);
                    continue;
                }
                if (!line.equals("\\ No newline at end of file")) break;
                patch.noEndingNewline = true;
            }
            this.unreadPatchLine();
        }
        patch.hunks = hunks.toArray(new Hunk[hunks.size()]);
    }

    private void computeTargetPath(String base, String modified, SinglePatch patch) {
        base = base.substring("+++ ".length());
        modified = modified.substring("--- ".length());
        if (base.startsWith("a/") && modified.startsWith("b/")) {
            base = base.substring(2);
        } else if (base.startsWith("/dev/null") && modified.startsWith("b/")) {
            modified = modified.substring(2);
        } else if (base.startsWith("a/") && modified.startsWith("/dev/null")) {
            base = base.substring(2);
        }
        String target = base.startsWith("/dev/null") ? modified : base;
        int pathEndIdx = target.indexOf(9);
        if (pathEndIdx == -1) {
            pathEndIdx = target.length();
        }
        patch.targetPath = target.substring(0, pathEndIdx).trim();
    }

    private void parseRange(Hunk hunk, String range) throws PatchException {
        Matcher m = this.unifiedRangePattern.matcher(range);
        if (!m.matches()) {
            throw new PatchException("Invalid unified diff range: " + range);
        }
        hunk.baseStart = Integer.parseInt(m.group(1));
        hunk.baseCount = m.group(2) != null ? Integer.parseInt(m.group(2).substring(1)) : 1;
        hunk.modifiedStart = Integer.parseInt(m.group(3));
        hunk.modifiedCount = m.group(4) != null ? Integer.parseInt(m.group(4).substring(1)) : 1;
    }

    private void parseContextRange(Hunk hunk, String range) throws PatchException {
        if (range.charAt(0) == '*') {
            Matcher m = this.baseRangePattern.matcher(range);
            if (!m.matches()) {
                throw new PatchException("Invalid context diff range: " + range);
            }
            hunk.baseStart = Integer.parseInt(m.group(1));
            hunk.baseCount = m.group(2) != null ? Integer.parseInt(m.group(2).substring(1)) : 1;
            hunk.baseCount -= hunk.baseStart - 1;
        } else {
            Matcher m = this.modifiedRangePattern.matcher(range);
            if (!m.matches()) {
                throw new PatchException("Invalid context diff range: " + range);
            }
            hunk.modifiedStart = Integer.parseInt(m.group(1));
            hunk.modifiedCount = m.group(2) != null ? Integer.parseInt(m.group(2).substring(1)) : 1;
            hunk.modifiedCount -= hunk.modifiedStart - 1;
        }
    }

    private String readPatchLine() throws IOException {
        if (this.patchLineRead) {
            this.patchLine = this.patchReader.readLine();
        } else {
            this.patchLineRead = true;
        }
        return this.patchLine;
    }

    private void unreadPatchLine() {
        this.patchLineRead = false;
    }

    private void computeContext(List<SinglePatch> patches) {
        File bestContext = this.suggestedContext;
        int bestContextMatched = 0;
        this.context = this.suggestedContext;
        while (this.context != null) {
            int patchedFiles = 0;
            for (SinglePatch patch : patches) {
                try {
                    this.applyPatch(patch, true);
                    ++patchedFiles;
                }
                catch (Exception e) {}
            }
            if (patchedFiles > bestContextMatched) {
                bestContextMatched = patchedFiles;
                bestContext = this.context;
                if (patchedFiles == patches.size()) break;
            }
            this.context = this.context.getParentFile();
        }
        this.context = bestContext;
    }

    private File computeSourceFile(SinglePatch patch) {
        if (patch.sourcePath == null) {
            return null;
        }
        if (this.context.isFile()) {
            return this.context;
        }
        return new File(this.context, patch.sourcePath);
    }

    private File computeTargetFile(SinglePatch patch) {
        if (patch.targetPath == null) {
            patch.targetPath = this.context.getAbsolutePath();
        }
        if (this.context.isFile()) {
            return this.context;
        }
        return new File(this.context, patch.targetPath);
    }

    public static final class PatchReport {
        private File file;
        private File originalBackupFile;
        private boolean binary;
        private PatchStatus status;
        private Throwable failure;

        PatchReport(File file, File originalBackupFile, boolean binary, PatchStatus status, Throwable failure) {
            this.file = file;
            this.originalBackupFile = originalBackupFile;
            this.binary = binary;
            this.status = status;
            this.failure = failure;
        }

        public File getFile() {
            return this.file;
        }

        public File getOriginalBackupFile() {
            return this.originalBackupFile;
        }

        public boolean isBinary() {
            return this.binary;
        }

        public PatchStatus getStatus() {
            return this.status;
        }

        public Throwable getFailure() {
            return this.failure;
        }
    }

    public static enum PatchStatus {
        Patched,
        Missing,
        Failure;

    }

    private class SinglePatch {
        String targetPath;
        Hunk[] hunks = new Hunk[0];
        boolean targetMustExist = true;
        File targetFile;
        boolean noEndingNewline;
        boolean binary;
        boolean copy;
        boolean rename;
        String sourcePath;
        File sourceFile;
        boolean applied;

        private SinglePatch() {
        }
    }
}

