/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.navigation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.EditorExtender;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.index.IndexedElement;
import org.netbeans.modules.javascript2.editor.index.JsIndex;
import org.netbeans.modules.javascript2.editor.lexer.JsDocumentationTokenId;
import org.netbeans.modules.javascript2.editor.model.JsElement;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Model;
import org.netbeans.modules.javascript2.editor.model.Occurrence;
import org.netbeans.modules.javascript2.editor.model.OccurrencesSupport;
import org.netbeans.modules.javascript2.editor.model.Type;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class DeclarationFinderImpl
implements DeclarationFinder {
    private final Language<JsTokenId> language;

    public DeclarationFinderImpl(Language<JsTokenId> language) {
        this.language = language;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int caretOffset) {
        FileObject fileObject;
        JsObject object;
        if (!(info instanceof JsParserResult)) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        JsParserResult jsResult = (JsParserResult)info;
        Model model = jsResult.getModel();
        model.resolve();
        int offset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        OccurrencesSupport os = model.getOccurrencesSupport();
        Occurrence occurrence = os.getOccurrence(offset);
        if (occurrence != null) {
            FileObject fo;
            Collection<? extends TypeUsage> assignments;
            object = occurrence.getDeclarations().iterator().next();
            JsObject jsObject = object.getParent();
            Collection<? extends TypeUsage> collection = assignments = jsObject == null ? null : jsObject.getAssignmentForOffset(offset);
            if (assignments != null && assignments.isEmpty()) {
                assignments = jsObject.getAssignments();
            }
            Snapshot snapshot = jsResult.getSnapshot();
            JsIndex jsIndex = JsIndex.get(snapshot.getSource().getFileObject());
            ArrayList<IndexResult> arrayList = new ArrayList<IndexResult>();
            if (assignments == null || assignments.isEmpty()) {
                fo = object.getFileObject();
                if (object.isDeclared()) {
                    if (fo != null) {
                        TokenSequence<? extends JsTokenId> ts;
                        if (!fo.equals(snapshot.getSource().getFileObject()) || object.getDeclarationName() == null) return new DeclarationFinder.DeclarationLocation(fo, this.getDeclarationOffset(object), (ElementHandle)object);
                        int docOffset = LexUtilities.getLexerOffset(jsResult, this.getDeclarationOffset(object));
                        if (docOffset > -1 && (ts = LexUtilities.getTokenSequence(snapshot, caretOffset, this.language)) != null) {
                            int docTsOffset;
                            ts.move(offset);
                            if (ts.moveNext() && ((docTsOffset = LexUtilities.getLexerOffset(jsResult, ts.offset())) > docOffset || docOffset > docTsOffset + ts.token().length())) {
                                return new DeclarationFinder.DeclarationLocation(fo, docOffset, (ElementHandle)object);
                            }
                        }
                    }
                } else {
                    void var9_13;
                    JsObject property;
                    int partIndex;
                    void var9_11;
                    Collection<? extends IndexResult> items = JsIndex.get(fo).findByFqn(object.getFullyQualifiedName(), JsIndex.TERMS_BASIC_INFO);
                    arrayList.addAll(items);
                    DeclarationFinder.DeclarationLocation location = this.processIndexResult(arrayList);
                    if (location != null) {
                        return location;
                    }
                    String fqn = object.getFullyQualifiedName();
                    String[] stringArray = fqn.split("\\.");
                    JsObject jsObject2 = object;
                    while (var9_11 != null && !stringArray[0].equals(var9_11.getFullyQualifiedName())) {
                        JsObject jsObject3 = var9_11.getParent();
                    }
                    if (var9_11 == null) {
                        return DeclarationFinder.DeclarationLocation.NONE;
                    }
                    for (partIndex = 1; partIndex < stringArray.length && (property = var9_13.getProperty(stringArray[partIndex])) != null && property.isDeclared(); ++partIndex) {
                        JsObject jsObject4 = property;
                    }
                    String lastDefinedFQN = var9_13.getFullyQualifiedName();
                    ArrayList<IndexResult> rItems = new ArrayList<IndexResult>();
                    if (partIndex < stringArray.length) {
                        rItems.addAll(this.findPropertyOfType(jsIndex, lastDefinedFQN.toString(), stringArray[partIndex]));
                        JsObject jsObject5 = this.findPropertyOrParameterInModel((JsObject)var9_13, stringArray[partIndex]);
                        for (int i = ++partIndex; !rItems.isEmpty() && i < stringArray.length; ++i) {
                            Collection<? extends TypeUsage> assigns;
                            void var9_16;
                            ArrayList<IndexResult> arrayList2 = new ArrayList<IndexResult>(rItems);
                            rItems.clear();
                            for (IndexResult indexResult : arrayList2) {
                                rItems.addAll(this.findPropertyOfType(jsIndex, IndexedElement.getFQN(indexResult), stringArray[i]));
                            }
                            if (rItems.isEmpty() && var9_16 != null && !(assigns = var9_16.getAssignments()).isEmpty()) {
                                for (Type type : assigns) {
                                    String afqn = this.getFQNFromType(type);
                                    rItems.addAll(this.findPropertyOfType(jsIndex, afqn, stringArray[i]));
                                }
                            }
                            if (var9_16 == null) continue;
                            JsObject jsObject6 = this.findPropertyOrParameterInModel((JsObject)var9_16, stringArray[i]);
                        }
                    }
                    if ((location = this.processIndexResult(rItems)) != null) {
                        return location;
                    }
                }
            } else {
                TokenSequence<? extends JsTokenId> ts;
                fo = object.getFileObject();
                if (object.isDeclared() && fo != null) {
                    if (!fo.equals(snapshot.getSource().getFileObject())) return new DeclarationFinder.DeclarationLocation(fo, this.getDeclarationOffset(object), (ElementHandle)object);
                    int docOffset = LexUtilities.getLexerOffset(jsResult, this.getDeclarationOffset(object));
                    if (docOffset > -1) {
                        return new DeclarationFinder.DeclarationLocation(fo, docOffset, (ElementHandle)object);
                    }
                }
                if ((ts = LexUtilities.getTokenSequence(snapshot, caretOffset, this.language)) != null) {
                    ts.move(offset);
                    if (ts.moveNext() && ts.token().id() == JsTokenId.IDENTIFIER) {
                        String propertyName = ts.token().text().toString();
                        for (Type type : assignments) {
                            String fqn = this.getFQNFromType(type);
                            Collection<? extends IndexResult> items = this.findPropertyOfType(jsIndex, fqn, propertyName);
                            if (items.isEmpty()) {
                                Collection<? extends IndexResult> tmpItems = jsIndex.findByFqn(fqn, JsIndex.TERMS_BASIC_INFO);
                                for (IndexResult indexResult : tmpItems) {
                                    Collection<TypeUsage> tmpAssignments = IndexedElement.getAssignments(indexResult);
                                    for (Type type2 : tmpAssignments) {
                                        items = this.findPropertyOfType(jsIndex, this.getFQNFromType(type2), propertyName);
                                        arrayList.addAll(items);
                                    }
                                }
                                continue;
                            }
                            arrayList.addAll(items);
                        }
                        DeclarationFinder.DeclarationLocation location = this.processIndexResult(arrayList);
                        if (location != null) {
                            return location;
                        }
                    }
                }
            }
        }
        for (DeclarationFinder declarationFinder : EditorExtender.getDefault().getDeclarationFinders()) {
            DeclarationFinder.DeclarationLocation loc = declarationFinder.findDeclaration(info, caretOffset);
            if (loc == null || loc == DeclarationFinder.DeclarationLocation.NONE) continue;
            return loc;
        }
        if (occurrence == null || (fileObject = (object = occurrence.getDeclarations().iterator().next()).getFileObject()) == null || object.getName() == null) return DeclarationFinder.DeclarationLocation.NONE;
        Collection<? extends IndexResult> items = JsIndex.get(fileObject).query("bn", object.getName(), QuerySupport.Kind.EXACT, JsIndex.TERMS_BASIC_INFO);
        ArrayList<IndexResult> indexResults = new ArrayList<IndexResult>();
        for (IndexResult indexResult : items) {
            IndexedElement element = IndexedElement.create(indexResult);
            if (element.getModifiers().contains(Modifier.PRIVATE) || element.getJSKind() == JsElement.Kind.PARAMETER) continue;
            indexResults.add(indexResult);
        }
        DeclarationFinder.DeclarationLocation location = this.processIndexResult(indexResults);
        if (location == null) return DeclarationFinder.DeclarationLocation.NONE;
        return location;
    }

    private int getDeclarationOffset(JsObject object) {
        return object.getDeclarationName() != null ? object.getDeclarationName().getOffsetRange().getStart() : object.getOffset();
    }

    private JsObject findPropertyOrParameterInModel(JsObject parent, String name) {
        JsObject object = parent.getProperty(name);
        if (object == null && parent instanceof JsFunction) {
            object = ((JsFunction)parent).getParameter(name);
        }
        return object;
    }

    private Collection<? extends IndexResult> findPropertyOfType(JsIndex jsIndex, String fqn, String propertyName) {
        return this.findPropertyOfType(jsIndex, fqn, propertyName, 0);
    }

    private Collection<? extends IndexResult> findPropertyOfType(JsIndex jsIndex, String fqn, String propertyName, int count) {
        ArrayList<Object> items = new ArrayList<Object>();
        if (count > 5) {
            return items;
        }
        items.addAll(jsIndex.findByFqn(fqn + "." + propertyName, JsIndex.TERMS_BASIC_INFO));
        if (items.isEmpty()) {
            items.addAll(jsIndex.findByFqn(fqn + ".prototype." + propertyName, JsIndex.TERMS_BASIC_INFO));
        }
        if (items.isEmpty()) {
            Collection<? extends IndexResult> findByFqn = jsIndex.findByFqn(fqn, JsIndex.TERMS_BASIC_INFO);
            for (IndexResult indexResult : findByFqn) {
                Collection<TypeUsage> assignments = IndexedElement.getAssignments(indexResult);
                for (Type type : assignments) {
                    items.addAll(this.findPropertyOfType(jsIndex, this.getFQNFromType(type), propertyName, count++));
                }
            }
        }
        return items;
    }

    private String getFQNFromType(Type type) {
        String fqn = type.getType();
        if (fqn.startsWith("@exp;")) {
            fqn = fqn.substring("@exp;".length());
        }
        if (fqn.contains("@pro;")) {
            fqn = fqn.replace("@pro;", ".");
        }
        return fqn;
    }

    private DeclarationFinder.DeclarationLocation processIndexResult(List<IndexResult> indexResults) {
        if (!indexResults.isEmpty()) {
            IndexResult iResult = indexResults.get(0);
            String value = iResult.getValue("offset");
            int offset = Integer.parseInt(value);
            HashSet<String> alreadyThere = new HashSet<String>();
            DeclarationFinder.DeclarationLocation location = new DeclarationFinder.DeclarationLocation(iResult.getFile(), offset, (ElementHandle)IndexedElement.create(iResult));
            alreadyThere.add(iResult.getFile().getPath() + offset);
            if (indexResults.size() > 1) {
                for (int i = 0; i < indexResults.size(); ++i) {
                    iResult = indexResults.get(i);
                    if (alreadyThere.contains(iResult.getFile().getPath() + offset)) continue;
                    location.addAlternative((DeclarationFinder.AlternativeLocation)new AlternativeLocationImpl(iResult));
                    alreadyThere.add(iResult.getFile().getPath() + offset);
                }
            }
            return location;
        }
        return null;
    }

    public OffsetRange getReferenceSpan(final Document doc, final int caretOffset) {
        if (doc == null) {
            return OffsetRange.NONE;
        }
        final OffsetRange[] value = new OffsetRange[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenSequence<? extends JsTokenId> ts = LexUtilities.getTokenSequence(doc, caretOffset, (Language<JsTokenId>)DeclarationFinderImpl.this.language);
                if (ts != null) {
                    TokenSequence tsDoc;
                    ts.move(caretOffset);
                    if (ts.moveNext() && ts.token().id() == JsTokenId.IDENTIFIER) {
                        value[0] = new OffsetRange(ts.offset(), ts.offset() + ts.token().length());
                    } else if (ts.token() != null && ts.token().id() == JsTokenId.DOC_COMMENT && (tsDoc = LexerUtils.getTokenSequence((Document)doc, (int)caretOffset, JsDocumentationTokenId.language(), (boolean)true)) != null && tsDoc.token() != null && tsDoc.token().id() == JsDocumentationTokenId.OTHER && tsDoc.moveNext() && tsDoc.token().id() == JsDocumentationTokenId.BRACKET_RIGHT_CURLY && tsDoc.movePrevious() && tsDoc.movePrevious() && tsDoc.token().id() == JsDocumentationTokenId.BRACKET_LEFT_CURLY) {
                        tsDoc.moveNext();
                        value[0] = new OffsetRange(tsDoc.offset(), tsDoc.offset() + tsDoc.token().length());
                    }
                }
            }
        });
        if (value[0] != null) {
            return value[0];
        }
        for (DeclarationFinder declarationFinder : EditorExtender.getDefault().getDeclarationFinders()) {
            OffsetRange result = declarationFinder.getReferenceSpan(doc, caretOffset);
            if (result == null || result == OffsetRange.NONE) continue;
            return result;
        }
        return OffsetRange.NONE;
    }

    @SuppressWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public static class AlternativeLocationImpl
    implements DeclarationFinder.AlternativeLocation {
        private final IndexResult iResult;
        private final int offset;
        private final DeclarationFinder.DeclarationLocation location;
        private final IndexedElement element;

        public AlternativeLocationImpl(IndexResult iResult) {
            this.iResult = iResult;
            String value = iResult.getValue("offset");
            this.offset = Integer.parseInt(value);
            this.location = new DeclarationFinder.DeclarationLocation(iResult.getFile(), this.offset);
            this.element = IndexedElement.create(iResult);
        }

        public ElementHandle getElement() {
            return this.element;
        }

        private String getStringLocation() {
            List asLines;
            int lineNumber = 0;
            int count = 0;
            try {
                asLines = this.element.getFileObject().asLines();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                asLines = null;
            }
            if (asLines != null) {
                for (String line : asLines) {
                    ++lineNumber;
                    if ((count += line.length()) < this.offset) continue;
                    break;
                }
            }
            String result = this.iResult.getRelativePath();
            if (lineNumber > 0) {
                result = result + " : " + lineNumber;
            }
            return result;
        }

        public String getDisplayHtml(HtmlFormatter formatter) {
            formatter.appendText(this.getStringLocation());
            return formatter.getText();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return this.location;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation o) {
            AlternativeLocationImpl ali = (AlternativeLocationImpl)o;
            return this.getStringLocation().compareTo(ali.getStringLocation());
        }
    }
}

