/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.js.frames.models;

import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.modules.debugger.jpda.js.frames.JSStackFrame;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class DebuggingJSTreeModel
implements TreeModelFilter {
    private static final String FILTER1 = "java.lang.invoke.LambdaForm";
    private static final String FILTER2 = "jdk.nashorn.";

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        Object[] jsChildren;
        Object[] children = original.getChildren(parent, from, to);
        if (parent instanceof DebuggingView.DVThread && (jsChildren = DebuggingJSTreeModel.createChildrenWithJSStack(children)) != null) {
            children = DebuggingJSTreeModel.filterChildren(jsChildren);
        }
        return children;
    }

    static Object[] createChildrenWithJSStack(Object[] children) {
        boolean isJSStack = false;
        for (int i = 0; i < children.length; ++i) {
            CallStackFrame csf;
            Object ch = children[i];
            if (!(ch instanceof CallStackFrame) || !(csf = (CallStackFrame)ch).getClassName().startsWith("jdk.nashorn.internal.scripts.Script$")) continue;
            if (!isJSStack) {
                Object[] children2 = new Object[children.length];
                System.arraycopy(children, 0, children2, 0, children.length);
                children = children2;
            }
            children[i] = JSStackFrame.get(csf);
            isJSStack = true;
        }
        if (isJSStack) {
            return children;
        }
        return null;
    }

    static Object[] filterChildren(Object[] children) {
        ArrayList<Object> newChildren = new ArrayList<Object>(children.length);
        newChildren.addAll(Arrays.asList(children));
        for (int i = 0; i < newChildren.size(); ++i) {
            String className;
            Object ch = newChildren.get(i);
            if (!(ch instanceof CallStackFrame) || !(className = ((CallStackFrame)ch).getClassName()).startsWith(FILTER1) && !className.startsWith(FILTER2)) continue;
            newChildren.remove(i);
            --i;
        }
        return newChildren.toArray();
    }

    public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
        return original.getChildrenCount(node);
    }

    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        if (node instanceof JSStackFrame) {
            return true;
        }
        return original.isLeaf(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }
}

