/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.GenericToolbar;
import org.openide.util.Lookup;

public abstract class ProfilerToolbar {
    public static ProfilerToolbar create(boolean showSeparator) {
        Provider provider = (Provider)Lookup.getDefault().lookup(Provider.class);
        return provider != null ? provider.create(showSeparator) : new Impl(showSeparator);
    }

    public abstract JComponent getComponent();

    public Component add(ProfilerToolbar toolbar) {
        return toolbar.getComponent();
    }

    public Component add(ProfilerToolbar toolbar, int index) {
        return toolbar.getComponent();
    }

    public void remove(ProfilerToolbar toolbar) {
    }

    public abstract Component add(Action var1);

    public abstract Component add(Component var1);

    public abstract Component add(Component var1, int var2);

    public abstract void addSeparator();

    public abstract void addSpace(int var1);

    public abstract void addFiller();

    public abstract void remove(Component var1);

    public abstract void remove(int var1);

    public abstract int getComponentCount();

    protected ProfilerToolbar() {
    }

    public static class SimpleFocusTraversalPolicy
    extends FocusTraversalPolicy {
        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            List<Component> l = this.components(this.topContainer(aContainer));
            int i = l.indexOf(aComponent);
            return i == -1 || i == l.size() - 1 ? null : l.get(i + 1);
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            List<Component> l = this.components(this.topContainer(aContainer));
            int i = l.indexOf(aComponent);
            return i == -1 || i == 0 ? null : l.get(i - 1);
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            List<Component> l = this.components(this.topContainer(aContainer));
            return l.isEmpty() ? null : l.get(0);
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            List<Component> l = this.components(this.topContainer(aContainer));
            return l.isEmpty() ? null : l.get(l.size() - 1);
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            return this.getFirstComponent(aContainer);
        }

        protected Container topContainer(Container aContainer) {
            while (aContainer.getParent() instanceof JToolBar) {
                aContainer = aContainer.getParent();
            }
            return aContainer;
        }

        protected List<Component> components(Container aContainer) {
            ArrayList<Component> l = new ArrayList<Component>();
            for (int i = 0; i < aContainer.getComponentCount(); ++i) {
                Component c = aContainer.getComponent(i);
                if (c instanceof JToolBar || c instanceof JPanel) {
                    l.addAll(this.components((Container)c));
                    continue;
                }
                if (!this.focusable(c)) continue;
                l.add(c);
            }
            return l;
        }

        protected boolean focusable(Component c) {
            return c.isVisible() && c.isEnabled() && c.isFocusable();
        }
    }

    public static class Impl
    extends ProfilerToolbar {
        protected final JComponent component;
        protected final JToolBar toolbar = new GenericToolbar();

        protected Impl(boolean showSeparator) {
            if (UIUtils.isWindowsModernLookAndFeel()) {
                this.toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
            } else if (!UIUtils.isNimbusLookAndFeel() && !UIUtils.isAquaLookAndFeel()) {
                this.toolbar.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
            }
            this.toolbar.setBorderPainted(false);
            this.toolbar.setRollover(true);
            this.toolbar.setFloatable(false);
            this.toolbar.setFocusTraversalPolicyProvider(true);
            this.toolbar.setFocusTraversalPolicy(new SimpleFocusTraversalPolicy());
            if (showSeparator) {
                this.component = new JPanel(new BorderLayout(0, 0));
                this.component.setOpaque(false);
                this.component.add((Component)this.toolbar, "Center");
                this.component.add((Component)UIUtils.createHorizontalLine(this.toolbar.getBackground()), "South");
            } else {
                this.component = this.toolbar;
            }
        }

        @Override
        public JComponent getComponent() {
            return this.component;
        }

        @Override
        public Component add(ProfilerToolbar toolbar) {
            return this.add(toolbar, this.getComponentCount());
        }

        @Override
        public Component add(ProfilerToolbar toolbar, int index) {
            JToolBar implToolbar = ((Impl)toolbar).toolbar;
            implToolbar.setBorder(BorderFactory.createEmptyBorder());
            implToolbar.setOpaque(false);
            implToolbar.putClientProperty("Toolbar.noGTKBorder", Boolean.TRUE);
            return this.add(implToolbar, index);
        }

        @Override
        public void remove(ProfilerToolbar toolbar) {
            this.remove(((Impl)toolbar).toolbar);
        }

        @Override
        public Component add(Action action) {
            JButton c = this.toolbar.add(action);
            this.toolbar.repaint();
            return c;
        }

        @Override
        public Component add(Component component) {
            Component c = this.toolbar.add(component);
            this.toolbar.repaint();
            return c;
        }

        @Override
        public Component add(Component component, int index) {
            Component c = this.toolbar.add(component, index);
            this.toolbar.repaint();
            return c;
        }

        @Override
        public void addSeparator() {
            this.toolbar.addSeparator();
            this.toolbar.repaint();
        }

        @Override
        public void addSpace(int width) {
            this.toolbar.addSeparator(new Dimension(width, 0));
            this.toolbar.repaint();
        }

        @Override
        public void addFiller() {
            Dimension minDim = new Dimension(0, 0);
            Dimension maxDim = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.toolbar.add(new Box.Filler(minDim, minDim, maxDim));
            this.toolbar.repaint();
        }

        @Override
        public void remove(Component component) {
            this.toolbar.remove(component);
            this.toolbar.repaint();
        }

        @Override
        public void remove(int index) {
            this.toolbar.remove(index);
            this.toolbar.repaint();
        }

        @Override
        public int getComponentCount() {
            return this.toolbar.getComponentCount();
        }
    }

    public static abstract class Provider {
        public abstract ProfilerToolbar create(boolean var1);
    }
}

